/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.SetRoundCornersPanel;

public class SetBorderRoundCornersPanel
extends JPanel
implements ActionListener,
FocusListener {
    private JButton applyButton;
    private ReportMain reportMain;
    private ReportElement elt;
    private SetRoundCornersPanel setRoundCornersPanel;

    public SetBorderRoundCornersPanel(ReportMain reportMain) {
        this(reportMain, null);
    }

    public SetBorderRoundCornersPanel(ReportMain reportMain, ReportElement elt) {
        this.reportMain = reportMain;
        this.elt = elt;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setRoundCornersPanel = this.elt != null ? new SetRoundCornersPanel(this.elt, this.reportMain) : new SetRoundCornersPanel(this.reportMain);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        this.applyButton = new JButton(LanguageEncoder.getText("Apply"));
        this.applyButton.addActionListener(this);
        buttonPanel.add(this.applyButton);
        if (this.elt != null && ReportElement.doesElementSupportRoundCorners(this.elt)) {
            this.add("Center", this.setRoundCornersPanel);
        }
        this.add("South", buttonPanel);
    }

    public void reinitializePanel() {
        this.removeAll();
        this.init();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object eventSrc = e.getSource();
        if (eventSrc == this.applyButton) {
            this.saveChanges();
            this.reportMain.designPanel.rulerPanel.repaintPanel();
            this.reportMain.setModified();
        }
        this.refreshRoundCornersPreviewPanel();
    }

    private void refreshRoundCornersPreviewPanel() {
        this.setRoundCornersPanel.refreshPreviewPanel();
    }

    private void saveChanges() {
        this.setRoundCornersPanel.saveChanges();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.refreshRoundCornersPreviewPanel();
    }
}

