/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.SetBoundsPanel;
import quadbase.reportdesigner.designer.SetRoundCornersPanel;

public class SetBoundsDialog
extends JDialog
implements ActionListener,
ItemListener {
    private JButton okButton;
    private JButton cancelButton;
    private ReportElement elt;
    private ReportMain reportMain;
    private SetRoundCornersPanel setRoundCornersPanel;
    private SetBoundsPanel setBoundsPanel;
    boolean groupSelect = false;
    private int row;

    public SetBoundsDialog(ReportMain reportMain, ReportElement elt, int row) {
        super(reportMain, LanguageEncoder.getText("Bounds ..."), true);
        this.reportMain = reportMain;
        this.elt = elt;
        this.row = row;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.setBoundsPanel = new SetBoundsPanel(this.reportMain, this.elt, this.row);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        if (ReportElement.doesElementSupportRoundCorners(this.elt)) {
            this.setRoundCornersPanel = new SetRoundCornersPanel(this.elt, this.reportMain);
            contentPane.add("Center", this.setRoundCornersPanel);
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add("North", this.setBoundsPanel);
        contentPane.add("South", buttonPanel);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.setRoundCornersPanel != null) {
                this.setRoundCornersPanel.saveChanges();
            }
            this.setBoundsPanel.saveChanges();
            this.reportMain.repaintPanel(this.reportMain.selectedPanel);
            this.reportMain.clearAllDraggedObjects();
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }
}

