/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.text.NumberFormatter;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.FormattedCell;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.crosstab.CrossTabHelper;

public class SetBoundsPanel
extends JPanel
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(SetBoundsPanel.class.getName());
    private ReportElement elt;
    private ReportMain reportMain;
    private JFormattedTextField widthField;
    private JFormattedTextField heightField;
    private JFormattedTextField xField;
    private JFormattedTextField yField;
    private JLabel xLabel;
    private JLabel yLabel;
    private JCheckBox matchColumnWidthsBox;
    private JCheckBox resizeToFitSectionHeight;
    private JCheckBox wBox;
    private JCheckBox hBox;
    boolean groupSelect = false;
    private boolean showApplyButton;
    private int row;
    private Vector<Integer> tree = null;
    private JButton applyButton;

    public SetBoundsPanel(ReportMain reportMain, ReportElement elt, boolean showApplyButton) {
        this.reportMain = reportMain;
        this.elt = elt;
        this.showApplyButton = showApplyButton;
        this.init();
    }

    public SetBoundsPanel(ReportMain reportMain, ReportElement elt, int row) {
        this.reportMain = reportMain;
        this.elt = elt;
        this.row = row;
        this.showApplyButton = false;
        this.init();
    }

    private void init() {
        String units;
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Bounds ...")));
        this.setLayout(new BorderLayout());
        JPanel dimensionPanel = new JPanel();
        dimensionPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Dimension")));
        dimensionPanel.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        String string = units = this.reportMain.isCm ? LanguageEncoder.getText("cms") : LanguageEncoder.getText("inches");
        if (this.elt instanceof ReportLine) {
            labelPanel.add(new JLabel(LanguageEncoder.getText("Length (in") + " " + units + ") "));
            labelPanel.add(new JLabel(LanguageEncoder.getText("Thickness")));
        } else {
            labelPanel.add(new JLabel(LanguageEncoder.getText("Width (in") + " " + units + ") "));
            labelPanel.add(new JLabel(LanguageEncoder.getText("Height (in") + " " + units + ") "));
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(0, 1));
        NumberFormat numberFormat = DecimalFormat.getNumberInstance(Locale.US);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(5);
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setMinimum(Double.valueOf(0.0));
        numberFormatter.setAllowsInvalid(false);
        this.widthField = new JFormattedTextField(numberFormatter);
        mainPanel.add(this.widthField);
        this.widthField.setColumns(5);
        this.heightField = new JFormattedTextField(numberFormatter);
        mainPanel.add(this.heightField);
        this.heightField.setColumns(5);
        dimensionPanel.add("West", labelPanel);
        dimensionPanel.add("East", mainPanel);
        boolean bl = this.groupSelect = this.reportMain.groupFormatFlag() && !(this.elt instanceof ReportGrid) && !(this.elt instanceof ReportLine);
        if (this.groupSelect) {
            JPanel chPanel = new JPanel();
            chPanel.setLayout(new GridLayout(0, 2));
            this.wBox = new JCheckBox(LanguageEncoder.getText("Use Original Width"), false);
            chPanel.add(this.wBox);
            this.wBox.addItemListener(this);
            this.hBox = new JCheckBox(LanguageEncoder.getText("Use Original Height"), false);
            chPanel.add(this.hBox);
            dimensionPanel.add("South", chPanel);
            this.hBox.addItemListener(this);
        }
        this.xField = new JFormattedTextField(numberFormatter);
        this.yField = new JFormattedTextField(numberFormatter);
        if (this.elt instanceof ReportLine || this.elt instanceof ReportGrid) {
            JPanel checkBoxPanel = new JPanel();
            boolean match = false;
            if (this.elt instanceof ReportLine) {
                if (((ReportLine)this.elt).isVertical()) {
                    this.resizeToFitSectionHeight = new JCheckBox(LanguageEncoder.getText("Resize to Fit Section Height"), this.elt.getHeight() < 0.0);
                    checkBoxPanel.add(this.resizeToFitSectionHeight);
                    this.resizeToFitSectionHeight.addItemListener(this);
                    if (this.resizeToFitSectionHeight.isSelected()) {
                        this.widthField.setEnabled(!this.resizeToFitSectionHeight.isSelected());
                        this.widthField.setValue(-1);
                    }
                } else {
                    match = ((ReportLine)this.elt).isMatchColumnWidths();
                    if (match) {
                        this.widthField.setEnabled(!match);
                        this.widthField.setValue(-1);
                    }
                    this.matchColumnWidthsBox = new JCheckBox(LanguageEncoder.getText("Match Column Widths"), match);
                    checkBoxPanel.add(this.matchColumnWidthsBox);
                    this.matchColumnWidthsBox.addItemListener(this);
                }
            }
            if (this.elt instanceof ReportGrid) {
                match = ((ReportGrid)this.elt).isMatchColumnWidths();
                this.matchColumnWidthsBox = new JCheckBox(LanguageEncoder.getText("Match Column Widths"), match);
                checkBoxPanel.add(this.matchColumnWidthsBox);
                this.matchColumnWidthsBox.addItemListener(this);
            }
            dimensionPanel.add("South", checkBoxPanel);
        } else {
            boolean fromCrossTabSection = CrossTabHelper.isElementFromCrossTabSection(this.reportMain.report, this.elt);
            this.xField.setEnabled(!fromCrossTabSection || this.reportMain.isAllowCrosstabElementMove());
            this.yField.setEnabled(!fromCrossTabSection || this.reportMain.isAllowCrosstabElementMove());
        }
        JPanel positionPanel = new JPanel();
        positionPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Position")));
        positionPanel.setLayout(new BorderLayout());
        JPanel dimensionLabelsPanel = new JPanel();
        dimensionLabelsPanel.setLayout(new GridLayout(0, 1));
        this.xLabel = new JLabel(LanguageEncoder.getText("X Position (in") + " " + units + ") ");
        dimensionLabelsPanel.add(this.xLabel);
        this.yLabel = new JLabel(LanguageEncoder.getText("Y Position (in") + " " + units + ") ");
        dimensionLabelsPanel.add(this.yLabel);
        JPanel dimensionFieldsPanel = new JPanel();
        dimensionFieldsPanel.setLayout(new GridLayout(0, 1));
        dimensionFieldsPanel.add(this.xField);
        this.xField.setColumns(5);
        dimensionFieldsPanel.add(this.yField);
        this.yField.setColumns(5);
        this.widthField.addActionListener(this);
        this.heightField.addActionListener(this);
        this.xField.addActionListener(this);
        this.yField.addActionListener(this);
        positionPanel.add("Center", dimensionLabelsPanel);
        positionPanel.add("East", dimensionFieldsPanel);
        JPanel dimensionPositionPanel = new JPanel();
        dimensionPositionPanel.setLayout(new BorderLayout());
        dimensionPositionPanel.add("North", dimensionPanel);
        dimensionPositionPanel.add("Center", positionPanel);
        this.setLayout(new BorderLayout());
        this.add("North", dimensionPositionPanel);
        if (this.showApplyButton) {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1));
            this.applyButton = new JButton(LanguageEncoder.getText("Apply"));
            this.applyButton.addActionListener(this);
            buttonPanel.add(this.applyButton);
            this.add("South", buttonPanel);
        }
        this.setFields();
    }

    private void setFields() {
        double modifier;
        double[] bounds = null;
        if (this.reportMain.groupFormatFlag()) {
            bounds = this.reportMain.designPanel.rulerPanel.groupFormatInitBounds();
        }
        double d = modifier = this.reportMain.isCm ? 2.54 : 1.0;
        if (this.groupSelect) {
            if (bounds != null) {
                this.widthField.setValue(bounds[0] * modifier);
                this.heightField.setValue(bounds[1] * modifier);
            } else {
                this.widthField.setValue(0.0);
                this.heightField.setValue(0.0);
            }
            this.xField.setEditable(false);
            this.yField.setEditable(false);
            this.xLabel.setEnabled(false);
            this.yLabel.setEnabled(false);
        } else {
            this.widthField.setValue(this.elt.getWidth() * modifier);
            this.heightField.setValue(this.elt.getHeight() * modifier);
            if (this.elt instanceof ReportLine) {
                if (!((ReportLine)this.elt).isVertical()) {
                    double width = this.elt.getWidth() * modifier;
                    this.widthField.setValue(((ReportLine)this.elt).isMatchColumnWidths() ? -1.0 : width);
                    this.heightField.setValue((double)QbUtil.toPixel(this.elt.getHeight() - 0.02) * 1.0);
                } else {
                    this.widthField.setValue(this.elt.getHeight() * modifier);
                    this.heightField.setValue((double)QbUtil.toPixel(this.elt.getWidth() - 0.02) * 1.0);
                }
            }
            this.xField.setValue(this.elt.getX() * modifier);
            this.yField.setValue(this.elt.getY() * modifier);
        }
        if (this.elt.isLocked()) {
            this.widthField.setEditable(false);
            this.heightField.setEditable(false);
            this.xField.setEditable(false);
            this.yField.setEditable(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object srcObj = e.getSource();
        if (this.resizeToFitSectionHeight != null && srcObj == this.resizeToFitSectionHeight) {
            this.widthField.setEnabled(!this.resizeToFitSectionHeight.isSelected());
            this.widthField.setValue(this.resizeToFitSectionHeight.isSelected() ? -1.0 : 1.0);
        }
        if (this.matchColumnWidthsBox != null && srcObj == this.matchColumnWidthsBox) {
            this.widthField.setEnabled(!this.matchColumnWidthsBox.isSelected());
            this.widthField.setValue(this.matchColumnWidthsBox.isSelected() ? -1.0 : 1.0);
        }
        if (this.wBox != null) {
            this.widthField.setEnabled(!this.wBox.isSelected());
        }
        if (this.hBox != null) {
            this.heightField.setEnabled(!this.hBox.isSelected());
        }
    }

    public void saveChanges() {
        double w = -1.0;
        double h = -1.0;
        boolean match = false;
        if (this.groupSelect) {
            try {
                if (!this.reportMain.isCm) {
                    if (this.widthField.isEnabled()) {
                        w = (Double)this.widthField.getValue();
                    }
                    if (this.heightField.isEnabled()) {
                        h = (Double)this.heightField.getValue();
                    }
                } else {
                    if (this.widthField.isEnabled()) {
                        w = (Double)this.widthField.getValue() / 2.54;
                    }
                    if (this.heightField.isEnabled()) {
                        h = (Double)this.heightField.getValue() / 2.54;
                    }
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Dimension & Position: Invalid number", ex);
                new JMessageDialog((Dialog)new JDialog(), LanguageEncoder.getText("Error"), LanguageEncoder.getText("Dimension & Position : Numeric Only!"));
                return;
            }
            this.reportMain.designPanel.rulerPanel.groupFormatSetBounds(w, h);
            this.reportMain.setModified();
            this.reportMain.setIsUndoEnabled(true);
        } else {
            ReportElement relt;
            w = (Double)this.widthField.getValue();
            h = (Double)this.heightField.getValue();
            double x = (Double)this.xField.getValue();
            double y = (Double)this.yField.getValue();
            if (this.reportMain.isCm) {
                w /= 2.54;
                if (!(this.elt instanceof ReportLine)) {
                    h /= 2.54;
                }
                x /= 2.54;
                y /= 2.54;
            }
            if (this.elt instanceof ReportLine && !((ReportLine)this.elt).isVertical() || this.elt instanceof ReportGrid) {
                match = this.matchColumnWidthsBox.isSelected();
            }
            if (this.elt instanceof ReportLine) {
                if (!((ReportLine)this.elt).isVertical()) {
                    this.elt.setWidth(w);
                    this.elt.setHeight(QbUtil.toInch(h) + 0.02);
                } else {
                    this.elt.setWidth(QbUtil.toInch(h) + 0.02);
                    this.elt.setHeight(this.resizeToFitSectionHeight.isSelected() ? -1.0 : w);
                }
                this.elt.setX(x);
                this.elt.setY(y);
            } else if (this.reportMain.isDesignMode) {
                this.setElementDimensions(w, h, x, y);
            } else if (this.elt instanceof ReportCell) {
                relt = this.reportMain.selectedPanel.getElement();
                if (relt instanceof ReportTable) {
                    this.setElementDimensions(w, h, x, y);
                } else if (relt instanceof ReportSection) {
                    if (((ReportSection)relt).hasSectionCell((ReportCell)this.reportMain.selectedObject, this.tree) || ((ReportSection)relt).hasFormattedCell((ReportCell)this.reportMain.selectedObject, this.tree)) {
                        this.setElementDimensions(w, h, x, y);
                    } else {
                        ReportCell newCell = new ReportCell();
                        newCell.copy((ReportCell)this.reportMain.selectedObject);
                        newCell.setWidth(w);
                        newCell.setHeight(h);
                        newCell.setX(x);
                        newCell.setY(y);
                        ((ReportSection)relt).addFormattedCell(newCell, (ReportCell)this.reportMain.selectedObject, this.tree);
                    }
                }
            } else if (this.elt instanceof ReportColumn) {
                try {
                    relt = ((ReportColumn)this.elt).getFormatCell(this.row);
                    if (relt instanceof ReportCell) {
                        int i;
                        ReportTable mainTable;
                        FormattedCell cell = new FormattedCell((ReportCell)relt, this.row);
                        cell.setWidth(w);
                        cell.setHeight(h);
                        cell.setX(x);
                        cell.setY(y);
                        ((ReportColumn)this.elt).addFormattedCell(cell);
                        ReportTable table = mainTable = this.reportMain.report.getReportTables().elementAt(0);
                        for (i = 0; i < this.tree.size(); ++i) {
                            if (!(table instanceof ReportTreeTable)) continue;
                            table = ((ReportTreeTable)table).getSubTable(this.tree.elementAt(i));
                        }
                        for (i = 0; i < table.getColumnCount() && table.getColumn(i) != this.elt; ++i) {
                        }
                        mainTable.getColumn(i).addFormattedCell(this.row, this.tree, cell);
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to apply cell attributes", ex);
                }
            }
            if (this.elt instanceof ReportLine && !((ReportLine)this.elt).isVertical()) {
                ((ReportLine)this.elt).setMatchColumnWidths(match);
            }
            if (this.elt instanceof ReportGrid) {
                ((ReportGrid)this.elt).setMatchColumnWidths(match);
            }
            this.reportMain.setModified();
            try {
                this.reportMain.selectedPanel.updateRulers();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to update rulers", ex);
            }
            this.reportMain.repaintPanel(this.reportMain.selectedPanel);
        }
    }

    private void setElementDimensions(double w, double h, double x, double y) {
        boolean fromCrossTabSection = CrossTabHelper.isElementFromCrossTabSection(this.reportMain.report, this.elt);
        if (fromCrossTabSection) {
            CrossTabHelper.adjustAllElementsWithGreaterX(this.reportMain.selectedPanel, this.elt, w - this.elt.getWidth());
            CrossTabHelper.adjustReportElementsByDeltaY(this.reportMain.selectedPanel, this.elt, h - this.elt.getHeight());
            this.reportMain.repaintPanel();
        } else {
            this.elt.setX(x);
            this.elt.setY(y);
        }
        this.elt.setWidth(w);
        this.elt.setHeight(h);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            this.saveChanges();
            this.reportMain.clearAllDraggedObjects();
        }
    }
}

