/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.designer.ReportMain;

public class SetCustomIDDialog
extends JDialog
implements ActionListener {
    ReportElement elt;
    String customID = "";
    boolean modified = false;
    JButton okButton;
    JButton cancelButton;
    JTextField tf;

    public SetCustomIDDialog(ReportMain reportMain, ReportElement elt) {
        super(reportMain, LanguageEncoder.getText("Set Custom ID ..."), true);
        this.elt = elt;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(LanguageEncoder.getText("")));
        panel.setLayout(new FlowLayout(0));
        panel.add(new JLabel(LanguageEncoder.getText("Custom ID:")));
        this.customID = this.elt.getCustomID();
        if (this.customID == null || this.customID.trim().equals("")) {
            this.customID = this.elt.getID();
        }
        this.tf = new JTextField(this.customID, 15);
        panel.add(this.tf);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        contentPane.add("Center", panel);
        contentPane.add("South", buttonPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.modified = true;
            this.customID = this.tf.getText().trim();
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getCustomID() {
        return this.customID;
    }
}

