/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.SetFontPanel;

public class SetFontDialog
extends JDialog
implements ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    private ReportMain reportMain;
    private boolean isModified = false;
    private SetFontPanel setFontPanel;
    private Font font;
    private Color fontColor;
    private boolean isUnderline;
    private int option;

    public SetFontDialog(ReportMain reportMain) {
        this(reportMain, null, false, 0);
    }

    public SetFontDialog(ReportMain reportMain, Font font, boolean isUnderline, int option) {
        this(reportMain, font, isUnderline, null, option);
    }

    public SetFontDialog(ReportMain reportMain, Font font, boolean isUnderline, Color fontColor, int option) {
        super(reportMain, LanguageEncoder.getText("Set Font Style and Size ..."), true);
        this.reportMain = reportMain;
        this.font = font;
        this.isUnderline = isUnderline;
        this.fontColor = fontColor;
        this.option = option;
        this.init();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        if (this.option == 5) {
            this.setPreferredSize(new Dimension(430, 340));
        } else {
            this.setPreferredSize(new Dimension(430, 400));
        }
        this.setBackground(Color.lightGray);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setFontPanel = new SetFontPanel(this.reportMain, this.font, this.isUnderline, false, this.fontColor, this.option);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add("Center", this.setFontPanel);
        contentPane.add("South", buttonPanel);
        this.setPosition();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.setFontPanel.checkAndUpdateFont()) {
                this.setFontPanel.saveChanges();
                this.reportMain.setModified();
                this.reportMain.designPanel.rulerPanel.repaintPanel();
                this.isModified = true;
                this.setVisible(false);
                this.dispose();
            }
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public boolean isUnderline() {
        return this.setFontPanel.isUnderline();
    }

    public Color getFontColor() {
        return this.setFontPanel.getFontColor();
    }

    @Override
    public Font getFont() {
        return this.setFontPanel.getFont();
    }
}

