/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.ColorButton;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.designer.ColorDialog;
import quadbase.reportdesigner.designer.ReportMain;

public class SetFontPanel
extends JPanel
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(SetFontPanel.class.getName());
    private ReportMain reportMain;
    private ReportElement elt;
    private String[] fontList;
    private JComboBox nameList;
    private JComboBox styleList;
    private JCheckBox underlineBox;
    private JTextField sizeField;
    private FontPreviewPanel previewPanel;
    private String text;
    private boolean drawPreviewPanel = true;
    private boolean showApplyButton;
    private JButton applyButton;
    private ColorButton colorButton;
    private Font font;
    private Color fontColor;
    private boolean fontUnderline;
    private int option = 0;
    private static final String TEXT = "Text";

    public SetFontPanel(ReportMain reportMain, boolean showApplyButton) {
        this.reportMain = reportMain;
        this.elt = null;
        this.font = reportMain.designPanel.rulerPanel.groupFormatInitFont();
        this.fontColor = reportMain.designPanel.rulerPanel.groupFormatInitFontColor();
        this.fontUnderline = reportMain.designPanel.rulerPanel.groupFormatInitFontUnderline();
        this.text = TEXT;
        this.showApplyButton = showApplyButton;
        this.init();
    }

    public SetFontPanel(ReportMain reportMain, ReportElement elt, boolean showApplyButton) {
        this.reportMain = reportMain;
        this.elt = elt;
        this.font = elt.getFont();
        this.fontColor = elt.getFontColor();
        this.fontUnderline = elt.isUnderline();
        this.text = elt.getText();
        this.showApplyButton = showApplyButton;
        this.init();
    }

    public SetFontPanel(ReportMain reportMain, Font font, boolean isUnderline, boolean showApplyButton, Color fontColor, int option) {
        this.reportMain = reportMain;
        if (font == null) {
            this.font = reportMain.designPanel.rulerPanel.groupFormatInitFont();
            if (this.font == null) {
                this.font = FontTable.newFont("Dialog", 0, QbUtil.getAdjustedFont(12, true));
            }
        } else {
            this.font = font;
        }
        this.fontUnderline = isUnderline;
        this.elt = null;
        this.fontColor = fontColor == null ? reportMain.designPanel.rulerPanel.groupFormatInitFontColor() : fontColor;
        this.text = TEXT;
        this.showApplyButton = showApplyButton;
        this.option = option;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Font Style and Size ...")));
        this.nameList = new JComboBox();
        for (String element : this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            this.nameList.addItem(element);
        }
        this.nameList.addItemListener(this);
        this.styleList = new JComboBox();
        this.styleList.addItem(LanguageEncoder.getText("Plain"));
        this.styleList.addItem(LanguageEncoder.getText("Bold"));
        this.styleList.addItem(LanguageEncoder.getText("Italic"));
        this.styleList.addItem(LanguageEncoder.getText("Bold Italic"));
        this.styleList.addItemListener(this);
        this.sizeField = new JTextField();
        this.sizeField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SetFontPanel.this.previewPanel.repaint();
            }
        });
        JPanel outerFontPanel = new JPanel();
        outerFontPanel.setLayout(new BorderLayout());
        JPanel outFontPanel = new JPanel(new BorderLayout());
        outFontPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Font")));
        JPanel fontPanel = new JPanel();
        fontPanel.setLayout(new GridLayout(3, 3, 5, 5));
        fontPanel.add(new JLabel(LanguageEncoder.getText("Name")));
        fontPanel.add(this.nameList);
        fontPanel.add(new JLabel(""));
        fontPanel.add(new JLabel(LanguageEncoder.getText("Style")));
        fontPanel.add(this.styleList);
        this.underlineBox = new JCheckBox("Underline Text");
        this.underlineBox.addItemListener(this);
        fontPanel.add(this.underlineBox);
        fontPanel.add(new JLabel(LanguageEncoder.getText("Size")));
        fontPanel.add(this.sizeField);
        fontPanel.add(new JLabel("(between 3 and 99)"));
        outFontPanel.add("Center", fontPanel);
        if (this.option != 5) {
            JPanel outFontColorPanel = new JPanel(new BorderLayout());
            outFontColorPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Font Color")));
            JPanel fontColorPanel = new JPanel();
            fontColorPanel.setLayout(new FlowLayout(0));
            fontColorPanel.add(new JLabel(LanguageEncoder.getText("Current Color :")));
            this.colorButton = new ColorButton(LanguageEncoder.getText("Click"));
            fontColorPanel.add(this.colorButton);
            this.colorButton.addActionListener(this);
            this.setColor(this.fontColor);
            outFontColorPanel.add("Center", fontColorPanel);
            outerFontPanel.add("Center", outFontColorPanel);
        }
        outerFontPanel.add("North", outFontPanel);
        this.previewPanel = new FontPreviewPanel();
        this.previewPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Preview")));
        if (this.showApplyButton) {
            JPanel applyButtonPanel = new JPanel();
            applyButtonPanel.setLayout(new FlowLayout(1));
            this.applyButton = new JButton(LanguageEncoder.getText("Apply"));
            this.applyButton.addActionListener(this);
            applyButtonPanel.add(this.applyButton);
            this.add("South", applyButtonPanel);
        }
        this.add("North", outerFontPanel);
        this.add("Center", this.previewPanel);
        this.presetFont(this.font, this.fontUnderline);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.previewPanel.repaint();
    }

    private void presetFont(Font font, boolean isUnderline) {
        if (font == null) {
            return;
        }
        this.nameList.setSelectedIndex(this.getName(font.getName()));
        this.styleList.setSelectedIndex(font.getStyle());
        this.sizeField.setText(font.getSize() + "");
        this.underlineBox.setSelected(isUnderline);
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.colorButton.setColor(color);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public boolean isUnderline() {
        this.fontUnderline = this.underlineBox.isSelected();
        return this.fontUnderline;
    }

    private int getName(String str) {
        for (int i = 0; i < this.fontList.length; ++i) {
            if (!this.fontList[i].equals(str)) continue;
            return i;
        }
        return 0;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    private void refreshPreviewPanel() {
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object eventSrc = e.getSource();
        if (this.showApplyButton && eventSrc == this.applyButton) {
            this.drawPreviewPanel = false;
            if (this.checkAndUpdateFont()) {
                this.saveChanges();
                this.reportMain.designPanel.rulerPanel.repaintPanel();
                this.reportMain.setModified();
            }
        } else if (eventSrc == this.colorButton) {
            Color initColor = this.fontColor == null ? Color.lightGray : this.fontColor;
            this.fontColor = ColorDialog.showDialog(this.reportMain, LanguageEncoder.getText("Set Font Color..."), initColor);
            this.reportMain.addRecentColor(this.fontColor);
            this.setColor(this.fontColor);
            this.refreshPreviewPanel();
        }
        this.drawPreviewPanel = true;
    }

    boolean checkAndUpdateFont() {
        String name = (String)this.nameList.getSelectedItem();
        int style = this.styleList.getSelectedIndex();
        int size = 0;
        try {
            size = Integer.parseInt(this.sizeField.getText());
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Font size: Invalid number", ex);
            new JMessageDialog((Frame)this.reportMain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Font Size : Integer Only!"), 6);
            this.drawPreviewPanel = true;
            return false;
        }
        if (size < 3 || size > 99) {
            new JMessageDialog((Frame)this.reportMain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Font Size : can't be smaller than 3 or bigger than 99!"), 6);
            this.drawPreviewPanel = true;
            return false;
        }
        this.font = new Font(name, style, size);
        return true;
    }

    public void saveChanges() {
        if (this.option != 4 && this.option != 5) {
            if (this.elt != null) {
                this.elt.setFont(this.font);
                this.elt.setFontColor(this.fontColor);
                this.elt.setUnderline(this.isUnderline());
            } else {
                this.reportMain.designPanel.rulerPanel.groupFormatSetFont(this.font);
                this.reportMain.designPanel.rulerPanel.groupFormatSetFontColor(this.fontColor);
                this.reportMain.designPanel.rulerPanel.groupFormatSetFontUnderline(this.isUnderline());
            }
        }
    }

    class FontPreviewPanel
    extends JPanel {
        FontPreviewPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            if (g == null) {
                return;
            }
            if (!SetFontPanel.this.drawPreviewPanel) {
                return;
            }
            super.paintComponent(g);
            if (SetFontPanel.this.text == null || SetFontPanel.this.text.equals("")) {
                SetFontPanel.this.text = "abc ABC";
            }
            try {
                int size = Integer.parseInt(SetFontPanel.this.sizeField.getText());
                if (size < 3) {
                    size = 3;
                }
                if (size > 99) {
                    size = 99;
                }
                Font font = FontTable.newFont((String)SetFontPanel.this.nameList.getSelectedItem(), SetFontPanel.this.styleList.getSelectedIndex(), size);
                boolean underline = SetFontPanel.this.underlineBox.isSelected();
                if (font != null) {
                    g.setColor(new Color(255, 255, 255));
                    g.fillRect(20, 20, 370, 100);
                    g.setColor(SetFontPanel.this.fontColor);
                    g.setFont(font);
                    g.drawString(SetFontPanel.this.text, 50, 95);
                }
                if (underline) {
                    FontMetrics fm = g.getFontMetrics(font);
                    int strWidth = fm.stringWidth(SetFontPanel.this.text);
                    int underLineY = 95 + fm.getDescent();
                    g.drawLine(50, underLineY, 50 + strWidth, underLineY);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to preview font", ex);
            }
        }
    }
}

