/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;

public class SetHTMLPageTitleDialog
extends JDialog
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    ReportMain reportMain;
    JTextField htmlTitleField;

    public SetHTMLPageTitleDialog(ReportMain reportMain) {
        super(reportMain, LanguageEncoder.getText("Set HTML Page Title ..."), true);
        this.reportMain = reportMain;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Set HTML Page Title ...")));
        p1.setLayout(new BorderLayout());
        this.htmlTitleField = new JTextField(25);
        p1.add(this.htmlTitleField);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        this.setField();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
    }

    private void setField() {
        String str = this.reportMain.report.getHTMLTitle();
        this.htmlTitleField.setText(str);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            String title = this.htmlTitleField.getText().trim();
            this.reportMain.report.setHTMLTitle(title);
            this.reportMain.setModified();
            this.reportMain.do_Refresh();
        }
        this.setVisible(false);
        this.dispose();
    }
}

