/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.ColorButton;
import quadbase.common.swing.JTextFieldLimit;
import quadbase.common.util.internal.Java2DUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.BorderSide;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.designer.ColorDialog;
import quadbase.reportdesigner.designer.ReportMain;

public class SetRoundCornersPanel
extends JPanel
implements ActionListener,
ItemListener,
FocusListener {
    private static final Logger LOGGER = Logger.getLogger(SetRoundCornersPanel.class.getName());
    private ReportMain reportMain;
    private ReportElement elt;
    private Color borderColor;
    private JTextField roundCornerRadiusField;
    private ColorButton colorButton;
    private boolean isTransparent;
    private boolean showApplyButton;
    private JButton applyButton;
    private int roundCornerRadius;
    private boolean[] roundCornersArray;
    private RoundRectanglePreviewPanel roundRectanglePreviewPanel;
    private JCheckBox topLeftCorner;
    private JCheckBox topRightCorner;
    private JCheckBox bottomLeftCorner;
    private JCheckBox bottomRightCorner;
    private int topBorder;
    private int rightBorder;
    private int bottomBorder;
    private int leftBorder;
    private int borderThickness;
    private JTextField topBorderTextField;
    private JTextField rightBorderTextField;
    private JTextField bottomBorderTextField;
    private JTextField leftBorderTextField;
    private JTextField borderThicknessTextField;
    private JCheckBox setThicknessIndividuallyCheckBox;
    private static final int MAX_RADIUS = 99;
    private static final int MAX_NUMBER_COUNT = 2;
    private static final String PX = " " + LanguageEncoder.getText("px");

    public SetRoundCornersPanel(ReportMain reportMain) {
        this.reportMain = reportMain;
        this.elt = null;
        this.borderColor = reportMain.designPanel.rulerPanel.groupFormatInitBorderColor();
        this.roundCornerRadius = reportMain.designPanel.rulerPanel.groupFormatInitRoundCornerRadius();
        this.roundCornersArray = reportMain.designPanel.rulerPanel.groupFormatInitRoundCornersArray();
        this.init();
        this.setTopBorder(reportMain.designPanel.rulerPanel.groupFormatInitBorderThickness(BorderSide.TOP));
        this.setRightBorder(reportMain.designPanel.rulerPanel.groupFormatInitBorderThickness(BorderSide.RIGHT));
        this.setBottomBorder(reportMain.designPanel.rulerPanel.groupFormatInitBorderThickness(BorderSide.BOTTOM));
        this.setLeftBorder(reportMain.designPanel.rulerPanel.groupFormatInitBorderThickness(BorderSide.LEFT));
        boolean setThicknessIndividually = this.isSetThicknessIndividually();
        this.setThicknessIndividuallyCheckBox.setSelected(setThicknessIndividually);
        if (!setThicknessIndividually) {
            this.setBorderThickness(this.topBorder);
        }
        this.setThicknessIndividually(setThicknessIndividually);
    }

    public SetRoundCornersPanel(ReportElement elt, ReportMain reportMain) {
        this.elt = elt;
        this.reportMain = reportMain;
        this.borderColor = elt.getBorderColor();
        this.roundCornerRadius = elt.getRoundCornerRadius();
        this.roundCornersArray = elt.getRoundCornersArray();
        this.init();
        this.setBorders(elt);
    }

    private void setBorders(ReportElement elt) {
        this.setTopBorder(elt.getTopBorder());
        this.setRightBorder(elt.getRightBorder());
        this.setBottomBorder(elt.getBottomBorder());
        this.setLeftBorder(elt.getLeftBorder());
        if (!this.isSetThicknessIndividually()) {
            this.setBorderThickness(this.topBorder);
        }
        this.setThicknessIndividuallyCheckBox.setSelected(this.isSetThicknessIndividually());
        this.setThicknessIndividually(this.isSetThicknessIndividually());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Border / Round Corners")));
        JPanel roundCornersInnerPanel = new JPanel();
        roundCornersInnerPanel.setLayout(new GridBagLayout());
        this.topLeftCorner = new JCheckBox("", this.roundCornersArray[0]);
        this.topLeftCorner.addItemListener(this);
        this.topRightCorner = new JCheckBox("", this.roundCornersArray[1]);
        this.topRightCorner.addItemListener(this);
        this.bottomRightCorner = new JCheckBox("", this.roundCornersArray[2]);
        this.bottomRightCorner.addItemListener(this);
        this.bottomLeftCorner = new JCheckBox("", this.roundCornersArray[3]);
        this.bottomLeftCorner.addItemListener(this);
        this.topBorderTextField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.topBorderTextField.setDocument(new JTextFieldLimit(2));
        this.topBorderTextField.setColumns(2);
        this.topBorderTextField.addActionListener(this);
        this.topBorderTextField.addFocusListener(this);
        this.rightBorderTextField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.rightBorderTextField.setDocument(new JTextFieldLimit(2));
        this.rightBorderTextField.setColumns(2);
        this.rightBorderTextField.addActionListener(this);
        this.rightBorderTextField.addFocusListener(this);
        this.bottomBorderTextField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.bottomBorderTextField.setDocument(new JTextFieldLimit(2));
        this.bottomBorderTextField.setColumns(2);
        this.bottomBorderTextField.addActionListener(this);
        this.bottomBorderTextField.addFocusListener(this);
        this.leftBorderTextField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.leftBorderTextField.setDocument(new JTextFieldLimit(2));
        this.leftBorderTextField.setColumns(2);
        this.leftBorderTextField.addActionListener(this);
        this.leftBorderTextField.addFocusListener(this);
        JLabel pxLabel = new JLabel(PX);
        JPanel pxPanel = new JPanel(new BorderLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 0;
        c.gridx = 0;
        roundCornersInnerPanel.add((Component)this.topLeftCorner, c);
        c.gridx = 1;
        pxPanel.add((Component)this.topBorderTextField, "Center");
        pxPanel.add((Component)pxLabel, "East");
        roundCornersInnerPanel.add((Component)pxPanel, c);
        c.gridx = 2;
        roundCornersInnerPanel.add((Component)this.topRightCorner, c);
        ++c.gridy;
        c.gridx = 0;
        pxPanel = new JPanel(new BorderLayout());
        pxPanel.add((Component)this.leftBorderTextField, "Center");
        pxLabel = new JLabel(PX);
        pxPanel.add((Component)pxLabel, "East");
        roundCornersInnerPanel.add((Component)pxPanel, c);
        c.gridx = 1;
        c.fill = 0;
        this.roundRectanglePreviewPanel = new RoundRectanglePreviewPanel();
        Dimension panelSize = new Dimension(305, 105);
        this.roundRectanglePreviewPanel.setMinimumSize(panelSize);
        this.roundRectanglePreviewPanel.setPreferredSize(panelSize);
        roundCornersInnerPanel.add((Component)this.roundRectanglePreviewPanel, c);
        c.gridx = 2;
        pxPanel = new JPanel(new BorderLayout());
        pxPanel.add((Component)this.rightBorderTextField, "Center");
        pxLabel = new JLabel(PX);
        pxPanel.add((Component)pxLabel, "East");
        roundCornersInnerPanel.add((Component)pxPanel, c);
        ++c.gridy;
        c.fill = 0;
        c.gridx = 0;
        roundCornersInnerPanel.add((Component)this.bottomLeftCorner, c);
        c.gridx = 1;
        pxPanel = new JPanel(new BorderLayout());
        pxPanel.add((Component)this.bottomBorderTextField, "Center");
        pxLabel = new JLabel(PX);
        pxPanel.add((Component)pxLabel, "East");
        roundCornersInnerPanel.add((Component)pxPanel, c);
        c.gridx = 2;
        roundCornersInnerPanel.add((Component)this.bottomRightCorner, c);
        JPanel borderColorRadiusPanel = new JPanel();
        borderColorRadiusPanel.setLayout(new FlowLayout(0));
        this.roundCornerRadiusField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.roundCornerRadiusField.setDocument(new JTextFieldLimit(2));
        this.roundCornerRadiusField.setColumns(2);
        this.roundCornerRadiusField.setText(this.roundCornerRadius + "");
        this.roundCornerRadiusField.addActionListener(this);
        this.roundCornerRadiusField.addFocusListener(this);
        borderColorRadiusPanel.add(new JLabel(LanguageEncoder.getText("Radius")));
        borderColorRadiusPanel.add(this.roundCornerRadiusField);
        borderColorRadiusPanel.add(new JLabel("px "));
        JPanel borderThicknessPanel = new JPanel();
        borderThicknessPanel.add(new JLabel(LanguageEncoder.getText("Thickness")));
        this.borderThicknessTextField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.borderThicknessTextField.setDocument(new JTextFieldLimit(2));
        this.borderThicknessTextField.setColumns(2);
        this.borderThicknessTextField.addActionListener(this);
        this.borderThicknessTextField.addFocusListener(this);
        borderThicknessPanel.add(this.borderThicknessTextField);
        borderThicknessPanel.add(new JLabel("px "));
        this.setThicknessIndividuallyCheckBox = new JCheckBox(LanguageEncoder.getText("Set Thickness Individually"), this.isSetThicknessIndividually());
        this.setThicknessIndividuallyCheckBox.addItemListener(this);
        borderThicknessPanel.add(this.setThicknessIndividuallyCheckBox);
        borderColorRadiusPanel.add(borderThicknessPanel);
        JPanel borderColorPanel = new JPanel();
        borderColorPanel.setLayout(new FlowLayout(0));
        borderColorPanel.add(new JLabel(LanguageEncoder.getText("Color :")));
        this.colorButton = new ColorButton(LanguageEncoder.getText("Click"));
        borderColorPanel.add(this.colorButton);
        this.borderColor = this.borderColor == null ? new Color(0, 0, 0) : this.borderColor;
        this.colorButton.setEnabled(!this.isTransparent);
        this.colorButton.addActionListener(this);
        borderColorRadiusPanel.add(borderColorPanel);
        this.setColor(this.borderColor);
        JPanel thicknessBorderPanel = new JPanel(new BorderLayout());
        thicknessBorderPanel.add("North", borderColorRadiusPanel);
        thicknessBorderPanel.add("Center", borderColorPanel);
        if (this.showApplyButton) {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1));
            this.applyButton = new JButton(LanguageEncoder.getText("Apply"));
            this.applyButton.addActionListener(this);
            buttonPanel.add(this.applyButton);
            this.add("South", buttonPanel);
        }
        this.add("North", thicknessBorderPanel);
        this.add("Center", roundCornersInnerPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.colorButton) {
            Color initColor = this.borderColor == null ? Color.lightGray : this.borderColor;
            this.borderColor = ColorDialog.showDialog(this.reportMain, LanguageEncoder.getText("Set Border Color..."), initColor);
            this.reportMain.addRecentColor(this.borderColor);
            this.setColor(this.borderColor);
        }
        this.refreshSpecificBorder(e.getSource());
        this.refreshPreviewPanel();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object eventSrc = e.getSource();
        if (eventSrc == this.topLeftCorner || eventSrc == this.topRightCorner || eventSrc == this.bottomLeftCorner || eventSrc == this.bottomRightCorner) {
            this.refreshPreviewPanel();
        } else if (eventSrc == this.setThicknessIndividuallyCheckBox) {
            this.setThicknessIndividually(this.setThicknessIndividuallyCheckBox.isSelected());
            this.refreshPreviewPanel();
        }
    }

    private void setThicknessIndividually(boolean isChecked) {
        this.topBorderTextField.setEnabled(isChecked);
        this.rightBorderTextField.setEnabled(isChecked);
        this.bottomBorderTextField.setEnabled(isChecked);
        this.leftBorderTextField.setEnabled(isChecked);
        if (!isChecked) {
            this.getBorderThickness();
            this.topBorderTextField.setText(Integer.toString(this.borderThickness));
            this.topBorder = this.borderThickness;
            this.leftBorderTextField.setText(Integer.toString(this.borderThickness));
            this.leftBorder = this.borderThickness;
            this.bottomBorderTextField.setText(Integer.toString(this.borderThickness));
            this.bottomBorder = this.borderThickness;
            this.rightBorderTextField.setText(Integer.toString(this.borderThickness));
            this.rightBorder = this.borderThickness;
        }
        this.borderThicknessTextField.setEnabled(!isChecked);
    }

    public void refreshPreviewPanel() {
        this.roundCornerRadiusField.setText(Integer.toString(this.getRoundCornerRadius()));
        this.repaint();
    }

    private boolean[] getRoundCornersArray() {
        this.roundCornersArray[0] = this.topLeftCorner.isSelected();
        this.roundCornersArray[1] = this.topRightCorner.isSelected();
        this.roundCornersArray[2] = this.bottomRightCorner.isSelected();
        this.roundCornersArray[3] = this.bottomLeftCorner.isSelected();
        return this.roundCornersArray;
    }

    private int getRoundCornerRadius() {
        try {
            this.roundCornerRadius = Math.abs(Integer.parseInt(this.roundCornerRadiusField.getText()));
            if (this.roundCornerRadius > 99) {
                this.roundCornerRadius = 99;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, "Round corner radius: Invalid number", e);
            this.roundCornerRadius = 0;
        }
        return this.roundCornerRadius;
    }

    private Color getBackgroundColor() {
        return this.elt != null ? this.elt.getBgColor() : this.reportMain.designPanel.rulerPanel.groupFormatInitBackgroundColor();
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.refreshSpecificBorder(arg0.getSource());
        this.refreshPreviewPanel();
    }

    private void refreshSpecificBorder(Object src) {
        if (src == this.borderThicknessTextField) {
            this.setThicknessIndividually(false);
        } else if (src == this.topBorderTextField) {
            this.getTopBorder();
        } else if (src == this.rightBorderTextField) {
            this.getRightBorder();
        } else if (src == this.bottomBorderTextField) {
            this.getBottomBorder();
        } else {
            this.getLeftBorder();
        }
    }

    public void saveChanges() {
        if (this.elt != null) {
            this.elt.setRoundCornerRadius(this.roundCornerRadius);
            this.elt.setRoundCornersArray(this.roundCornersArray);
            this.elt.setBorderThickness(this.getTopBorder(), this.getRightBorder(), this.getBottomBorder(), this.getLeftBorder());
            this.elt.setBorderColor(this.borderColor);
        } else {
            this.reportMain.designPanel.rulerPanel.groupFormatSetBorderRoundCorners(this.getTopBorder(), this.roundCornerRadius, this.roundCornersArray, false, BorderSide.TOP);
            this.reportMain.designPanel.rulerPanel.groupFormatSetBorderRoundCorners(this.getRightBorder(), this.roundCornerRadius, this.roundCornersArray, false, BorderSide.RIGHT);
            this.reportMain.designPanel.rulerPanel.groupFormatSetBorderRoundCorners(this.getBottomBorder(), this.roundCornerRadius, this.roundCornersArray, false, BorderSide.BOTTOM);
            this.reportMain.designPanel.rulerPanel.groupFormatSetBorderRoundCorners(this.getLeftBorder(), this.roundCornerRadius, this.roundCornersArray, false, BorderSide.LEFT);
            this.reportMain.designPanel.rulerPanel.groupFormatSetBorderColor(this.borderColor);
        }
    }

    private int getTopBorder() {
        try {
            this.topBorder = Math.abs(Integer.parseInt(this.topBorderTextField.getText()));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, "Top Border Thickness: Invalid number, using 0", e);
            this.setTopBorder(0);
        }
        return this.topBorder;
    }

    private void setTopBorder(int topBorder) {
        this.topBorder = topBorder;
        this.topBorderTextField.setText(Integer.toString(topBorder));
    }

    private int getRightBorder() {
        try {
            this.rightBorder = Math.abs(Integer.parseInt(this.rightBorderTextField.getText()));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, "Right Border Thickness: Invalid number, using 0", e);
            this.setRightBorder(0);
        }
        return this.rightBorder;
    }

    private void setRightBorder(int rightBorder) {
        this.rightBorder = rightBorder;
        this.rightBorderTextField.setText(Integer.toString(rightBorder));
    }

    private int getBottomBorder() {
        try {
            this.bottomBorder = Math.abs(Integer.parseInt(this.bottomBorderTextField.getText()));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, "Bottom Border Thickness: Invalid number, using 0", e);
            this.setBottomBorder(0);
        }
        return this.bottomBorder;
    }

    private void setBottomBorder(int bottomBorder) {
        this.bottomBorder = bottomBorder;
        this.bottomBorderTextField.setText(Integer.toString(bottomBorder));
    }

    private int getLeftBorder() {
        try {
            this.leftBorder = Math.abs(Integer.parseInt(this.leftBorderTextField.getText()));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, "Left Border Thickness: Invalid number, using 0", e);
            this.setLeftBorder(0);
        }
        return this.leftBorder;
    }

    private void setLeftBorder(int leftBorder) {
        this.leftBorder = leftBorder;
        this.leftBorderTextField.setText(Integer.toString(leftBorder));
    }

    private int getBorderThickness() {
        try {
            this.borderThickness = Math.abs(Integer.parseInt(this.borderThicknessTextField.getText()));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, "Border Thickness: Invalid number, using 0", e);
            this.setBorderThickness(0);
        }
        return this.borderThickness;
    }

    private void setBorderThickness(int borderThickness) {
        this.borderThickness = borderThickness;
        this.borderThicknessTextField.setText(Integer.toString(borderThickness));
    }

    private boolean isSetThicknessIndividually() {
        return this.topBorder != this.leftBorder || this.leftBorder != this.bottomBorder || this.bottomBorder != this.rightBorder;
    }

    private void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.colorButton.setColor(color);
    }

    public Color getBorderColor() {
        return this.isTransparent ? null : this.borderColor;
    }

    class RoundRectanglePreviewPanel
    extends JPanel {
        RoundRectanglePreviewPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Dimension dim = this.getPreferredSize();
            int x = 0 + SetRoundCornersPanel.this.leftBorder / 2;
            int y = 0 + SetRoundCornersPanel.this.topBorder / 2;
            float w = (float)dim.getWidth() - (float)SetRoundCornersPanel.this.rightBorder - 1.0f;
            float h = (float)dim.getHeight() - (float)SetRoundCornersPanel.this.bottomBorder - 1.0f;
            int r = SetRoundCornersPanel.this.getRoundCornerRadius();
            try {
                Java2DUtil.drawCellWithRoundCornersBySegments(g2d, Math.round(x), Math.round(y), r, SetRoundCornersPanel.this.getRoundCornersArray(), w, h, SetRoundCornersPanel.this.borderColor, SetRoundCornersPanel.this.getBackgroundColor(), 1, true, true, true, new float[]{SetRoundCornersPanel.this.topBorder, SetRoundCornersPanel.this.rightBorder, SetRoundCornersPanel.this.bottomBorder, SetRoundCornersPanel.this.leftBorder});
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to draw cell with round corners", e);
            }
        }
    }
}

