/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;

public class SnapToGridDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(SnapToGridDialog.class.getName());
    ReportMain reportmain;
    JCheckBox snapToGridCB;
    JButton okBtn;
    JButton cancelBtn;
    JTextField stepSizeTF;
    boolean modified;
    boolean snapToGrid;
    double stepSize;

    public SnapToGridDialog(ReportMain reportmain) {
        super(reportmain, LanguageEncoder.getText("Snap To Grid"), true);
        this.reportmain = reportmain;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel snapPanel = new JPanel();
        snapPanel.setLayout(new FlowLayout(0));
        this.snapToGridCB = new JCheckBox(LanguageEncoder.getText("Snap To Grid"), this.reportmain.report.snapToGrid);
        this.snapToGridCB.addItemListener(this);
        snapPanel.add(this.snapToGridCB);
        JPanel stepSizePanel = new JPanel();
        stepSizePanel.setLayout(new FlowLayout(0));
        if (!this.reportmain.isCm) {
            stepSizePanel.add(new JLabel(LanguageEncoder.getText("Grid Step Size(in inches)")));
            this.stepSizeTF = new JTextField(this.reportmain.report.gridStepSize + "", 4);
        } else {
            stepSizePanel.add(new JLabel(LanguageEncoder.getText("Grid Step Size(in cms)")));
            this.stepSizeTF = new JTextField(this.reportmain.report.cmGridStepSize + "", 4);
        }
        this.stepSizeTF.setEnabled(this.reportmain.report.snapToGrid);
        stepSizePanel.add(this.stepSizeTF);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Snap To Grid")));
        mainPanel.add(snapPanel);
        mainPanel.add(stepSizePanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okBtn = new JButton(LanguageEncoder.getText("OK"));
        this.cancelBtn = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.okBtn);
        buttonPanel.add(this.cancelBtn);
        this.okBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okBtn) {
            try {
                this.stepSize = Double.parseDouble(this.stepSizeTF.getText());
                this.modified = true;
                this.snapToGrid = this.snapToGridCB.isSelected();
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINE, "Step size: Invalid number", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please input numeric value only!"));
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.snapToGridCB) {
            if (this.snapToGridCB.isSelected()) {
                this.stepSizeTF.setEnabled(true);
            } else {
                this.stepSizeTF.setEnabled(false);
            }
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public double getStepSize() {
        return this.stepSize;
    }
}

