/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.ColInfo;

public class SortByDialog
extends JDialog
implements ActionListener,
ItemListener {
    private ReportMain reportMain;
    private JButton okButton;
    private JButton cancelButton;
    private JList availList;
    private JList sortbyList;
    private String[] availName;
    private Vector selectedName = new Vector();
    private Vector selectedIndex = new Vector();
    private JRadioButton asc;
    private JRadioButton desc;
    private JButton add;
    private JButton remove;
    private int selected;

    public SortByDialog(ReportMain reportMain) {
        super(reportMain, LanguageEncoder.getText("Preview Sorting"), true);
        this.reportMain = reportMain;
        this.init();
        this.setPosition();
    }

    private void init() {
        int i;
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Sorting Info")));
        topPanel.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new GridLayout(1, 4, 5, 5));
        titlePanel.add(new JLabel(LanguageEncoder.getText("Available Columns")));
        titlePanel.add(new JLabel(""));
        titlePanel.add(new JLabel(LanguageEncoder.getText("Sort By Columns")));
        titlePanel.add(new JLabel(""));
        Vector<String> columns = new Vector<String>();
        Report report = this.reportMain.previewPanel.viewer.getReportCanvas().getReport();
        ReportTable reporttable = report.getReportTables().elementAt(0);
        if (report.getReportType() != 2) {
            for (i = 0; i < reporttable.getColumnCount(); ++i) {
                if (!reporttable.getColumn(i).isVisible() && (report.getReportType() != 3 || !report.colInfo[i].isMaster())) continue;
                Object tbl = reporttable;
                while (tbl instanceof ReportTreeTable) {
                    tbl = ((ReportTreeTable)tbl).getSubTable().elementAt(0);
                }
                if (((ReportTable)tbl).getColumn(i).getData(0) instanceof ReportImage || ((ReportTable)tbl).getColumn(i).getData(0) instanceof ReportDocument) continue;
                columns.addElement(reporttable.getColumn(i).getText());
            }
        } else {
            ColInfo[] colInfo = report.colInfo;
            for (ColInfo element : colInfo) {
                if (!element.isVisible() || !element.isRowBreak()) continue;
                columns.addElement(element.getName());
            }
        }
        this.availName = new String[columns.size()];
        for (i = 0; i < this.availName.length; ++i) {
            this.availName[i] = (String)columns.elementAt(i);
        }
        this.availList = new JList<String>(this.availName);
        MouseAdapter addListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int idx = SortByDialog.this.availList.locationToIndex(e.getPoint());
                    if (SortByDialog.this.isItemSelected(SortByDialog.this.availName[idx])) {
                        return;
                    }
                    if (!SortByDialog.this.desc.isSelected()) {
                        SortByDialog.this.selectedName.addElement(SortByDialog.this.setAscending(SortByDialog.this.availName[idx]));
                    } else {
                        SortByDialog.this.selectedName.addElement(SortByDialog.this.setDescending(SortByDialog.this.availName[idx]));
                    }
                    SortByDialog.this.selectedIndex.addElement(idx);
                    SortByDialog.this.sortbyList.setListData(SortByDialog.this.selectedName);
                    SortByDialog.this.sortbyList.setSelectedIndex(SortByDialog.this.selectedName.size() - 1);
                }
            }
        };
        this.availList.addMouseListener(addListener);
        MouseAdapter removeListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int idx = SortByDialog.this.sortbyList.locationToIndex(e.getPoint());
                    SortByDialog.this.selectedName.removeElementAt(idx);
                    SortByDialog.this.selectedIndex.removeElementAt(idx);
                    SortByDialog.this.sortbyList.setListData(SortByDialog.this.selectedName);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SortByDialog.this.selected = SortByDialog.this.sortbyList.locationToIndex(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int idx = SortByDialog.this.sortbyList.locationToIndex(e.getPoint());
                if (idx != SortByDialog.this.selected) {
                    Object obj = SortByDialog.this.selectedName.remove(SortByDialog.this.selected);
                    Object obj2 = SortByDialog.this.selectedIndex.remove(SortByDialog.this.selected);
                    SortByDialog.this.selectedName.add(idx, obj);
                    SortByDialog.this.selectedIndex.add(idx, obj2);
                    SortByDialog.this.sortbyList.setListData(SortByDialog.this.selectedName);
                    SortByDialog.this.sortbyList.setSelectedIndex(idx);
                }
            }
        };
        this.sortbyList = new JList<String>(new String[]{""});
        this.sortbyList.addMouseListener(removeListener);
        this.sortbyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String columnName = (String)SortByDialog.this.sortbyList.getSelectedValue();
                if (columnName == null) {
                    return;
                }
                if (columnName.endsWith(" DESC")) {
                    SortByDialog.this.desc.setSelected(true);
                } else if (columnName.endsWith(" ASC")) {
                    SortByDialog.this.asc.setSelected(true);
                }
            }
        });
        JPanel listButtonPanel = new JPanel();
        listButtonPanel.setLayout(new GridLayout(5, 1, 5, 5));
        listButtonPanel.add(new JLabel(""));
        this.add = new JButton(LanguageEncoder.getText("ADD >>"));
        listButtonPanel.add(this.add);
        this.add.addActionListener(this);
        listButtonPanel.add(new JLabel(""));
        this.remove = new JButton(LanguageEncoder.getText("<< REMOVE"));
        listButtonPanel.add(this.remove);
        this.remove.addActionListener(this);
        listButtonPanel.add(new JLabel(""));
        JPanel orderButtonPanel = new JPanel();
        ButtonGroup group = new ButtonGroup();
        orderButtonPanel.setLayout(new GridLayout(5, 1, 5, 5));
        orderButtonPanel.add(new JLabel(""));
        this.asc = new JRadioButton(LanguageEncoder.getText("Ascending"), true);
        orderButtonPanel.add(this.asc);
        this.asc.addItemListener(this);
        orderButtonPanel.add(new JLabel(""));
        this.desc = new JRadioButton(LanguageEncoder.getText("Descending"));
        orderButtonPanel.add(this.desc);
        this.desc.addItemListener(this);
        orderButtonPanel.add(new JLabel(""));
        group.add(this.asc);
        group.add(this.desc);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new GridLayout(1, 4));
        listPanel.add(new JScrollPane(this.availList));
        listPanel.add(listButtonPanel);
        listPanel.add(new JScrollPane(this.sortbyList));
        listPanel.add(orderButtonPanel);
        topPanel.add("North", titlePanel);
        topPanel.add("Center", listPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        this.setBackground(Color.lightGray);
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add("Center", topPanel);
        contentPanel.add("South", buttonPanel);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.asc && this.asc.isSelected()) {
            int[] tmp;
            for (int element : tmp = this.sortbyList.getSelectedIndices()) {
                this.selectedName.setElementAt(this.setAscending((String)this.selectedName.elementAt(element)), element);
            }
            this.sortbyList.setListData(this.selectedName);
            this.sortbyList.setSelectedIndices(tmp);
        } else if (e.getSource() == this.desc && this.desc.isSelected()) {
            int[] tmp;
            for (int element : tmp = this.sortbyList.getSelectedIndices()) {
                this.selectedName.setElementAt(this.setDescending((String)this.selectedName.elementAt(element)), element);
            }
            this.sortbyList.setListData(this.selectedName);
            this.sortbyList.setSelectedIndices(tmp);
        }
    }

    private boolean isItemSelected(String newItem) {
        if (this.selectedName == null) {
            return false;
        }
        String columnName = newItem;
        if (newItem.endsWith(" ASC")) {
            columnName = newItem.substring(0, columnName.length() - 4);
        } else if (columnName.endsWith(" DESC")) {
            columnName = newItem.substring(0, columnName.length() - 5);
        }
        for (int i = 0; i < this.selectedName.size(); ++i) {
            String selName = (String)this.selectedName.elementAt(i);
            if (selName.endsWith(" ASC")) {
                selName = selName.substring(0, selName.length() - 4);
            } else if (selName.endsWith(" DESC")) {
                selName = selName.substring(0, selName.length() - 5);
            }
            if (!selName.equals(columnName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.add) {
            int[] tmp = this.availList.getSelectedIndices();
            this.availList.clearSelection();
            this.sortbyList.clearSelection();
            if (tmp == null || tmp.length == 0) {
                return;
            }
            for (int element : tmp) {
                if (this.isItemSelected(this.availName[element])) continue;
                if (!this.desc.isSelected()) {
                    this.selectedName.addElement(this.setAscending(this.availName[element]));
                } else {
                    this.selectedName.addElement(this.setDescending(this.availName[element]));
                }
                this.selectedIndex.addElement(element);
            }
            this.sortbyList.setListData(this.selectedName);
            int[] idx = new int[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                idx[i] = this.selectedName.size() - 1 - i;
            }
            this.sortbyList.setSelectedIndices(idx);
        } else if (e.getSource() == this.remove) {
            int[] tmp = this.sortbyList.getSelectedIndices();
            this.sortbyList.clearSelection();
            if (tmp == null || tmp.length == 0) {
                return;
            }
            for (int i = tmp.length - 1; i >= 0; --i) {
                this.selectedName.removeElementAt(tmp[i]);
                this.selectedIndex.removeElementAt(tmp[i]);
            }
            this.sortbyList.setListData(this.selectedName);
        } else if (e.getSource() == this.okButton) {
            Vector<String> sortByColumns = new Vector<String>();
            boolean[] isAsc = new boolean[this.selectedName.size()];
            for (int i = 0; i < this.selectedName.size(); ++i) {
                String columnName = (String)this.selectedName.elementAt(i);
                if (columnName.endsWith(" ASC")) {
                    sortByColumns.addElement(columnName.substring(0, columnName.length() - 4));
                    isAsc[i] = true;
                    continue;
                }
                if (columnName.endsWith(" DESC")) {
                    sortByColumns.addElement(columnName.substring(0, columnName.length() - 5));
                    isAsc[i] = false;
                    continue;
                }
                sortByColumns.addElement(columnName);
                isAsc[i] = true;
            }
            Report report = this.reportMain.previewPanel.viewer.getReportCanvas().getReport();
            ReportTable table = report.getReportTables().elementAt(0);
            int[] colIndex = new int[this.selectedName.size()];
            block4: for (int j = 0; j < sortByColumns.size(); ++j) {
                String sortBy = (String)sortByColumns.elementAt(j);
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    ReportColumn reportcolumn = table.getColumn(i);
                    if (!sortBy.equals(reportcolumn.getText()) && !sortBy.equals(report.colInfo[i].getName())) continue;
                    colIndex[j] = i;
                    continue block4;
                }
            }
            table.createIndexArray(colIndex, 0, isAsc, report, 0);
            this.reportMain.previewPanel.viewer.getReportCanvas().setRepaint(report);
            this.dispose();
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
            this.setVisible(false);
        }
    }

    private String setAscending(String columnName) {
        if (columnName.endsWith(" ASC")) {
            return columnName;
        }
        if (columnName.endsWith(" DESC")) {
            return columnName.substring(0, columnName.length() - 5) + " ASC";
        }
        return columnName + " ASC";
    }

    private String setDescending(String columnName) {
        if (columnName.endsWith(" DESC")) {
            return columnName;
        }
        if (columnName.endsWith(" ASC")) {
            return columnName.substring(0, columnName.length() - 4) + " DESC";
        }
        return columnName + " DESC";
    }
}

