/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.util.DateTimeFormat;

public class StandardDateTimeDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(StandardDateTimeDialog.class.getName());
    DateTimeFormat dtf;
    boolean showDate;
    boolean showTime;
    boolean showHide;
    JComboBox choiceDateOrder;
    JTextField textDateSep1;
    JTextField textDateSep2;
    JComboBox choiceYear;
    JComboBox choiceMonth;
    JCheckBox chk24;
    JCheckBox chkMinutes;
    JCheckBox chkSeconds;
    JTextField textTimeSep1;
    JTextField textTimeSep2;
    JTextField spinDecimals;
    JCheckBox chkTimeFirst;
    JCheckBox hideyear;
    JCheckBox hidemonth;
    JCheckBox hidedate;
    JCheckBox fixdigit;
    JCheckBox hideTimestampTime;
    JTextField textDateTimeSep;
    DateTimeFormat format;
    JPanel datePanel;
    JPanel timePanel;
    JPanel timeStampPanel;
    JButton btnOk;
    JButton btnCancel;

    public StandardDateTimeDialog(JFrame frame, String title, DateTimeFormat dtf, boolean showDate, boolean showTime, boolean showHide) {
        super(frame, title, true);
        this.init(dtf, showDate, showTime, showHide);
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init(DateTimeFormat dtf, boolean showDate, boolean showTime, boolean showHide) {
        this.dtf = dtf;
        this.showDate = showDate;
        this.showTime = showTime;
        this.showHide = showHide;
        this.setBackground(Color.lightGray);
        JPanel plMain = new JPanel();
        plMain.setBorder(new TitledBorder(LanguageEncoder.getText("Format")));
        this.datePanel = new JPanel();
        this.datePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Date Options")));
        this.datePanel.setLayout(new FlowLayout(1));
        this.timePanel = new JPanel();
        this.timePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Time Options")));
        this.timePanel.setLayout(new FlowLayout(1));
        this.timeStampPanel = new JPanel();
        this.timeStampPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Timestamp Options")));
        this.timeStampPanel.setLayout(new FlowLayout(1));
        plMain.setLayout(new BorderLayout());
        plMain.add("North", this.datePanel);
        plMain.add("Center", this.timePanel);
        plMain.add("South", this.timeStampPanel);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(3, 1, 5, 5));
        this.choiceYear = new JComboBox();
        panel.add(this.labelComponent(LanguageEncoder.getText("Year:"), this.choiceYear));
        this.choiceMonth = new JComboBox();
        panel.add(this.labelComponent(LanguageEncoder.getText("Month:"), this.choiceMonth));
        this.choiceDateOrder = new JComboBox();
        panel.add(this.labelComponent(LanguageEncoder.getText("Order:"), this.choiceDateOrder));
        this.datePanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1, 5, 5));
        this.textDateSep1 = new JTextField(10);
        panel.add(this.labelComponent(LanguageEncoder.getText("Separator 1:"), this.textDateSep1));
        this.textDateSep2 = new JTextField(10);
        panel.add(this.labelComponent(LanguageEncoder.getText("Separator 2:"), this.textDateSep2));
        JPanel hidepanel = new JPanel();
        hidepanel.setLayout(new GridLayout(2, 2));
        this.hideyear = new JCheckBox(LanguageEncoder.getText("Hide year"));
        hidepanel.add(this.hideyear);
        this.hidemonth = new JCheckBox(LanguageEncoder.getText("Hide month"));
        hidepanel.add(this.hidemonth);
        this.hidedate = new JCheckBox(LanguageEncoder.getText("Hide day"));
        hidepanel.add(this.hidedate);
        this.fixdigit = new JCheckBox(LanguageEncoder.getText("Fix digit length"));
        hidepanel.add(this.fixdigit);
        if (showHide) {
            panel.add(hidepanel);
        } else {
            panel.add(new Label(""));
        }
        this.datePanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new GridLayout(3, 1, 5, 5));
        this.chk24 = new JCheckBox(LanguageEncoder.getText("24-hour clock"));
        panel.add(this.chk24);
        this.chkMinutes = new JCheckBox(LanguageEncoder.getText("Minutes"));
        panel.add(this.chkMinutes);
        this.chkSeconds = new JCheckBox(LanguageEncoder.getText("Seconds"));
        panel.add(this.chkSeconds);
        this.timePanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new GridLayout(3, 1, 5, 5));
        this.textTimeSep1 = new JTextField(10);
        panel.add(this.labelComponent(LanguageEncoder.getText("Separator:"), this.textTimeSep1));
        this.textTimeSep2 = new JTextField(10);
        panel.add(this.labelComponent(LanguageEncoder.getText("Separator:"), this.textTimeSep2));
        this.spinDecimals = new JTextField(3);
        panel.add(this.labelComponent(LanguageEncoder.getText("Decimals:"), this.spinDecimals));
        this.timePanel.add(panel);
        this.chkTimeFirst = new JCheckBox(LanguageEncoder.getText("Time before date"));
        this.timeStampPanel.add(this.chkTimeFirst);
        this.timeStampPanel.add(new JLabel(LanguageEncoder.getText("Separator:")));
        this.textDateTimeSep = new JTextField(10);
        this.timeStampPanel.add(this.textDateTimeSep);
        this.hideTimestampTime = new JCheckBox(LanguageEncoder.getText("Hide Time display"));
        this.timeStampPanel.add(this.hideTimestampTime);
        this.choiceDateOrder.addItem(LanguageEncoder.getText("MDY"));
        this.choiceDateOrder.addItem(LanguageEncoder.getText("DMY"));
        this.choiceDateOrder.addItem(LanguageEncoder.getText("YMD"));
        this.choiceYear.addItem("1997");
        this.choiceYear.addItem("97");
        this.choiceMonth.addItem("10");
        this.choiceMonth.addItem(LanguageEncoder.getText("Oct"));
        this.choiceMonth.addItem(LanguageEncoder.getText("October"));
        if (!showDate) {
            this.datePanel.setVisible(false);
        }
        if (!showTime) {
            this.timePanel.setVisible(false);
        }
        if (!showDate || !showTime) {
            this.timeStampPanel.setVisible(false);
        }
        JPanel plButton = new JPanel(new FlowLayout(2));
        this.btnOk = new JButton(LanguageEncoder.getText("OK"));
        this.btnOk.addActionListener(this);
        this.btnCancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.btnCancel.addActionListener(this);
        plButton.add(this.btnOk);
        plButton.add(this.btnCancel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("North", plMain);
        contentPane.add("Center", plButton);
        this.setFormat(dtf);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOk) {
            this.saveFormat();
        }
        this.dispose();
    }

    DateTimeFormat getFormat() {
        return this.dtf;
    }

    private void setFormat(DateTimeFormat format) {
        this.format = format;
        this.choiceYear.setSelectedIndex(format.yearSymbol);
        this.choiceMonth.setSelectedIndex(format.monthSymbol);
        this.choiceDateOrder.setSelectedIndex(format.orderSymbol);
        this.textDateSep1.setText(format.separator1);
        this.textDateSep2.setText(format.separator2);
        this.chk24.setSelected(format.hour24);
        this.chkMinutes.setSelected(format.showMinute);
        this.chkSeconds.setSelected(format.showSecond);
        this.textTimeSep1.setText(format.hourMinuteSep);
        this.textTimeSep2.setText(format.minuteSecondSep);
        this.spinDecimals.setText("" + format.nanoDecimal);
        this.chkTimeFirst.setSelected(format.timeBeforeDate);
        this.textDateTimeSep.setText(format.timeDateSep);
        this.hidedate.setSelected(format.hidedate);
        this.hideyear.setSelected(format.hideyear);
        this.hidemonth.setSelected(format.hidemonth);
        this.fixdigit.setSelected(format.fixDigitLen);
        this.hideTimestampTime.setSelected(format.hideTimestampTime);
    }

    private void saveFormat() {
        this.dtf = new DateTimeFormat();
        this.dtf.yearSymbol = (short)this.choiceYear.getSelectedIndex();
        this.dtf.monthSymbol = (short)this.choiceMonth.getSelectedIndex();
        this.dtf.orderSymbol = (short)this.choiceDateOrder.getSelectedIndex();
        this.dtf.separator1 = this.textDateSep1.getText();
        this.dtf.separator2 = this.textDateSep2.getText();
        this.dtf.hour24 = this.chk24.isSelected();
        this.dtf.showMinute = this.chkMinutes.isSelected();
        this.dtf.showSecond = this.chkSeconds.isSelected();
        this.dtf.hourMinuteSep = this.textTimeSep1.getText();
        this.dtf.minuteSecondSep = this.textTimeSep2.getText();
        this.dtf.nanoDecimal = 0;
        try {
            this.dtf.nanoDecimal = (short)Integer.valueOf(this.spinDecimals.getText()).intValue();
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Invalid number", ex);
        }
        this.dtf.nanoDecimal = (short)(this.dtf.nanoDecimal > 9 ? 9 : (this.dtf.nanoDecimal < 0 ? 0 : (int)this.dtf.nanoDecimal));
        this.dtf.timeBeforeDate = this.chkTimeFirst.isSelected();
        this.dtf.timeDateSep = this.textDateTimeSep.getText();
        this.dtf.hidemonth = this.hidemonth.isSelected();
        this.dtf.hideyear = this.hideyear.isSelected();
        this.dtf.hidedate = this.hidedate.isSelected();
        this.dtf.fixDigitLen = this.fixdigit.isSelected();
        this.dtf.hideTimestampTime = this.hideTimestampTime.isSelected();
    }

    private JPanel labelComponent(String label, Component component) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 5, 2));
        panel.add(new JLabel(label));
        panel.add(component);
        return panel;
    }
}

