/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.util.StringFormat;

public class StringDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(StringDialog.class.getName());
    StringFormat sf;
    JCheckBox showOriginalText;
    JTextField maxChar;
    JButton btnOk;
    JButton btnCancel;
    private boolean modified = false;

    public StringDialog(JFrame frame, String title, StringFormat sf) {
        super(frame, title, true);
        this.init(sf);
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init(StringFormat sf) {
        this.sf = sf;
        this.setBackground(Color.lightGray);
        JPanel plMain = new JPanel();
        plMain.setBorder(new TitledBorder(LanguageEncoder.getText("String Format")));
        plMain.setLayout(new BorderLayout());
        plMain.add("West", new JLabel(LanguageEncoder.getText("Set Maximum Character")));
        this.maxChar = new JTextField(3);
        plMain.add("Center", this.maxChar);
        this.showOriginalText = new JCheckBox(LanguageEncoder.getText("Show Original Text"));
        plMain.add("South", this.showOriginalText);
        this.showOriginalText.addActionListener(this);
        this.showOriginalText.setSelected(sf.getMaxCharacter() < 0);
        this.maxChar.setText(sf.getMaxCharacter() < 0 ? "15" : sf.getMaxCharacter() + "");
        this.maxChar.setEnabled(!this.showOriginalText.isSelected());
        JPanel plButton = new JPanel(new FlowLayout(2));
        this.btnOk = new JButton(LanguageEncoder.getText("OK"));
        this.btnOk.addActionListener(this);
        this.btnCancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.btnCancel.addActionListener(this);
        plButton.add(this.btnOk);
        plButton.add(this.btnCancel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("North", plMain);
        contentPane.add("Center", plButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOk) {
            try {
                this.sf = new StringFormat(this.showOriginalText.isSelected() ? -1 : Integer.valueOf(this.maxChar.getText()));
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "String type is not supported", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("String type is not supported!"));
                return;
            }
            this.modified = true;
            this.dispose();
        } else if (e.getSource() == this.btnCancel) {
            this.dispose();
        } else {
            this.maxChar.setEnabled(!this.showOriginalText.isSelected());
            return;
        }
    }

    StringFormat getFormat() {
        return this.sf;
    }

    public boolean isModified() {
        return this.modified;
    }
}

