/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.AlphanumericBarcodeDialog;
import quadbase.reportdesigner.designer.PanelAction;
import quadbase.reportdesigner.designer.StringDialog;
import quadbase.reportdesigner.util.BarcodeFormat;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.ImageURLFormat;
import quadbase.reportdesigner.util.StringFormat;
import quadbase.reportdesigner.util.TextURLFormat;

public class StringPanel
extends PanelAction
implements ItemListener {
    private static final Logger LOGGER = Logger.getLogger(StringPanel.class.getName());
    JFrame frame;
    JButton btnFormat;
    StringFormat sf;
    BarcodeFormat bf;
    ImageURLFormat iuf;
    TextURLFormat tuf;
    ButtonGroup group;
    JRadioButton chkString;
    JRadioButton chkBarcode;
    JRadioButton chkImageURL;
    JRadioButton chkTextURL;
    JTabbedPane parentTabbedPane;

    public StringPanel(JFrame frame, IFormat format) {
        this.frame = frame;
        this.init(format);
    }

    private void init(IFormat format) {
        this.setBorder(new TitledBorder(LanguageEncoder.getText("String Format")));
        this.setLayout(new GridLayout(2, 1, 5, 5));
        this.group = new ButtonGroup();
        JPanel plString = new JPanel(new FlowLayout(0));
        this.chkString = new JRadioButton(LanguageEncoder.getText("String"), true);
        plString.add(this.chkString);
        this.chkString.addItemListener(this);
        this.group.add(this.chkString);
        JPanel plBarcode = new JPanel(new FlowLayout(0));
        this.chkBarcode = new JRadioButton(LanguageEncoder.getText("Bar code"), false);
        plBarcode.add(this.chkBarcode);
        this.chkBarcode.addItemListener(this);
        this.group.add(this.chkBarcode);
        JPanel plImageURL = new JPanel(new FlowLayout(0));
        this.chkImageURL = new JRadioButton(LanguageEncoder.getText("Image Url"), false);
        plImageURL.add(this.chkImageURL);
        this.chkImageURL.addItemListener(this);
        this.group.add(this.chkImageURL);
        JPanel plTextURL = new JPanel(new FlowLayout(0));
        this.chkTextURL = new JRadioButton(LanguageEncoder.getText("Text Url"), false);
        plTextURL.add(this.chkTextURL);
        this.chkTextURL.addItemListener(this);
        this.group.add(this.chkTextURL);
        this.btnFormat = new JButton(LanguageEncoder.getText("Format..."));
        plBarcode.add(this.btnFormat);
        this.btnFormat.addActionListener(this);
        this.setLayout(new GridLayout(4, 1));
        this.add(plString);
        this.add(plImageURL);
        this.add(plTextURL);
        this.add(plBarcode);
        if (format instanceof StringFormat) {
            this.sf = (StringFormat)format;
            this.chkString.setSelected(true);
        } else if (format instanceof BarcodeFormat) {
            this.bf = (BarcodeFormat)format;
            this.chkBarcode.setSelected(true);
        } else if (format instanceof ImageURLFormat) {
            this.iuf = (ImageURLFormat)format;
            this.chkImageURL.setSelected(true);
        } else if (format instanceof TextURLFormat) {
            this.tuf = (TextURLFormat)format;
            this.chkTextURL.setSelected(true);
        } else {
            LOGGER.warning("Unknown format");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (this.chkString.isSelected()) {
                if (this.sf == null) {
                    this.sf = new StringFormat();
                }
                this.btnFormat.setEnabled(true);
                if (this.parentTabbedPane != null) {
                    this.parentTabbedPane.setEnabledAt(1, true);
                    this.parentTabbedPane.setEnabledAt(2, true);
                }
            } else if (this.chkBarcode.isSelected()) {
                if (this.bf == null) {
                    this.bf = new BarcodeFormat(0);
                }
                this.btnFormat.setEnabled(true);
                if (this.parentTabbedPane != null) {
                    this.parentTabbedPane.setEnabledAt(1, false);
                    this.parentTabbedPane.setEnabledAt(2, false);
                }
            } else if (this.chkImageURL.isSelected()) {
                if (this.iuf == null) {
                    this.iuf = new ImageURLFormat();
                }
                this.btnFormat.setEnabled(false);
                if (this.parentTabbedPane != null) {
                    this.parentTabbedPane.setEnabledAt(1, false);
                    this.parentTabbedPane.setEnabledAt(2, false);
                }
            } else if (this.chkTextURL.isSelected()) {
                if (this.tuf == null) {
                    this.tuf = new TextURLFormat();
                }
                this.btnFormat.setEnabled(false);
                if (this.parentTabbedPane != null) {
                    this.parentTabbedPane.setEnabledAt(1, true);
                    this.parentTabbedPane.setEnabledAt(2, true);
                }
            }
            this.fireEvent(this, 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showFormatDialog();
        this.fireEvent(this, 0);
    }

    private void showFormatDialog() {
        if (this.chkString.isSelected()) {
            StringDialog sd = new StringDialog(this.frame, LanguageEncoder.getText("String Format..."), this.sf);
            sd.setVisible(true);
            this.sf = sd.getFormat();
        } else if (this.chkBarcode.isSelected()) {
            AlphanumericBarcodeDialog abd = new AlphanumericBarcodeDialog(this.frame, LanguageEncoder.getText("Barcode Format..."), this.bf);
            abd.setVisible(true);
            this.bf = abd.getFormat();
        }
    }

    public void setJTabbedPane(JTabbedPane pane) {
        this.parentTabbedPane = pane;
    }

    public IFormat getFormat() {
        if (this.chkString.isSelected()) {
            return this.sf;
        }
        if (this.chkBarcode.isSelected()) {
            return this.bf;
        }
        if (this.chkImageURL.isSelected()) {
            return this.iuf;
        }
        if (this.chkTextURL.isSelected()) {
            return this.tuf;
        }
        return null;
    }
}

