/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.designer.ReportMain;

public class StyleChooser
extends JPanel {
    public static final int INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    ReportMain reportMain;
    ReportElement elt;
    int i = 0;
    int lineStyle = 0;
    int gridStyle = 0;

    public StyleChooser(ReportMain reportMain, ReportElement elt) {
        this.reportMain = reportMain;
        this.elt = elt;
        if (elt instanceof ReportLine) {
            this.i = ((ReportLine)elt).getLineStyle();
        } else if (elt instanceof ReportGrid) {
            this.i = ((ReportGrid)elt).getGridStyle();
        }
        this.addMouseListener(new Style());
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle drawHere = g.getClipBounds();
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.white);
        g2.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g2.setColor(Color.black);
        if (this.i % 3 == 1) {
            g.drawLine(2, 8, 80, 8);
            if (this.elt instanceof ReportLine) {
                this.lineStyle = 1;
            } else if (this.elt instanceof ReportGrid) {
                this.gridStyle = 1;
            } else {
                return;
            }
        }
        if (this.i % 3 == 2) {
            g.drawLine(2, 8, 80, 8);
            g.drawLine(2, 10, 80, 10);
            if (this.elt instanceof ReportLine) {
                this.lineStyle = 2;
            } else if (this.elt instanceof ReportGrid) {
                this.gridStyle = 2;
            } else {
                return;
            }
        }
        if (this.i % 3 == 0) {
            for (int j = 2; j <= 80; j += 5) {
                g.drawLine(j, 8, j + 2, 8);
            }
            if (this.elt instanceof ReportLine) {
                this.lineStyle = 3;
            } else if (this.elt instanceof ReportGrid) {
                this.gridStyle = 3;
            } else {
                return;
            }
        }
    }

    public void setStyle() {
        if (this.elt instanceof ReportLine) {
            ((ReportLine)this.elt).setLineStyle(this.lineStyle);
        } else if (this.elt instanceof ReportGrid) {
            ((ReportGrid)this.elt).setGridStyle(this.gridStyle);
        }
    }

    class Style
    extends MouseAdapter {
        Style() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ++StyleChooser.this.i;
            StyleChooser.this.repaint();
        }
    }
}

