/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import quadbase.common.param.ParamUtil;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.designer.DrillDownColumnMapDialog;
import quadbase.reportdesigner.designer.InternalListItem;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;

public class SubReportParameterDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(SubReportParameterDialog.class.getName());
    private Report report = null;
    private JCheckBox[][] map = null;
    private JComboBox[][] columnChoices = null;
    private SubReportObject[] selectedSubReports = null;
    private Vector<SubReportObject> subreports = null;
    private JCheckBox limitQueryExecutionCheck;
    private JButton okButton;
    private JButton cancelButton;
    private boolean modified = false;

    public SubReportParameterDialog(JFrame parent, Report r, Vector<SubReportObject> sr) throws Exception {
        super((Frame)parent, true);
        this.report = r;
        this.init(sr);
    }

    private void init(Vector<SubReportObject> subreports) throws Exception {
        Vector<QueryInParamSet> paramsets = new Vector<QueryInParamSet>();
        Vector<Integer> indices = new Vector<Integer>();
        if (subreports != null) {
            this.subreports = subreports;
            for (int i = 0; i < subreports.size(); ++i) {
                LoadReport lr = new LoadReport(false);
                lr.setSubFilesTable(this.report.getSubFilesTable());
                lr.loadDataHeaderOnly(subreports.elementAt(i).getFileName());
                if ((lr.getSourceDataType() == 1 || lr.getSourceDataType() == 6) && lr.getDBInfo() != null && lr.getDBInfo() instanceof QueryFileInfo) {
                    paramsets.addElement(((QueryFileInfo)lr.getDBInfo()).getInSet());
                    indices.addElement(i + 1);
                }
                if (lr.getSourceDataType() == 7 && lr.getDBInfo() != null && lr.getDBInfo() instanceof QueryXMLFileInfo) {
                    paramsets.addElement(((QueryXMLFileInfo)lr.getDBInfo()).getXMLFileQueryInfo().getInSet());
                    indices.addElement(i + 1);
                }
                if ((lr.getSourceDataType() != 12 || !(lr.getDBInfo() instanceof SOAPQueryFileInfo)) && (lr.getSourceDataType() != 11 || !(lr.getDBInfo() instanceof SalesForceQueryFileInfo))) continue;
                paramsets.addElement(((QueryFileInfo)lr.getDBInfo()).getInSet());
                indices.addElement(i + 1);
            }
        }
        if (paramsets.size() <= 0) {
            throw new Exception(LanguageEncoder.getText("This report does not contain any parameterized sub-reports."));
        }
        this.setBackground(Color.lightGray);
        this.setTitle(LanguageEncoder.getText("Sub-Report Parameters"));
        this.setDefaultCloseOperation(2);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.map = new JCheckBox[paramsets.size()][];
        this.columnChoices = new JComboBox[paramsets.size()][];
        JPanel[] topPanel = new JPanel[paramsets.size()];
        this.selectedSubReports = new SubReportObject[paramsets.size()];
        for (int j = 0; j < paramsets.size(); ++j) {
            QueryInParam[] params = ((QueryInParamSet)paramsets.elementAt(j)).getParameter();
            this.map[j] = new JCheckBox[params.length];
            JComboBox[] boxes = new JComboBox[params.length];
            this.columnChoices[j] = boxes;
            if (subreports != null) {
                this.selectedSubReports[j] = subreports.elementAt((Integer)indices.elementAt(j) - 1);
            }
            topPanel[j] = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            topPanel[j].setLayout(gbl);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.anchor = 18;
            for (int i = 0; i < params.length; ++i) {
                gbc.gridx = 0;
                gbc.gridy = i;
                QueryInParam currP = params[i];
                this.map[j][i] = new JCheckBox(currP.getPromptName());
                gbl.setConstraints(this.map[j][i], gbc);
                topPanel[j].add(this.map[j][i]);
                Vector<InternalListItem> compColumns = DrillDownColumnMapDialog.getCompatibleColumns(currP.getSqlType(), this.report);
                JComboBox choice = null;
                if (compColumns == null) {
                    choice = new JComboBox(new String[]{"No match, use default."});
                    choice.setEnabled(false);
                    this.map[j][i].setEnabled(false);
                    if (i < this.columnChoices.length) {
                        this.columnChoices[j][i] = null;
                    }
                } else {
                    boxes[i] = new JComboBox<InternalListItem>(compColumns);
                    int def = -2;
                    for (int k = 0; k < compColumns.size(); ++k) {
                        String[] parameterMap = this.selectedSubReports[j].getParameterMap();
                        if (parameterMap == null || parameterMap.length <= i || compColumns.elementAt((int)k).column_id == null || !compColumns.elementAt((int)k).column_id.equals(parameterMap[i])) continue;
                        def = k;
                        k = compColumns.size();
                    }
                    if (def >= 0) {
                        boxes[i].setSelectedIndex(def);
                        this.map[j][i].setSelected(true);
                    }
                    choice = boxes[i];
                }
                gbc.gridx = 1;
                gbl.setConstraints(choice, gbc);
                topPanel[j].add(choice);
            }
            topPanel[j].setBorder(new TitledBorder("Parameter Mapping"));
            tabbedPane.addTab("Sub-Report_" + ((Integer)indices.elementAt(j)).toString(), topPanel[j]);
        }
        tabbedPane.setSelectedIndex(paramsets.size() - 1);
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new FlowLayout(0));
        this.limitQueryExecutionCheck = new JCheckBox(LanguageEncoder.getText("Limit linked Sub-Report Query Execution"), this.report.limitSubReportQueryExecution);
        middlePanel.add(this.limitQueryExecutionCheck);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        bottomPanel.add(this.okButton);
        bottomPanel.add(this.cancelButton);
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)tabbedPane, "North");
        contentPanel.add((Component)middlePanel, "Center");
        contentPanel.add((Component)bottomPanel, "South");
        this.pack();
        Dimension screensize = this.getToolkit().getScreenSize();
        int width = this.getPreferredSize().width;
        int height = this.getPreferredSize().height;
        if (height < 200) {
            height = 200;
        }
        if (width < 300) {
            width = 300;
        }
        this.setBounds((screensize.width - width) / 2, (screensize.height - height) / 2, width, height);
        this.setSize(width, height);
        tabbedPane.setSelectedIndex(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            try {
                for (int i = 0; i < this.selectedSubReports.length; ++i) {
                    Parameter conflictParam;
                    String[] params = new String[this.columnChoices[i].length];
                    for (int j = 0; j < params.length; ++j) {
                        params[j] = this.columnChoices[i][j] == null || !this.map[i][j].isSelected() ? null : ((InternalListItem)this.columnChoices[i][j].getSelectedItem()).column_id;
                    }
                    int subIndex = i;
                    for (int inx = 0; inx < this.subreports.size(); ++inx) {
                        if (!this.subreports.get(inx).getCustomID().equals(this.selectedSubReports[i].getCustomID())) continue;
                        subIndex = inx;
                        break;
                    }
                    if ((conflictParam = new ParamUtil().checkForConflict(this.report, subIndex, params)) != null) {
                        throw new Exception(LanguageEncoder.getText("The parameter") + conflictParam.getName() + " " + LanguageEncoder.getText("from") + conflictParam.getReportTitle() + " " + LanguageEncoder.getText("is both shared to other parameters and mapped to a field in the main report. This is not allowed, please remove the sharing or mapping and try again."));
                    }
                    this.selectedSubReports[i].setParameterMap(params);
                    this.report.setSubReportParameterMap(this.selectedSubReports[i].getFileName(), params);
                }
                this.report.limitSubReportQueryExecution = this.limitQueryExecutionCheck.isSelected();
                this.modified = true;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to perform changes", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage() == null ? LanguageEncoder.getText("An unexpected error has occured.\nPlease cancel and try again.") : ex.getMessage());
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }
}

