/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.TOCWizardStep2;

public class TOCWizardStep1
extends JDialog
implements ActionListener {
    JRadioButton useGroups;
    JRadioButton useBookmarks;
    JButton cancelButton;
    JButton nextButton;
    TableOfContents toc;
    ReportMain reportMain;

    public TOCWizardStep1(ReportMain reportMain, TableOfContents toc) {
        super(reportMain, LanguageEncoder.getText("Table of Contents"), !IOUtil.isMac() || !IOUtil.isJava14());
        this.reportMain = reportMain;
        this.toc = toc;
        this.init();
        this.setPosition();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new TitledBorder(LanguageEncoder.getText("Please select an option")));
        this.useGroups = new JRadioButton(LanguageEncoder.getText("Use Groups(Row Breaks)"), this.toc.isUseGroups());
        this.useBookmarks = new JRadioButton(LanguageEncoder.getText("Use Bookmarks"), !this.toc.isUseGroups());
        ButtonGroup group = new ButtonGroup();
        group.add(this.useGroups);
        group.add(this.useBookmarks);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayout(2, 1, 5, 5));
        panel1.add(this.useGroups);
        panel1.add(this.useBookmarks);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.nextButton = new JButton(LanguageEncoder.getText("Next>>"));
        this.nextButton.addActionListener(this);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(2));
        panel2.add(this.cancelButton);
        panel2.add(this.nextButton);
        panel.add((Component)panel1, "North");
        panel.add((Component)panel2, "South");
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add(panel);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.nextButton) {
            this.toc.setReport(this.reportMain.report);
            this.toc.setUseGroups(this.useGroups.isSelected());
            if (this.useGroups.isSelected() && this.reportMain.report.getReportType() == 0) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Cannot generate table of contents for Columnar report using groups"));
                return;
            }
            if (this.useGroups.isSelected() && this.toc.getLevels() == 0 && this.reportMain.report.getReportType() == 2) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Cannot generate table of contents for Crosstab report with less than 2 row breaks using groups"));
                return;
            }
            if (this.useGroups.isSelected() && this.toc.getLevels() == 0 && this.reportMain.report.getReportType() == 1) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Cannot generate table of contents for Summary break report with column aggregation using groups"));
                return;
            }
            this.setVisible(false);
            this.dispose();
            new TOCWizardStep2(this.reportMain, this.toc).setVisible(true);
        } else {
            this.setVisible(false);
            this.dispose();
            this.toc.setModified(false);
        }
    }
}

