/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.designer.NumberingFormatDialog;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.SelectFontDialog;
import quadbase.reportdesigner.designer.TOCWizardStep1;

public class TOCWizardStep2
extends JDialog
implements ActionListener,
ItemListener {
    ReportMain reportMain;
    TableOfContents toc;
    JButton selectFontBtn;
    JButton customizeBtn;
    JButton backBtn;
    JButton cancelBtn;
    JButton doneBtn;
    JCheckBox showNumbering;
    JCheckBox indent;
    JCheckBox showPageNumber;
    JCheckBox showSpacer;
    JComboBox numberingStyle;
    JComboBox spacerStyle;
    SpinBox indentSpace;
    JRadioButton leftToRight;
    JRadioButton rightToLeft;
    String[] style = new String[]{"Decimal", "Outline", "Bulleted"};
    String[] spacer = new String[]{"............", "______"};

    public TOCWizardStep2(ReportMain reportMain, TableOfContents toc) {
        super(reportMain, LanguageEncoder.getText("Table of Contents"), !IOUtil.isMac() || !IOUtil.isJava14());
        this.reportMain = reportMain;
        this.toc = toc;
        this.init();
        this.setPosition();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(LanguageEncoder.getText("Select TOC Options")));
        JPanel gridpanel = new JPanel();
        gridpanel.setLayout(new BoxLayout(gridpanel, 1));
        JPanel fontPanel = new JPanel(new FlowLayout(0));
        fontPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Font")));
        this.selectFontBtn = new JButton(LanguageEncoder.getText("Select Font"));
        this.selectFontBtn.addActionListener(this);
        fontPanel.add(this.selectFontBtn);
        gridpanel.add(fontPanel);
        JPanel numberingPanel = new JPanel(new BorderLayout());
        numberingPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Numbering")));
        JPanel numberingPanel1 = new JPanel(new FlowLayout(0));
        this.showNumbering = new JCheckBox(LanguageEncoder.getText("Show Numbering"), this.toc.isShowNumbering());
        this.showNumbering.addItemListener(this);
        numberingPanel1.add(this.showNumbering);
        numberingPanel.add(numberingPanel1);
        JPanel numberingPanel2 = new JPanel(new FlowLayout(0));
        numberingPanel2.add(new Label("Style"));
        this.numberingStyle = new JComboBox<String>(this.style);
        this.numberingStyle.setEnabled(this.toc.isShowNumbering());
        this.numberingStyle.setSelectedIndex(this.toc.getNumberingStyle());
        this.numberingStyle.addActionListener(this);
        numberingPanel2.add(this.numberingStyle);
        this.customizeBtn = new JButton(LanguageEncoder.getText("Customize"));
        this.customizeBtn.setEnabled(this.toc.isShowNumbering());
        if (this.numberingStyle.getSelectedIndex() == 2) {
            this.customizeBtn.setEnabled(false);
        }
        this.customizeBtn.addActionListener(this);
        numberingPanel2.add(this.customizeBtn);
        numberingPanel.add((Component)numberingPanel1, "North");
        numberingPanel.add((Component)numberingPanel2, "South");
        gridpanel.add(numberingPanel);
        JPanel indentPanel = new JPanel(new BorderLayout());
        indentPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Indentation")));
        JPanel indentPanel1 = new JPanel(new FlowLayout(0));
        this.indent = new JCheckBox(LanguageEncoder.getText("Indent sub-groups"), this.toc.getIndent() > 0);
        this.indent.addItemListener(this);
        indentPanel1.add(this.indent);
        JPanel indentPanel2 = new JPanel(new FlowLayout(0));
        indentPanel2.add(new Label("       Spaces"));
        this.indentSpace = new SpinBox(1, 100, 1);
        this.indentSpace.setEnabled(this.toc.getIndent() > 0);
        this.indentSpace.setValue(this.toc.getIndent());
        indentPanel2.add(this.indentSpace);
        indentPanel.add((Component)indentPanel1, "North");
        indentPanel.add((Component)indentPanel2, "South");
        gridpanel.add(indentPanel);
        JPanel pageNumberPanel = new JPanel(new BorderLayout());
        pageNumberPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Page Number")));
        JPanel pageNumberPanel1 = new JPanel(new FlowLayout(0));
        this.showPageNumber = new JCheckBox(LanguageEncoder.getText("Show Page Number"), this.toc.isShowPageNumber());
        this.showPageNumber.addItemListener(this);
        pageNumberPanel1.add(this.showPageNumber);
        JPanel pageNumberPanel2 = new JPanel(new FlowLayout(0));
        pageNumberPanel2.add(new Label("  "));
        this.showSpacer = new JCheckBox(LanguageEncoder.getText("Show Spacer"), this.toc.isShowSpacer());
        this.showSpacer.setEnabled(this.toc.isShowPageNumber());
        this.showSpacer.addItemListener(this);
        pageNumberPanel2.add(this.showSpacer);
        pageNumberPanel2.add(new Label(LanguageEncoder.getText("Style")));
        this.spacerStyle = new JComboBox<String>(this.spacer);
        this.spacerStyle.setEnabled(this.toc.isShowPageNumber() && this.toc.isShowSpacer());
        this.spacerStyle.setSelectedIndex(this.toc.getSpacerStyle());
        pageNumberPanel2.add(this.spacerStyle);
        pageNumberPanel.add((Component)pageNumberPanel1, "North");
        pageNumberPanel.add((Component)pageNumberPanel2, "South");
        gridpanel.add(pageNumberPanel);
        JPanel layoutPanel = new JPanel(new FlowLayout(0));
        layoutPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Layout")));
        this.leftToRight = new JRadioButton(LanguageEncoder.getText("Left to Right"), this.toc.getLayout() == 0);
        this.rightToLeft = new JRadioButton(LanguageEncoder.getText("Right to left"), this.toc.getLayout() == 1);
        layoutPanel.add(this.leftToRight);
        layoutPanel.add(this.rightToLeft);
        ButtonGroup group = new ButtonGroup();
        group.add(this.leftToRight);
        group.add(this.rightToLeft);
        gridpanel.add(layoutPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.backBtn = new JButton(LanguageEncoder.getText("<< Back"));
        buttonPanel.add(this.backBtn);
        this.backBtn.addActionListener(this);
        this.cancelBtn = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.cancelBtn);
        this.cancelBtn.addActionListener(this);
        this.doneBtn = new JButton(LanguageEncoder.getText("Done"));
        buttonPanel.add(this.doneBtn);
        this.doneBtn.addActionListener(this);
        panel.add((Component)gridpanel, "Center");
        panel.add((Component)buttonPanel, "South");
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)panel, "Center");
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object item = e.getItem();
        if (item == this.showNumbering) {
            if (this.numberingStyle != null) {
                this.numberingStyle.setEnabled(this.showNumbering.isSelected());
            }
            if (this.customizeBtn != null) {
                this.customizeBtn.setEnabled(this.showNumbering.isSelected());
                if (this.numberingStyle.getSelectedIndex() == 2) {
                    this.customizeBtn.setEnabled(false);
                }
            }
        } else if (item == this.indent) {
            if (this.indentSpace != null) {
                this.indentSpace.setEnabled(this.indent.isSelected());
            }
        } else if (item == this.showPageNumber) {
            if (this.showSpacer != null) {
                this.showSpacer.setEnabled(this.showPageNumber.isSelected());
            }
            if (this.spacerStyle != null) {
                this.spacerStyle.setEnabled(this.showPageNumber.isSelected());
            }
        } else if (item == this.showSpacer && this.spacerStyle != null) {
            this.spacerStyle.setEnabled(this.showSpacer.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.numberingStyle) {
            if (this.numberingStyle.getSelectedIndex() < 2) {
                if (this.customizeBtn != null) {
                    this.customizeBtn.setEnabled(true);
                }
            } else if (this.customizeBtn != null) {
                this.customizeBtn.setEnabled(false);
            }
        } else if (source == this.selectFontBtn) {
            if (this.toc.getLevels() > 0) {
                SelectFontDialog fontDialog = new SelectFontDialog(this.reportMain, this.toc);
                fontDialog.setVisible(true);
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("There is no groups in this report! You need at least one group to set Font!"));
            }
        } else if (source == this.customizeBtn) {
            if (this.numberingStyle.getSelectedIndex() == 2) {
                return;
            }
            this.toc.setNumberingStyle((short)this.numberingStyle.getSelectedIndex());
            NumberingFormatDialog numberingFormatDialog = new NumberingFormatDialog(this, this.toc);
            numberingFormatDialog.setVisible(true);
        } else if (source == this.backBtn) {
            this.setVisible(false);
            this.dispose();
            new TOCWizardStep1(this.reportMain, this.toc).setVisible(true);
        } else if (source == this.cancelBtn) {
            this.toc.setModified(false);
            this.setVisible(false);
            this.dispose();
        } else if (source == this.doneBtn) {
            this.toc.setShowNumbering(this.showNumbering.isSelected());
            if (this.showNumbering.isSelected()) {
                this.toc.setNumberingStyle((short)this.numberingStyle.getSelectedIndex());
            }
            if (this.indent.isSelected()) {
                this.toc.setIndent((short)this.indentSpace.getValue());
            } else {
                this.toc.setIndent(0);
            }
            this.toc.setShowPageNumber(this.showPageNumber.isSelected());
            if (this.showPageNumber.isSelected()) {
                this.toc.setShowSpacer(this.showSpacer.isSelected());
                if (this.showSpacer.isSelected()) {
                    this.toc.setSpacerStyle((short)this.spacerStyle.getSelectedIndex());
                }
            }
            if (this.leftToRight.isSelected()) {
                this.toc.setLayout((short)0);
            } else {
                this.toc.setLayout((short)1);
            }
            this.toc.setModified(true);
            this.setVisible(false);
            this.dispose();
        }
    }
}

