/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.report.ColData;

public class TransposeColumnDialog
extends QbDialog {
    JCheckBox[] checkbox;
    JButton okButton;
    JButton cancelButton;
    ColData[] colData;
    boolean[] transposeCol;
    JFrame frame;

    public TransposeColumnDialog(JFrame frame, ColData[] colData) {
        super(frame, LanguageEncoder.getText("Transpose Column Options"), true);
        this.frame = frame;
        this.colData = colData;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Select Transpose Column")));
        mainPanel.setLayout(new GridLayout(0, 3, 5, 5));
        this.checkbox = new JCheckBox[this.colData.length - 1];
        for (int i = 0; i < this.checkbox.length; ++i) {
            mainPanel.add(new JLabel(this.colData[i].getName().trim()));
            mainPanel.add(new JLabel(DataType.getTypeName(this.colData[i].getOriginalDataType())));
            this.checkbox[i] = new JCheckBox(LanguageEncoder.getText("Transpose"), false);
            mainPanel.add(this.checkbox[i]);
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JScrollPane pane = new JScrollPane();
        pane.getViewport().add(mainPanel);
        JPanel cop = (JPanel)this.getContentPane();
        cop.add("Center", pane);
        cop.add("South", buttonPanel);
        this.pack();
        this.setSize(new Dimension(450, 300));
    }

    boolean[] getTransposeColumn() {
        return this.transposeCol;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.transposeCol = new boolean[this.checkbox.length];
            int dataType = -5;
            for (int i = 0; i < this.checkbox.length; ++i) {
                this.transposeCol[i] = this.checkbox[i].isSelected();
                if (!this.transposeCol[i]) continue;
                if (dataType == -5) {
                    dataType = this.colData[i].getDataType();
                    continue;
                }
                if (dataType == this.colData[i].getDataType()) continue;
                this.transposeCol = null;
                new MessageDialog((Frame)this.frame, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("All transpose columns require same data type!"));
                return;
            }
            if (dataType == -5) {
                this.transposeCol = null;
                new MessageDialog((Frame)this.frame, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Please select the column that you want to transpose!"));
                return;
            }
        }
        this.dispose();
    }
}

