/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Array;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.internal.ClassFileUtil;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IDataInterchange;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ReportMapping;
import quadbase.reportdesigner.designer.ReportWizard;
import quadbase.reportdesigner.designer.WizardStep41;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.EJBAccess;
import quadbase.reportdesigner.report.ExcelAccess;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.SOAPAccess;
import quadbase.reportdesigner.report.SalesForceAccess;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IQueryInParam;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class UpdateDataSourceWizard
extends ReportWizard
implements IDataInterchange {
    private static final Logger LOGGER = Logger.getLogger(UpdateDataSourceWizard.class.getName());
    private static int CHECKALL = 0;
    private static int CHECKTYPEONLY = 1;
    private static int CHECKNAMEONLY = 2;

    public UpdateDataSourceWizard(ReportMain f) {
        super(f, LanguageEncoder.getText("Update Data Source Wizard"));
        this.modified = false;
        this.reportmain = f;
        this.setBackground(Color.lightGray);
        this.report = this.reportmain.report;
        this.reportType = this.report.reportType;
        this.registryID = this.report.registryID;
        this.subReports = this.report.subReports;
        this.dataSourceID = this.report.dataSourceID;
        this.dataSourceLoc = this.report.dataSourceLoc;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UpdateDataSourceWizard.this.cancel();
            }
        });
        this.pack();
        this.validate();
        this.setPos();
    }

    public void updateReport() {
        if (this.reportmain.isChangeDataRegistryEnabled()) {
            boolean showChangeButton = true;
            this.manager = new Manager(this, this, showChangeButton, this.reportmain.getChangeDataRegObj(), this.reportmain.canModify());
        } else {
            this.manager = new Manager(this, this, true, false, false, null);
        }
        if (this.manager.initialize(this.reportmain.getAbsoluteDataRegistryPath(), this.fromDesigner(), this.getDataRegistryHiddenNodes())) {
            this.setVisible(false);
            this.manager.setVisible(true);
            this.manager.toFront();
        } else {
            this.cancel();
        }
    }

    void displayResult() {
        this.step41 = new WizardStep41(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        if (this.stepMulti != null) {
            contentPane.remove(this.stepMulti);
        }
        contentPane.add("Center", this.step41);
        this.pack();
        this.validate();
        this.setPos();
        this.setVisible(true);
    }

    private boolean isRedoDataMapping() {
        if (this.report.colData.length != this.colData.length) {
            return true;
        }
        for (int i = 0; i < this.report.colData.length; ++i) {
            if (this.sameType(this.report.colData[i], this.colData[i])) continue;
            return true;
        }
        return false;
    }

    private ColInfo[] remapColInfo() {
        int i;
        if (this.colData.length < this.report.colData.length) {
            return this.removeColInfo();
        }
        int orgColumnCt = this.report.colInfo.length;
        int[] newMapping = this.getColDataMapping(this.report.colData, this.colData, CHECKALL);
        if (newMapping == null) {
            newMapping = this.getColDataMapping(this.report.colData, this.colData, CHECKTYPEONLY);
        }
        if (newMapping == null) {
            newMapping = this.getColDataMapping(this.report.colData, this.colData, CHECKNAMEONLY);
        }
        if (newMapping == null) {
            return null;
        }
        boolean isAggregatedColumn = this.isAggregatedColumn(this.report.colInfo);
        this.colInfo = this.report.colInfo;
        for (i = this.report.colData.length - 1; i < this.colData.length - 1; ++i) {
            ColInfo newColInfo = new ColInfo(newMapping[i]);
            newColInfo.setAggregation(isAggregatedColumn, (short)6);
            this.colInfo = Report.getNewColInfoSet(this.colInfo, newColInfo, this.colInfo.length);
        }
        for (i = 0; i < orgColumnCt; ++i) {
            int oldMap = this.report.colInfo[i].getMapping();
            if (oldMap < 0) continue;
            this.colInfo[i].setMapping(newMapping[oldMap]);
        }
        return this.colInfo;
    }

    private ColInfo[] removeColInfo() {
        int[] newMapping = this.getColDataMapping(this.colData, this.report.colData, CHECKALL);
        if (newMapping == null) {
            newMapping = this.getColDataMapping(this.colData, this.report.colData, CHECKTYPEONLY);
        }
        if (newMapping == null) {
            newMapping = this.getColDataMapping(this.colData, this.report.colData, CHECKNAMEONLY);
        }
        if (newMapping == null) {
            return null;
        }
        int unusedColDataIdx = this.colData.length - 1;
        Vector<ColInfo> colInfoList = new Vector<ColInfo>();
        for (ColInfo element : this.report.colInfo) {
            boolean isUnusedColumnSection = false;
            if (this.isUnusedColumn(element, newMapping, unusedColDataIdx)) {
                isUnusedColumnSection = true;
                if (!this.isRedoDataMapping(element)) continue;
                return null;
            }
            if (isUnusedColumnSection) {
                return null;
            }
            ColInfo newColInfo = (ColInfo)element.clone();
            newColInfo = this.setMapping(newColInfo, newMapping, unusedColDataIdx);
            colInfoList.addElement(newColInfo);
        }
        this.colInfo = new ColInfo[colInfoList.size()];
        for (int i = 0; i < colInfoList.size(); ++i) {
            this.colInfo[i] = (ColInfo)colInfoList.elementAt(i);
        }
        if (this.report.getReportType() != 2) {
            this.report.useIDForColumnHeader();
        }
        return this.colInfo;
    }

    private boolean isUnusedColumn(ColInfo colInfo, int[] mapping, int startIndex) {
        for (int i = startIndex; i < mapping.length; ++i) {
            if (colInfo.getMapping() != mapping[i]) continue;
            return true;
        }
        return false;
    }

    private boolean isRedoDataMapping(ColInfo colInfo) {
        return colInfo.isPrimaryKey() || colInfo.isColumnBreak() || colInfo.isColumnBreakValue() || colInfo.isRowBreak();
    }

    private ColInfo setMapping(ColInfo colInfo, int[] mapping, int mappingCt) {
        if (colInfo.getMapping() < 0) {
            return colInfo;
        }
        for (int i = 0; i < mappingCt; ++i) {
            if (mapping[i] != colInfo.getMapping()) continue;
            colInfo.setMapping(i);
            return colInfo;
        }
        return colInfo;
    }

    private int[] getColDataMapping(ColData[] orgData, ColData[] newData, int checkLevel) {
        int i;
        int newColIdx = orgData.length - 1;
        int[] newMapping = new int[newData.length - 1];
        for (i = 0; i < newMapping.length; ++i) {
            newMapping[i] = -1;
        }
        for (i = 0; i < newData.length - 1; ++i) {
            boolean matched = false;
            for (int j = 0; j < Math.min(orgData.length - 1, newData.length - 1); ++j) {
                if (newMapping[j] != -1 || !this.equals(newData[i], orgData[j], checkLevel)) continue;
                newMapping[j] = i;
                matched = true;
                break;
            }
            if (matched) continue;
            if (newColIdx >= newMapping.length) {
                return null;
            }
            newMapping[newColIdx] = i;
            ++newColIdx;
        }
        return newMapping;
    }

    private boolean sameType(ColData colData1, ColData colData2) {
        return DataType.isCompatibleSQLTypes(colData1.getOriginalDataType(), colData2.getOriginalDataType());
    }

    private boolean equals(ColData colData1, ColData colData2, int checkLevel) {
        if (checkLevel == CHECKALL || checkLevel == CHECKTYPEONLY) {
            if (!this.sameType(colData1, colData2)) {
                return false;
            }
            if (checkLevel == CHECKTYPEONLY) {
                return true;
            }
        }
        if (checkLevel == CHECKALL || checkLevel == CHECKNAMEONLY) {
            if (!colData1.getName().equalsIgnoreCase(colData2.getName())) {
                return false;
            }
            if (checkLevel == CHECKNAMEONLY) {
                return true;
            }
        }
        if (colData1.getTableName() == null || colData2.getTableName() == null) {
            return true;
        }
        return colData1.getTableName().equalsIgnoreCase(colData2.getTableName());
    }

    boolean redoDataMapping(JPanel prevPanel) {
        boolean redoMapping = this.isRedoDataMapping();
        this.colInfo = redoMapping ? this.remapColInfo() : this.report.colInfo;
        try {
            for (ColInfo element : this.colInfo) {
                ColData coldata = this.colData[element.getMapping()];
                element.setDBTableName(coldata.getTableName());
                element.setName(coldata.getName());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to set data mapping", ex);
        }
        if (this.colInfo != null) {
            try {
                int newColCt = this.colInfo.length - this.report.colInfo.length;
                double xpos = this.report.getReportTables().elementAt(0).getBodyMinWidth();
                Report newReport = this.report.setNewData(this.colData, this.colInfo, false, this.report.getReportType(), true, false, this.reportmain.isDesignMode);
                if (newColCt > 0) {
                    ReportColumn[] col = newReport.getReportTables().elementAt(0).getColumn();
                    for (int i = col.length - newColCt; i < col.length; ++i) {
                        col[i].setX(xpos);
                        xpos += col[i].getWidth();
                    }
                }
                this.applyFormula = false;
                this.applyTemplate = false;
                this.sideBySide = this.report.isSideBySideLayout();
                this.doneWizard(newReport);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to redo data mapping", ex);
            }
        } else {
            this.swapPanel(prevPanel, new ReportMapping((ReportWizard)this, prevPanel));
        }
        return redoMapping;
    }

    @Override
    void doneWizard(Report report) {
        this.doneWizard(report, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doneWizard(Report report, boolean autoFitColumns) {
        int k;
        DrillDownNode newNode = this.reportmain.report.currentNode;
        Vector<Boolean> temp = new Vector<Boolean>();
        for (int j = 0; j < Array.getLength(report.colInfo); ++j) {
            boolean b = report.colInfo[j].isVisible();
            temp.addElement(b);
        }
        boolean[] isVisible = new boolean[temp.size()];
        for (k = 0; k < temp.size(); ++k) {
            isVisible[k] = (Boolean)temp.elementAt(k);
        }
        if (this.applyTemplate) {
            report.copyReport(this.reportmain.report);
            report.setQueryParameters(null);
        }
        for (k = 0; k < Array.getLength(isVisible); ++k) {
            report.colInfo[k].setVisible(isVisible[k]);
        }
        if (report.subReportObject != null && report.subReportObject.getParameterMap() != null) {
            IQueryInParam[] oldParams = ReportUtil.getInParam(report.dbInfo);
            IQueryInParam[] newParams = ReportUtil.getInParam(this.dbInfo);
            String[] newParameterMap = new String[newParams.length];
            for (int i = 0; i < newParams.length; ++i) {
                for (int j = 0; j < oldParams.length; ++j) {
                    if (!newParams[i].getParamName().equals(oldParams[j].getParamName()) || report.subReportObject.getParameterMap().length <= j) continue;
                    newParameterMap[i] = report.subReportObject.getParameterMap()[j];
                }
            }
            report.subReportObject.setParameterMap(newParameterMap);
        }
        report.registryID = this.registryID;
        report.subReports = this.subReports;
        report.dataSourceID = this.dataSourceID;
        report.dataSourceLoc = this.dataSourceLoc;
        report.sourceData = this.sourceData;
        report.setOriginalSourceData(-1);
        report.originalColDataFromMemSource = null;
        if (this.sourceData == 7) {
            report.sourceFile = this.sourceFile;
            report.setXMLFileQueryInfo(this.xmlFileQueryInfo);
            report.dbInfo = this.dbInfo;
        } else if (this.sourceData == 1) {
            report.dbInfo = this.dbInfo;
            report.setDBSourceType(this.dbSourceType);
            report.setQueryFileBytes(this.dbFileBytes);
        } else if (this.sourceData == 3) {
            report.sourceList = new Object[this.sourceInfo.size()];
            report.sourceType = new int[this.sourceInfo.size()];
            report.doTranspose = new boolean[this.sourceInfo.size()];
            report.transposeColList = new Object[this.sourceInfo.size()];
            for (int i = 0; i < this.sourceInfo.size(); ++i) {
                report.sourceList[i] = this.sourceInfo.elementAt(i);
                report.sourceType[i] = (Integer)this.sourceType.elementAt(i);
                report.doTranspose[i] = (Boolean)this.doTranspose.elementAt(i);
                report.transposeColList[i] = this.transposeColList.elementAt(i);
            }
        } else if (this.sourceData == 12) {
            report.soapInfo = this.soapInfo;
            report.dbInfo = this.dbInfo;
        } else if (this.sourceData == 11) {
            report.sfQueryInfo = this.sfQueryInfo;
            report.dbInfo = this.dbInfo;
        } else if (this.sourceData == 13) {
            report.excelInfo = this.excelInfo;
        } else if (this.sourceData == 5) {
            report.jndiName = this.jndiName;
            report.homeName = this.homeName;
            report.remoteName = this.remoteName;
            report.selectedMethodName = this.selectedMethodName;
            report.selectedMethodParamVal = this.selectedMethodParamVal;
            report.environment = this.environment;
        } else {
            report.sourceFile = this.sourceFile;
            report.dbInfo = this.dbInfo;
        }
        if (report.getReportType() == 4) {
            for (int i = 0; i < report.getReportTables().size(); ++i) {
                ReportTable tbl = report.getReportTables().elementAt(i);
                tbl.getHeader().setVisible(false);
                tbl.getFooter().setVisible(false);
            }
        }
        if (report.getReportType() != 2) {
            ReportColumn[] column = report.getReportTables().elementAt(0).getColumn();
            for (int i = 0; i < Array.getLength(report.colInfo); ++i) {
                column[i].setVisible(report.colInfo[i].isVisible());
            }
        }
        Cursor currentCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            report.setSnapToGrid(report.snapToGrid, report.gridStepSize, report.cmGridStepSize);
            report.parentNode = this.reportmain.report.parentNode;
            this.reportmain.setReport(report, false);
            if (newNode == null) {
                newNode = new DrillDownNode("ROOT");
                newNode.setDomainPath(this.reportmain.relativeDomainPath);
                this.reportmain.report.currentNode = newNode;
                this.reportmain.setDrillDownTree(new JTree(newNode));
                this.reportmain.setSubReports(new Vector<SubReportObject>());
            }
            this.reportmain.report.currentNode = newNode;
            for (int i = 0; i < this.reportmain.report.subReports.size(); ++i) {
                SubReportObject sro = this.reportmain.report.subReports.elementAt(i);
                sro.setDomainPath(this.reportmain.relativeDomainPath);
            }
            newNode.setSelected(true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to set subreport/drilldown nodes", ex);
        }
        finally {
            this.setCursor(currentCursor);
        }
        this.reportmain.menuBar.setUndoEnabled(false);
        this.reportmain.setModified();
        this.reportmain.do_enable();
        this.reportmain.toFront();
        this.reportmain.designPanel.rulerPanel.yRuler.updateYRuler();
        this.reportmain.designPanel.rulerPanel.xRuler.updateXRuler();
        if (this.manager != null) {
            this.manager.dispose();
        }
        this.setVisible(false);
        this.dispose();
        if (autoFitColumns) {
            this.reportmain.autoFitColumns();
        }
    }

    @Override
    public void next() {
        this.sourceData = this.manager.getSourceData();
        this.registryID = this.manager.getRegistryID();
        this.dataSourceLoc = this.manager.managerPane.dataSourceLoc;
        DefaultMutableTreeNode node = this.manager.getSelectedNode();
        if (node instanceof DefaultDataSourceNode) {
            this.dataSourceID = node instanceof DataViewNode ? this.manager.getLastID() : ((DefaultDataSourceNode)node).getID();
        }
        ColData[] colData2 = null;
        String tmp = this.manager.getTitle();
        this.manager.toFront();
        this.manager.setTitle(Manager.WAIT_TITLE);
        this.manager.setCursor(Cursor.getPredefinedCursor(3));
        if (this.sourceData == 2 || this.sourceData == 4 || this.sourceData == 6 || this.sourceData == 7) {
            String loc = this.manager.getFileName();
            if (this.sourceData == 6 && ClassFileUtil.isParameterized(loc)) {
                try {
                    QueryClassFileInfo classInfo = new QueryClassFileInfo(loc);
                    Vector<QueryInParamSet> paramV = null;
                    QueryFileInfo.setParentDialog(this.manager);
                    paramV = QueryFileInfo.getParameter(classInfo, true);
                    if (paramV == null) {
                        throw new Exception("CANCELED");
                    }
                    colData2 = new DataFileInput().readProcessedData(loc, false, null, null, null, 0, this.reportType == 2 ? -1 : this.reportmain.getDisplayRow(), paramV.elementAt(0));
                    this.colData = colData2;
                    this.dbInfo = classInfo;
                }
                catch (Exception ex) {
                    if (!"CANCELED".equals(ex.getMessage())) {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "An error occured with the parameterized class file data source.\n" + ex.getMessage());
                    }
                    this.manager.setCursor(Cursor.getDefaultCursor());
                    this.manager.setTitle(tmp);
                    this.manager.toFront();
                    return;
                }
            }
            if (this.sourceData == 7) {
                XMLFileQueryInfo xmlInfo = this.manager.getXMLFileQueryInfo();
                if (QueryParser.hasParameters(xmlInfo.getCondition())) {
                    QueryXMLFileInfo xmlFileInfo = new QueryXMLFileInfo(xmlInfo);
                    this.dbInfo = xmlFileInfo;
                }
                try {
                    colData2 = new DataFileInput().readProcessedData(loc, false, null, null, null, 0, -1, xmlInfo, this.sourceData);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to read data", ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
                    this.manager.setCursor(Cursor.getDefaultCursor());
                    this.manager.setTitle(tmp);
                    this.manager.toFront();
                    return;
                }
                this.colData = colData2;
                this.xmlFileQueryInfo = xmlInfo;
            } else {
                try {
                    colData2 = new DataFileInput().readProcessedData(loc, false, null, null, null, 0, -1, null, this.sourceData);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to read data", ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
                    this.manager.setCursor(Cursor.getDefaultCursor());
                    this.manager.setTitle(tmp);
                    this.manager.toFront();
                    return;
                }
                this.colData = colData2;
                this.dbInfo = null;
            }
            this.sourceFile = loc;
        } else if (this.sourceData == 12) {
            this.soapInfo = this.manager.getSOAPQueryFileInfo();
            if (this.soapInfo.isParameterized()) {
                this.dbInfo = this.soapInfo;
            }
            String err_msg = "";
            try {
                if (!this.soapInfo.isParameterized()) {
                    this.sqlParams = null;
                } else {
                    QueryInParam[] paramarray;
                    if (this.colDataList.size() > 0) {
                        err_msg = LanguageEncoder.getText("Parameterized query cannot be used with multiple datasources.");
                        throw new Exception();
                    }
                    for (QueryInParam element : paramarray = this.soapInfo.getInSet().getParameter()) {
                        element.setValue(null);
                    }
                    SOAPQueryFileInfo.setParentDialog(this.manager);
                    this.sqlParams = SOAPQueryFileInfo.getParameter(this.soapInfo, true);
                    if (this.sqlParams == null) {
                        throw new Exception("CANCELED");
                    }
                }
            }
            catch (Exception ex) {
                this.sqlParams = null;
                if (ex.getMessage().equals("CANCELED")) {
                    LOGGER.log(Level.FINEST, "Get parameter values: canceled", ex);
                    err_msg = ex.getMessage();
                }
                LOGGER.log(Level.FINE, "Failed to get parameter values", ex);
            }
            try {
                if (!err_msg.equals("")) {
                    throw new Exception();
                }
                colData2 = SOAPAccess.retrieveResult(this.soapInfo);
            }
            catch (Exception ex) {
                if (err_msg.equals("")) {
                    err_msg = LanguageEncoder.getText("Failed to retrieve result from SOAP service.") + "\n" + ex.toString();
                }
                if (!err_msg.equals("CANCELED")) {
                    LOGGER.log(Level.FINE, "Failed to perform action: " + err_msg, ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), err_msg);
                } else {
                    LOGGER.log(Level.FINEST, "Canceled", ex);
                }
                this.manager.setCursor(Cursor.getDefaultCursor());
                this.manager.setTitle(tmp);
                this.manager.toFront();
                return;
            }
            this.colData = colData2;
        } else if (this.sourceData == 13) {
            this.excelInfo = this.manager.getExcelFileInfo();
            try {
                colData2 = ExcelAccess.getColData(this.excelInfo);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Cannot load excel data", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
                this.manager.setCursor(Cursor.getDefaultCursor());
                this.manager.setTitle(tmp);
                this.manager.toFront();
                return;
            }
            this.colData = colData2;
        } else if (this.sourceData == 5) {
            this.jndiName = this.manager.getJNDIName();
            this.homeName = this.manager.getHomeName();
            this.remoteName = this.manager.getRemoteName();
            this.selectedMethodName = this.manager.getMethodName();
            this.selectedMethodParamVal = this.manager.getParam();
            this.environment = this.manager.getEnvironment();
            try {
                colData2 = EJBAccess.retrieveResult(this.jndiName, this.homeName, this.remoteName, this.selectedMethodName, this.selectedMethodParamVal, this.environment);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to load data from EJB", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
                this.manager.setCursor(Cursor.getDefaultCursor());
                this.manager.setTitle(tmp);
                this.manager.toFront();
                return;
            }
            this.colData = colData2;
        } else if (this.sourceData == 11) {
            this.sfQueryInfo = this.manager.getSalesForceQueryInfo();
            if (this.sfQueryInfo.isParameterized()) {
                this.dbInfo = this.sfQueryInfo;
            }
            String err_msg = "";
            try {
                if (!this.sfQueryInfo.isParameterized()) {
                    this.sqlParams = null;
                } else {
                    QueryInParam[] paramarray;
                    if (this.colDataList.size() > 0) {
                        err_msg = LanguageEncoder.getText("Parameterized query cannot be used with multiple datasources.");
                        throw new Exception();
                    }
                    for (QueryInParam element : paramarray = this.manager.getInSet().getParameter()) {
                        element.setValue(null);
                    }
                    SalesForceQueryFileInfo.setParentDialog(this.manager);
                    this.sfQueryInfo.setInSet(new QueryInParamSet(this.manager.getInSet().getParameter(), this.manager.getInSet().getParameterInPromptSequence()));
                    this.sqlParams = SalesForceQueryFileInfo.getParameter(this.sfQueryInfo, true);
                    if (this.sqlParams == null) {
                        throw new Exception("CANCELED");
                    }
                }
            }
            catch (Exception ex) {
                this.sqlParams = null;
                if (ex.getMessage().equals("CANCELED")) {
                    LOGGER.log(Level.FINEST, "Get parameter values: canceled", ex);
                    err_msg = ex.getMessage();
                }
                LOGGER.log(Level.FINE, "Failed to get parameter values", ex);
            }
            try {
                if (!err_msg.equals("")) {
                    throw new Exception();
                }
                colData2 = this.reportType == 2 ? SalesForceAccess.getColData(this.sfQueryInfo) : SalesForceAccess.getColData(this.sfQueryInfo, 0, 20);
            }
            catch (Exception ex) {
                if (err_msg.equals("")) {
                    err_msg = LanguageEncoder.getText("Failed to retrieve result from SalesForce.\n") + ex.toString();
                }
                if (!err_msg.equals("CANCELED")) {
                    LOGGER.log(Level.FINE, "Failed to perform action: " + err_msg, ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), err_msg);
                } else {
                    LOGGER.log(Level.FINEST, "Canceled", ex);
                }
                this.manager.setCursor(Cursor.getDefaultCursor());
                this.manager.setTitle(tmp);
                this.manager.toFront();
                return;
            }
            this.colData = colData2;
        } else if (this.sourceData == 1) {
            this.dbSourceType = this.manager.getDBSourceType();
            this.dbFileBytes = this.manager.getFileBytes();
            String query = this.manager.getSQL();
            this.dbInfo = this.manager.isUseJNDIDataSource() ? new DBInfoBasic(this.manager.getJNDIDBName(), query, this.manager.getEnvProperties()) : new DBInfoBasic(this.manager.getURL(), this.manager.getDriver(), this.manager.getUserName(), this.manager.getPassword(), query, this.manager.getAdditionalDb());
            String err_msg = "";
            try {
                if (!QueryParser.hasParameters(query)) {
                    this.sqlParams = null;
                } else {
                    QueryInParam[] paramarray;
                    if (this.colDataList.size() > 0) {
                        err_msg = LanguageEncoder.getText("Parameterized query cannot be used with multiple datasources.");
                        throw new Exception();
                    }
                    for (QueryInParam element : paramarray = this.manager.getInSet().getParameter()) {
                        element.setValue(null);
                    }
                    QueryFileInfo qfInfo = new QueryFileInfo("", 0, this.dbInfo, new QueryInParamSet(this.manager.getInSet().getParameter(), this.manager.getInSet().getParameterInPromptSequence()));
                    QueryFileInfo.setParentDialog(this.manager);
                    this.sqlParams = QueryFileInfo.getParameter(qfInfo, true);
                    if (this.sqlParams == null) {
                        throw new Exception("CANCELED");
                    }
                    this.dbInfo = qfInfo;
                }
            }
            catch (Exception ex) {
                this.sqlParams = null;
                if (ex.getMessage().equals("CANCELED")) {
                    LOGGER.log(Level.FINEST, "Get parameter values: canceled", ex);
                    err_msg = ex.getMessage();
                }
                LOGGER.log(Level.FINE, "Failed to get parameter values", ex);
            }
            try {
                if (!err_msg.equals("")) {
                    throw new Exception();
                }
                colData2 = this.reportType == 2 ? DBAccess.retrieveResult(this.sqlParams, this.dbInfo, true, false, null, null, null, false) : DBAccess.retrieveResult(this.sqlParams, this.dbInfo, true, false, null, null, null, 0, this.reportmain.getDisplayRow(), false);
            }
            catch (Exception ex) {
                if (err_msg.equals("")) {
                    err_msg = LanguageEncoder.getText("Failed to retrieve result set from database.\n") + ex.toString();
                }
                if (!err_msg.equals("CANCELED")) {
                    LOGGER.log(Level.FINE, "Failed to perform action: " + err_msg, ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), err_msg);
                } else {
                    LOGGER.log(Level.FINEST, "Canceled", ex);
                }
                this.manager.setCursor(Cursor.getDefaultCursor());
                this.manager.setTitle(tmp);
                this.manager.toFront();
                return;
            }
            this.colData = colData2;
        }
        this.manager.setCursor(Cursor.getDefaultCursor());
        this.manager.setTitle(tmp);
        this.manager.setVisible(false);
        this.displayResult();
    }

    private boolean isAggregatedColumn(ColInfo[] cInfo) {
        for (ColInfo element : cInfo) {
            if (!element.isAggregatedColumn()) continue;
            return true;
        }
        return false;
    }
}

