/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Dialog;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.LoadChart;
import quadbase.chart.SaveChart;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.INParametersDialog;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.SimpleDbJndiDialog;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.UpdateDataSourceWizard;
import quadbase.reportdesigner.designer.WizardStep41;
import quadbase.reportdesigner.report.ChartObject;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.SaveReport;

public class UpdateDatabaseWizard
extends UpdateDataSourceWizard {
    private static final Logger LOGGER = Logger.getLogger(UpdateDatabaseWizard.class.getName());
    public static ReportMain reportMain;

    public UpdateDatabaseWizard(ReportMain f) {
        super(f);
        reportMain = f;
        this.setTitle(LanguageEncoder.getText("Modify Database Infomation"));
    }

    private static void doUpdateReport(Report report, String filename, DBInfoBasic tdbInfo, DBInfoBasic oInfo, boolean rootLevel, Boolean isDrillDown) {
        try {
            boolean hasDrillDown = false;
            boolean hasSubReport = false;
            if (report.currentNode != null && report.currentNode.getChildCount() > 0) {
                hasDrillDown = true;
            }
            LOGGER.finest("hasDrillDown=" + hasDrillDown);
            if (report.subReports != null && report.subReports.size() > 0) {
                hasSubReport = true;
            }
            if (oInfo.equals(report.dbInfo, false)) {
                DBInfoBasic dbInfo = report.dbInfo;
                dbInfo.setURLString(tdbInfo.getURLString());
                dbInfo.setDriverName(tdbInfo.getDriverName());
                dbInfo.setUserID(tdbInfo.getUserID());
                dbInfo.setPassword(tdbInfo.getPassword());
                dbInfo.setJNDIName(tdbInfo.getJNDIName());
                dbInfo.setEnvProperties(tdbInfo.getEnvProperties());
                dbInfo.setUseJNDIDataSource(tdbInfo.getJNDIName() != null);
                report.dbInfo = dbInfo;
                report.setOriginalSourceData(-1);
                report.sourceData = 1;
                report.originalColDataFromMemSource = null;
            }
            if (filename != null && (!rootLevel || hasDrillDown || hasSubReport)) {
                SaveReport saveReport = new SaveReport(report);
                saveReport.setSubReports(report.subReports);
                if (isDrillDown != null && !isDrillDown.booleanValue() || isDrillDown == null && report.currentNode != null) {
                    saveReport.setDrillDownNode(report.currentNode);
                }
                saveReport.setSubFilesTable(report.getSubFilesTable());
                saveReport.saveToOutput(filename, !SaveReport.isPAKFile(filename), SaveReport.isPAKFile(filename));
            }
            if (hasDrillDown) {
                UpdateDatabaseWizard.updateDrillDown(report, report.currentNode, tdbInfo, oInfo);
            }
            if (hasSubReport) {
                UpdateDatabaseWizard.updateSubReport(report, tdbInfo, oInfo);
            }
            UpdateDatabaseWizard.addCharts(report, tdbInfo, oInfo);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to update report", ex);
        }
    }

    private static void doUpdateCharts(Vector charts, DBInfoBasic tdbInfo, DBInfoBasic oInfo) {
        for (int i = 0; charts != null && i < charts.size(); ++i) {
            ReportChartObject rco = (ReportChartObject)charts.elementAt(i);
            if (rco.isReportDataUsed()) continue;
            String templatename = rco.getText();
            try {
                Vector preSetParams = ChartObject.getPresetParams(null, null, rco);
                LoadChart lc = new LoadChart();
                lc.setSubFilesTable(reportMain.getSubFilesTable());
                lc.setUsingBackupData(true);
                Chart loadedChart = lc.loadChartFromFile(IOUtil.getOffScreenComponent(), templatename, preSetParams, true);
                if (loadedChart.sourceData != 1 && loadedChart.getOriginalSourceData() != 1) continue;
                Chart chart = null;
                boolean hasDrillDown = false;
                boolean isDrillDown = false;
                if (loadedChart.currentNode != null && loadedChart.currentNode.getChildCount() > 0) {
                    hasDrillDown = true;
                }
                if (lc.getDrillDownNode() == null) {
                    isDrillDown = true;
                }
                chart = loadedChart;
                if (oInfo.equals(chart.dbInfo, false)) {
                    chart.dbInfo.setURLString(tdbInfo.getURLString());
                    chart.dbInfo.setDriverName(tdbInfo.getDriverName());
                    chart.dbInfo.setUserID(tdbInfo.getUserID());
                    chart.dbInfo.setPassword(tdbInfo.getPassword());
                    chart.dbInfo.setJNDIName(tdbInfo.getJNDIName());
                    chart.dbInfo.setEnvProperties(tdbInfo.getEnvProperties());
                    chart.dbInfo.setUseJNDIDataSource(tdbInfo.getJNDIName() != null);
                    chart.setOriginalSourceData(-1);
                    chart.sourceData = 1;
                    chart.originalColDataFromMemSource = null;
                    chart.setDBSourceType(loadedChart.getDBSourceType());
                }
                SaveChart saveChart = new SaveChart(chart);
                saveChart.pack = SaveChart.isPacFile(templatename);
                if (!isDrillDown) {
                    saveChart.setDrillDownNode(chart.currentNode);
                }
                saveChart.saveToFile(templatename.substring(0, templatename.length() - 4), false, reportMain.isReportOpenedInPakFormat());
                if (!hasDrillDown) continue;
                UpdateDatabaseWizard.updateDrillDown(chart.currentNode, tdbInfo, oInfo);
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to udpate chart", ex);
            }
        }
    }

    private static Object[] getDBReport(String filename) {
        return UpdateDatabaseWizard.getDBReport(filename, null);
    }

    private static Object[] getDBReport(String filename, String domainPath) {
        try {
            LoadReport loadReport = new LoadReport(true);
            loadReport.setBackupDataUsed(true);
            if (reportMain != null && UpdateDatabaseWizard.reportMain.report != null) {
                loadReport.setSubFilesTable(UpdateDatabaseWizard.reportMain.report.getSubFilesTable());
            }
            if (domainPath != null) {
                loadReport.setRelativeDomainPath(domainPath);
            }
            Report rpt = loadReport.loadReportFromFile(filename, null, null, true, false);
            if (rpt.sourceData != 1 && rpt.getOriginalSourceData() != 1) {
                return null;
            }
            rpt.sourceData = 1;
            rpt.setOriginalSourceData(-1);
            boolean isDrillDown = loadReport.getDrillDownNode() == null;
            Object[] obj = new Object[]{rpt, isDrillDown};
            return obj;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot get report", ex);
            return null;
        }
    }

    private static void updateDrillDown(Report parentReport, DrillDownNode parent, DBInfoBasic tdbInfo, DBInfoBasic oInfo) {
        int ct = parent.getChildCount();
        for (int i = 0; i < ct; ++i) {
            parent.getChildAt(i).setDomainPath(UpdateDatabaseWizard.reportMain.relativeDomainPath);
            String filename = parent.getChildAt(i).getFileName();
            Object[] report = UpdateDatabaseWizard.getDBReport(filename, parentReport.domainPath);
            if (report == null) continue;
            ((Report)report[0]).currentNode = parent.getChildAt(i);
            ((Report)report[0]).domainPath = UpdateDatabaseWizard.reportMain.relativeDomainPath;
            UpdateDatabaseWizard.doUpdateReport((Report)report[0], filename, tdbInfo, oInfo, false, (Boolean)report[1]);
        }
    }

    private static void updateSubReport(Report parent, DBInfoBasic tdbInfo, DBInfoBasic oInfo) {
        for (int i = 0; i < parent.subReports.size(); ++i) {
            parent.subReports.elementAt(i).setDomainPath(UpdateDatabaseWizard.reportMain.relativeDomainPath);
            String filename = parent.subReports.elementAt(i).getFileName();
            Object[] report = UpdateDatabaseWizard.getDBReport(filename, parent.domainPath);
            if (report == null) continue;
            ((Report)report[0]).domainPath = UpdateDatabaseWizard.reportMain.relativeDomainPath;
            UpdateDatabaseWizard.doUpdateReport((Report)report[0], filename, tdbInfo, oInfo, false, (Boolean)report[1]);
        }
    }

    private static void updateDrillDown(quadbase.chart.DrillDownNode parent, DBInfoBasic tdbInfo, DBInfoBasic oInfo) {
        int ct = parent.getChildCount();
        for (int i = 0; i < ct; ++i) {
            String filename = parent.getChildAt(i).getFileName();
            Object[] report = UpdateDatabaseWizard.getDBReport(filename);
            if (report == null) continue;
            UpdateDatabaseWizard.doUpdateReport((Report)report[0], filename, tdbInfo, oInfo, false, (Boolean)report[1]);
        }
    }

    private static void addCharts(Report parent, DBInfoBasic tdbInfo, DBInfoBasic oInfo) {
        UpdateDatabaseWizard.doUpdateCharts(parent.getAllCharts(), tdbInfo, oInfo);
    }

    @Override
    public void updateReport() {
        this.updateReport(false);
    }

    public void updateReport(boolean promptRetrieveData) {
        if (this.report.sourceData != 1 && this.report.getOriginalSourceData() != 1) {
            return;
        }
        this.sourceData = this.reportmain.report.sourceData;
        this.registryID = this.reportmain.report.registryID;
        this.subReports = this.reportmain.report.subReports;
        this.dataSourceID = this.reportmain.report.dataSourceID;
        this.dataSourceLoc = this.reportmain.report.dataSourceLoc;
        int sourceType = this.report.getDBSourceType();
        if (sourceType == Manager.QUERY) {
            this.dbSourceType = Manager.QUERY;
        } else if (sourceType == Manager.DATAVIEW) {
            this.dbSourceType = Manager.DATAVIEW;
        }
        this.dbFileBytes = this.report.getQueryFileBytes();
        DBInfoBasic tInfo = this.doDatabaseInfo();
        DBInfoBasic oInfo = (DBInfoBasic)this.report.dbInfo.clone();
        boolean rootLevel = this.report.currentNode.equals((DrillDownNode)this.reportmain.getDrillDownTree().getModel().getRoot());
        String fileName = "";
        fileName = SaveReport.isRPTFile(this.reportmain.getFileName()) && rootLevel ? this.reportmain.getFileName() : this.report.currentNode.getFileName();
        if (promptRetrieveData && tInfo != null) {
            JMessageDialog msgDialog = new JMessageDialog((Dialog)this, "Verification", LanguageEncoder.getText("Do you want to verify data?"), 1);
            int response = msgDialog.getResponse();
            if (response == 5) {
                UpdateDatabaseWizard.doUpdateReport(this.report, fileName, tInfo, oInfo, rootLevel, !rootLevel);
                return;
            }
            if (response == 7) {
                LOGGER.finest("Cancel");
                return;
            }
        }
        if (tInfo != null) {
            UpdateDatabaseWizard.doUpdateReport(this.report, fileName, tInfo, oInfo, rootLevel, !rootLevel);
            this.validateQuery(tInfo);
        }
        this.prepareResultSet();
    }

    private DBInfoBasic doDatabaseInfo() {
        SimpleDbJndiDialog dbJndiDialog = new SimpleDbJndiDialog(this.reportmain, this.report.dbInfo, this.reportmain.getChangeDataRegObj(), this.reportmain.getChangeDataRegPlusObj());
        dbJndiDialog.setBrowseDirectories(this.reportmain.getBrowseDirectories());
        dbJndiDialog.setVisible(true);
        if (dbJndiDialog.isModified()) {
            if (!dbJndiDialog.getDBInfo().isUseJNDIDataSource()) {
                reportMain.setModified(true);
            }
            return dbJndiDialog.getDBInfo();
        }
        return null;
    }

    private void validateQuery(DBInfoBasic tempdbInfo) {
        block7: {
            String query = this.report.dbInfo.getQuery();
            tempdbInfo.setQuery(query);
            if (QueryParser.hasParameters(query)) {
                QueryInParamSet paramSet = ((QueryFileInfo)this.report.dbInfo).getInSet();
                boolean initializationRequired = QueryParser.initializationRequired(paramSet = QueryParser.filterParameters(query, paramSet));
                if (initializationRequired) {
                    try {
                        QueryFileInfo tempqInfo = new QueryFileInfo("", 0, tempdbInfo, paramSet);
                        INParametersDialog pDialog = new INParametersDialog(this.manager, tempqInfo, 0);
                        pDialog.setVisible(true);
                        if (!pDialog.isModified()) break block7;
                        QueryFileInfo qinfo = pDialog.getQueryFileInfo();
                        if (qinfo != null) {
                            this.dbInfo = qinfo;
                            this.dbInfo.setUseJNDIDataSource(tempdbInfo.getJNDIName() != null);
                            break block7;
                        }
                        throw new Exception(LanguageEncoder.getText("This query contains irrecoverable errors."));
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINE, "Failed to initialize parameters for parameterized query", ex);
                        new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to initialize parameters for parameterized query."));
                    }
                } else {
                    this.dbInfo = new QueryFileInfo("", 0, tempdbInfo, paramSet);
                    this.dbInfo.setUseJNDIDataSource(tempdbInfo.getJNDIName() != null);
                }
            } else {
                this.dbInfo = tempdbInfo;
                this.dbInfo.setUseJNDIDataSource(tempdbInfo.getJNDIName() != null);
            }
        }
    }

    private void prepareResultSet() {
        if (this.dbInfo == null) {
            return;
        }
        this.sourceData = 1;
        ColData[] colData2 = null;
        try {
            if (this.dbInfo instanceof QueryFileInfo) {
                QueryInParam[] paramarray;
                for (QueryInParam element : paramarray = ((QueryFileInfo)this.dbInfo).getInSet().getParameter()) {
                    element.setValue(null);
                }
                QueryFileInfo.setParentDialog(this.manager);
                this.sqlParams = QueryFileInfo.getParameter((QueryFileInfo)this.dbInfo, true);
                if (this.sqlParams == null) {
                    return;
                }
            } else {
                this.sqlParams = null;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot get parameters", ex);
            this.sqlParams = null;
        }
        try {
            colData2 = this.reportType == 2 ? DBAccess.retrieveResult(this.sqlParams, this.dbInfo, true, false, null, null, null, false) : DBAccess.retrieveResult(this.sqlParams, this.dbInfo, true, false, null, null, null, 0, this.reportmain.getDisplayRow(), false);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to retrieve result set from database", ex);
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to retrieve result set from database.\n") + ex.toString());
            return;
        }
        this.colData = colData2;
        this.displayResult();
    }

    @Override
    void displayResult() {
        this.step41 = new WizardStep41(this, false);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", this.step41);
        this.pack();
        this.validate();
        this.setPos();
        this.setVisible(true);
    }

    @Override
    public void back() {
    }

    @Override
    public void next() {
    }

    @Override
    public void setPresetDataRegistry(String data) {
    }

    @Override
    public String getPresetDataRegistry() {
        return null;
    }

    public void setDataRegistryHiddenNodes(Vector data) {
    }

    public Vector getPresetDataRegistryHiddenNodes() {
        return null;
    }
}

