/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Dialog;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.client.FileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.util.dtd.elements.DTD;
import quadbase.common.util.internal.CopyFile;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DTDUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.datasourcemanager.manager.DTDTreeBuilderDialog;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.EnterSQLDialog;
import quadbase.datasourcemanager.manager.INParametersDialog;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.ReadXMLTable;
import quadbase.datasourcemanager.manager.WriteXMLDataSources;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLQueryNode;
import quadbase.datasourcemanager.manager.xmlbuilder.XMLQueryBuilderDialog;
import quadbase.datasourcemanager.manager.xmlschema.XMLSchemaTreeBuilderDialog;
import quadbase.querybuilder.designer.ConditionDialog;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.designer.SaveBackToRegistryDialog;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.UpdateDataSourceWizard;
import quadbase.reportdesigner.designer.WizardStep41;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.Parameter;

public class UpdateQueryWizard
extends UpdateDataSourceWizard {
    private static final Logger LOGGER = Logger.getLogger(UpdateQueryWizard.class.getName());
    private QueryMain queryMain = null;
    private ConditionDialog cDialog = null;
    private final String DATAVIEWFILEEXT = ".dvw";
    private final String QUERYFILEEXT = ".qry";

    public UpdateQueryWizard(ReportMain f) {
        super(f);
        this.setTitle(LanguageEncoder.getText("Modify Query"));
    }

    @Override
    public void updateReport() {
        if (this.report.sourceData == 1 || this.report.getOriginalSourceData() == 1) {
            this.sourceData = this.reportmain.report.sourceData;
            this.registryID = this.reportmain.report.registryID;
            this.subReports = this.reportmain.report.subReports;
            this.dataSourceID = this.reportmain.report.dataSourceID;
            this.dataSourceLoc = this.reportmain.report.dataSourceLoc;
            boolean failed = true;
            int sourceType = this.report.getDBSourceType();
            byte[][] fileBytes = this.report.getQueryFileBytes();
            if (sourceType == Manager.QUERY && fileBytes != null && fileBytes.length == 1) {
                this.dbSourceType = Manager.QUERY;
                this.dbFileBytes = new byte[1][];
                this.dbFileBytes[0] = fileBytes[0];
                failed = !this.doQueryBuilder();
            } else if (sourceType == Manager.DATAVIEW && fileBytes != null && fileBytes.length == 2) {
                this.dbSourceType = Manager.DATAVIEW;
                this.dbFileBytes = new byte[2][];
                this.dbFileBytes[0] = fileBytes[0];
                this.dbFileBytes[1] = fileBytes[1];
                try {
                    this.doDataView();
                    failed = false;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to process data view", ex);
                }
            }
            if (failed) {
                this.dbSourceType = -1;
                this.dbFileBytes = null;
                this.doSQLStatement();
            }
        } else if (this.report.sourceData == 7 || this.report.getOriginalSourceData() == 7) {
            this.sourceData = this.reportmain.report.sourceData;
            this.registryID = this.reportmain.report.registryID;
            this.subReports = this.reportmain.report.subReports;
            this.dataSourceID = this.reportmain.report.dataSourceID;
            this.dataSourceLoc = this.reportmain.report.dataSourceLoc;
            this.doXMLFileQuery();
        }
    }

    @Override
    void displayResult() {
        this.step41 = new WizardStep41(this, false);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", this.step41);
        this.pack();
        this.validate();
        this.setPos();
        this.setVisible(true);
    }

    private void doSQLStatement() {
        this.queryMain = new QueryMain(this, this);
        this.queryMain.setBrowseDirectories(this.getBrowseDirectories());
        this.queryMain.setDefaultParamNames(this.reportmain.getDefaultParamNames());
        this.queryMain.setDefaultValueRequiredForParameters(this.reportmain.isDefaultValueRequiredForParameters());
        if (this.report.dbInfo instanceof QueryFileInfo) {
            this.queryMain.setInSet(((QueryFileInfo)this.report.dbInfo).getInSet());
            this.queryMain.setReportParameters(this.report.getQueryParameters());
            if (this.report.subReportObject != null) {
                this.queryMain.setParameterMap(this.report.subReportObject.getParameterMap());
            }
        }
        QueryInParamSet paramSet = null;
        if (QueryParser.hasParameters(this.report.dbInfo.getQuery()) && this.report.dbInfo instanceof QueryFileInfo) {
            paramSet = ((QueryFileInfo)this.report.dbInfo).getInSet();
        }
        EnterSQLDialog sqlDialog = new EnterSQLDialog(this.reportmain, this.queryMain, this.report.dbInfo, this.report.dbInfo.getQuery(), paramSet);
        sqlDialog.setVisible(true);
        if (!sqlDialog.isModified()) {
            this.dbInfo = null;
        } else {
            block18: {
                String query = sqlDialog.getSQLStatement();
                if (QueryParser.hasParameters(query)) {
                    boolean initializationRequired;
                    if (sqlDialog.getInSet() != null) {
                        paramSet = sqlDialog.getInSet();
                    }
                    if (initializationRequired = QueryParser.initializationRequired(paramSet = QueryParser.filterParameters(query, paramSet))) {
                        try {
                            DBInfoBasic newDBInfo = null;
                            newDBInfo = this.report.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.report.dbInfo.getJNDIName(), query, this.report.dbInfo.getEnvProperties()) : new DBInfoBasic(this.report.dbInfo.getURLString(), this.report.dbInfo.getDriverName(), this.report.dbInfo.getUserID(), this.report.dbInfo.getPassword(), query, this.report.dbInfo.getAdditionalDb());
                            QueryFileInfo tempqInfo = new QueryFileInfo("", 0, newDBInfo, paramSet);
                            INParametersDialog pDialog = new INParametersDialog(this.manager, tempqInfo, this.queryMain.getTableNameFormat());
                            pDialog.setVisible(true);
                            if (!pDialog.isModified()) break block18;
                            QueryFileInfo qinfo = pDialog.getQueryFileInfo();
                            if (qinfo != null) {
                                this.dbInfo = qinfo;
                                break block18;
                            }
                            throw new Exception(LanguageEncoder.getText("This query contains irrecoverable errors."));
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINE, "Failed to initialize parameters for parameterized query", ex);
                            new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to initialize parameters for parameterized query."));
                        }
                    } else {
                        DBInfoBasic newDBInfo = null;
                        newDBInfo = this.report.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.report.dbInfo.getJNDIName(), query, this.report.dbInfo.getEnvProperties()) : new DBInfoBasic(this.report.dbInfo.getURLString(), this.report.dbInfo.getDriverName(), this.report.dbInfo.getUserID(), this.report.dbInfo.getPassword(), query);
                        this.dbInfo = new QueryFileInfo("", 0, newDBInfo, paramSet);
                    }
                } else {
                    paramSet = null;
                    if (!this.checkParameterChange(paramSet)) {
                        return;
                    }
                    this.dbInfo = this.report.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.report.dbInfo.getJNDIName(), query, this.report.dbInfo.getEnvProperties()) : new DBInfoBasic(this.report.dbInfo.getURLString(), this.report.dbInfo.getDriverName(), this.report.dbInfo.getUserID(), this.report.dbInfo.getPassword(), query);
                }
            }
            if (!this.isReadOnly()) {
                SaveBackToRegistryDialog dialog = new SaveBackToRegistryDialog(this);
                dialog.setVisible(true);
                if (dialog.isOverwrite()) {
                    this.overwriteQuery(true);
                } else if (dialog.isSaveAsNew()) {
                    this.saveAsNewQuery(true);
                }
            }
        }
        this.prepareResultSet();
    }

    private boolean parameterSharingOK(Vector reportParameters, QueryInParamSet tempParamSet) {
        if (reportParameters == null) {
            return true;
        }
        for (int i = 0; i < reportParameters.size(); ++i) {
            Parameter parameter = (Parameter)reportParameters.elementAt(i);
            if (!parameter.isShared() && !parameter.isShareReferenced()) continue;
            if (tempParamSet == null) {
                return false;
            }
            QueryInParam inParam = tempParamSet.getParameter(parameter.getName());
            if (inParam == null) {
                return false;
            }
            if (inParam.getSqlType() == parameter.getSQLType()) continue;
            return false;
        }
        return true;
    }

    private boolean parameterMappingOK(Vector reportParameters, QueryInParamSet tempParamSet, String[] parameterMap) {
        if (reportParameters == null) {
            return true;
        }
        for (int i = 0; i < reportParameters.size(); ++i) {
            Parameter parameter = (Parameter)reportParameters.elementAt(i);
            if (parameterMap == null || parameterMap[i] == null) continue;
            if (tempParamSet == null) {
                return false;
            }
            QueryInParam inParam = tempParamSet.getParameter(parameter.getName());
            if (inParam == null) {
                return false;
            }
            if (inParam.getSqlType() == parameter.getSQLType()) continue;
            return false;
        }
        return true;
    }

    private void doXMLFileQuery() {
        this.sourceFile = this.report.sourceFile;
        XMLFileQueryInfo info = this.report.getXMLFileQueryInfo();
        String nodeName = info.getFileName();
        nodeName = nodeName.substring(nodeName.lastIndexOf(47) + 1);
        nodeName = nodeName.substring(nodeName.lastIndexOf(92) + 1);
        nodeName = nodeName.substring(0, nodeName.toUpperCase().indexOf(".XML"));
        XMLFileNode parent = new XMLFileNode(nodeName);
        parent.setFile(info.getFileName());
        parent.setDTD(info.getDTDName());
        parent.setQBFormat(false);
        parent.setVerify(info.isVerify());
        if (info.getDTDTreeFileName() != null) {
            parent.setDTDTreeFileName(info.getDTDTreeFileName());
        } else if (info.getDTDName().toUpperCase().endsWith(".DTD")) {
            try {
                DTD dtdTree = DTDUtil.getDTDFromParser(info.getDTDName());
                int ct = 0;
                String tmp = nodeName;
                while (new FileInfo(QueryMain.QUERYDIR + nodeName + ".ddt").exists()) {
                    nodeName = tmp + "_" + ct++;
                }
                String ddtFileName = QueryMain.QUERYDIR + nodeName + ".ddt";
                DTDUtil.writeDTDTreeFile(dtdTree, ddtFileName, 2);
                DTDTreeBuilderDialog dtdBuilderDialog = new DTDTreeBuilderDialog((JDialog)this, null, (DefaultMutableTreeNode)parent, dtdTree);
                dtdBuilderDialog.setVisible(true);
                if (dtdBuilderDialog.isModified()) {
                    DTDUtil.writeDTDTreeFile(dtdBuilderDialog.getDTD(), ddtFileName, 2);
                }
                parent.setDTDTreeFileName(ddtFileName);
                info.setDTDTreeFileName(ddtFileName);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to load DTD", ex);
            }
        } else if (info.getDTDName().toUpperCase().endsWith(".XSD")) {
            try {
                int ct = 0;
                String tmp = nodeName;
                while (new FileInfo(QueryMain.QUERYDIR + nodeName + ".xst").exists()) {
                    nodeName = tmp + "_" + ct++;
                }
                String xstFileName = QueryMain.QUERYDIR + nodeName + ".xst";
                XMLSchemaTreeBuilderDialog builderDialog = new XMLSchemaTreeBuilderDialog(this, info.getDTDName(), info.getFileName(), xstFileName);
                builderDialog.setVisible(true);
                if (builderDialog.isModified()) {
                    builderDialog.save(xstFileName);
                }
                parent.setDTDTreeFileName(xstFileName);
                info.setDTDTreeFileName(xstFileName);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to load XSD", ex);
            }
        }
        XMLQueryNode node = new XMLQueryNode(null);
        Vector<XMLFieldInfo> fields = new Vector<XMLFieldInfo>();
        for (int i = 0; i < info.getFieldInfo().length; ++i) {
            fields.addElement(info.getFieldInfo()[i]);
        }
        node.setSelectedFields(fields);
        node.setConditionStatement(info.getCondition());
        node.setInSet(info.getInSet());
        XMLQueryBuilderDialog xqDialog = new XMLQueryBuilderDialog(new Manager(this, null, false, false, true, null), parent, node);
        xqDialog.setModifyQuery(true);
        xqDialog.setVisible(true);
        if (xqDialog.isModified()) {
            XMLFieldInfo[] xmlFields = new XMLFieldInfo[node.getSelectedFields().size()];
            for (int i = 0; i < node.getSelectedFields().size(); ++i) {
                xmlFields[i] = (XMLFieldInfo)node.getSelectedFields().elementAt(i);
            }
            info.setFieldInfo(xmlFields);
            info.setCondition(node.getConditionStatement());
            info.setInSet(node.getInSet());
            this.xmlFileQueryInfo = info;
            if (node.getInSet() != null) {
                QueryXMLFileInfo xmlFileInfo = new QueryXMLFileInfo(this.xmlFileQueryInfo);
                this.dbInfo = xmlFileInfo;
            }
        }
        this.prepareXMLQueryResultSet();
    }

    private boolean doQueryBuilder() {
        boolean state;
        this.queryMain = new QueryMain(this, this);
        this.queryMain.setBrowseDirectories(this.getBrowseDirectories());
        this.queryMain.setDefaultParamNames(this.reportmain.getDefaultParamNames());
        this.queryMain.setDefaultValueRequiredForParameters(this.reportmain.isDefaultValueRequiredForParameters());
        this.queryMain.setQueryFileBytes(this.dbFileBytes[0]);
        if (this.report.dbInfo instanceof QueryFileInfo) {
            this.queryMain.setInSet(((QueryFileInfo)this.report.dbInfo).getInSet());
            this.queryMain.setReportParameters(this.report.getQueryParameters());
        }
        if (!(state = this.queryMain.openQuery(LanguageEncoder.getText("Internal Query"), this.report.dbInfo.isUseJNDIDataSource(), this.report.dbInfo.getJNDIName(), this.report.dbInfo.getEnvProperties(), this.report.dbInfo.getDriverName(), this.report.dbInfo.getURLString(), this.report.dbInfo.getUserID(), this.report.dbInfo.getPassword(), this.report.dbInfo.getQuery()))) {
            return false;
        }
        this.queryMain.setVisible(true);
        return true;
    }

    private void doDataView() throws Exception {
        Vector<Parameter> queryParameters = this.report.getQueryParameters();
        this.cDialog = new ConditionDialog(this.reportmain, this.report.dbInfo.isUseJNDIDataSource(), this.report.dbInfo.getJNDIName(), this.report.dbInfo.getEnvProperties(), this.report.dbInfo.getDriverName(), this.report.dbInfo.getURLString(), this.report.dbInfo.getUserID(), this.report.dbInfo.getPassword(), this.report.dbInfo.getAdditionalDb(), this.dbFileBytes);
        this.cDialog.setDefaultParamNames(this.reportmain.getDefaultParamNames());
        this.cDialog.setDefaultValueRequiredForParameters(this.reportmain.isDefaultValueRequiredForParameters());
        this.cDialog.setVisible(true);
        if (!this.cDialog.isModified()) {
            return;
        }
        if (!this.checkParameterChange(this.cDialog.getInSet())) {
            return;
        }
        String query = this.cDialog.getQuery();
        if (!(this.report.subReportObject == null || this.parameterSharingOK(queryParameters, this.cDialog.getInSet()) && this.parameterMappingOK(queryParameters, this.cDialog.getInSet(), this.report.subReportObject.getParameterMap()))) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot save query, it violates parameter sharing conditions"));
            return;
        }
        this.dbInfo = this.report.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.report.dbInfo.getJNDIName(), query, this.report.dbInfo.getEnvProperties()) : new DBInfoBasic(this.report.dbInfo.getURLString(), this.report.dbInfo.getDriverName(), this.report.dbInfo.getUserID(), this.report.dbInfo.getPassword(), query, this.report.dbInfo.getAdditionalDb());
        if (QueryParser.hasParameters(query)) {
            this.dbInfo = new QueryFileInfo("", 0, this.dbInfo, this.cDialog.getInSet());
        }
        this.dbFileBytes = this.cDialog.getFileBytes();
        if (!this.isReadOnly()) {
            SaveBackToRegistryDialog dialog = new SaveBackToRegistryDialog(this);
            dialog.setVisible(true);
            if (dialog.isOverwrite()) {
                this.overwriteQuery();
            } else if (dialog.isSaveAsNew()) {
                this.saveAsNewQuery();
            } else if (dialog.isCancelled()) {
                this.dbInfo = null;
            }
        }
        this.prepareResultSet();
    }

    private void prepareXMLQueryResultSet() {
        if (this.xmlFileQueryInfo == null) {
            return;
        }
        this.sourceData = 7;
        ColData[] colData2 = null;
        if (QueryParser.hasParameters(this.xmlFileQueryInfo.getCondition())) {
            QueryXMLFileInfo xmlFileInfo = new QueryXMLFileInfo(this.xmlFileQueryInfo);
            QueryFileInfo.setParentDialog(this);
            QueryFileInfo.getParameter(xmlFileInfo, true);
        }
        try {
            colData2 = new DataFileInput().readProcessedData(this.xmlFileQueryInfo.getFileName(), false, null, null, null, 0, -1, this.xmlFileQueryInfo, this.sourceData);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to retrieve result set from XML file", ex);
            this.report.xmlFileQueryInfo = this.xmlFileQueryInfo;
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to retrieve result set from XML file.\n") + ex.toString());
            return;
        }
        this.colData = colData2;
        this.displayResult();
    }

    private void prepareResultSet() {
        if (this.dbInfo == null) {
            return;
        }
        this.sourceData = 1;
        ColData[] colData2 = null;
        try {
            if (this.dbInfo instanceof QueryFileInfo) {
                QueryInParam[] paramarray;
                for (QueryInParam element : paramarray = ((QueryFileInfo)this.dbInfo).getInSet().getParameter()) {
                    element.setValue(null);
                }
                QueryFileInfo.setParentDialog(this.manager);
                this.sqlParams = QueryFileInfo.getParameter((QueryFileInfo)this.dbInfo, true);
                if (this.sqlParams == null) {
                    this.report.dbInfo = this.dbInfo;
                    return;
                }
            } else {
                this.sqlParams = null;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to get parameter values", ex);
            this.sqlParams = null;
        }
        try {
            colData2 = this.reportType == 2 ? DBAccess.retrieveResult(this.sqlParams, this.dbInfo, true, false, null, null, null, false) : DBAccess.retrieveResult(this.sqlParams, this.dbInfo, true, false, null, null, null, 0, this.reportmain.getDisplayRow(), false);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to retrieve result set from database", ex);
            this.report.dbInfo = this.dbInfo;
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to retrieve result set from database.\n") + ex.toString());
            return;
        }
        this.colData = colData2;
        this.displayResult();
    }

    @Override
    public void back() {
    }

    @Override
    public void setPresetDataRegistry(String data) {
    }

    @Override
    public String getPresetDataRegistry() {
        return null;
    }

    public void setDataRegistryHiddenNodes(Vector data) {
    }

    public Vector getDataRegistryHiddenNodes() {
        return null;
    }

    @Override
    public void next() {
        this.queryMain.setVisible(false);
        String query = this.queryMain.getSQL();
        if (!this.checkParameterChange(this.queryMain.getInSet())) {
            return;
        }
        if (QueryParser.hasParameters(query)) {
            DBInfoBasic newDBInfo = null;
            newDBInfo = this.report.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.report.dbInfo.getJNDIName(), query, this.report.dbInfo.getEnvProperties()) : new DBInfoBasic(this.report.dbInfo.getURLString(), this.report.dbInfo.getDriverName(), this.report.dbInfo.getUserID(), this.report.dbInfo.getPassword(), query, this.report.dbInfo.getAdditionalDb());
            this.dbInfo = new QueryFileInfo("", 0, newDBInfo, this.queryMain.getInSet());
        } else {
            if (this.report.dbInfo.getQuery().equals(query)) {
                return;
            }
            this.dbInfo = this.report.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.report.dbInfo.getJNDIName(), query, this.report.dbInfo.getEnvProperties()) : new DBInfoBasic(this.report.dbInfo.getURLString(), this.report.dbInfo.getDriverName(), this.report.dbInfo.getUserID(), this.report.dbInfo.getPassword(), query);
        }
        this.dbFileBytes[0] = this.queryMain.getQueryFileBytes();
        if (!this.isReadOnly()) {
            SaveBackToRegistryDialog dialog = new SaveBackToRegistryDialog(this);
            dialog.setVisible(true);
            if (dialog.isOverwrite()) {
                this.overwriteQuery();
            } else if (dialog.isSaveAsNew()) {
                this.saveAsNewQuery();
            } else if (dialog.isCancelled()) {
                this.dbInfo = null;
            }
        }
        this.prepareResultSet();
    }

    private void overwriteQuery() {
        this.overwriteQuery(false);
    }

    private boolean isReadOnly() {
        if (!this.reportmain.canModify()) {
            return true;
        }
        try {
            ReadXMLTable readxml = new ReadXMLTable();
            String file = this.reportmain.report.dataSourceLoc;
            if (!new FileInfo(file).exists()) {
                return true;
            }
            readxml.getDataSources(file);
            String message = readxml.isReadOnly();
            return message != null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to check for modify privileges", ex);
            return true;
        }
    }

    private void overwriteQuery(boolean sqlStatement) {
        ReadXMLTable readxml = new ReadXMLTable();
        try {
            String file = this.reportmain.report.dataSourceLoc;
            DefaultDataSourceNode root = (DefaultDataSourceNode)readxml.getDataSources(file);
            this.overwriteQuery(root, root, sqlStatement);
            WriteXMLDataSources.writeDataSources(file, root);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to overwrite query", ex);
        }
    }

    private void overwriteQuery(DefaultDataSourceNode node, DefaultDataSourceNode root, boolean sqlStatement) {
        int ct = node.getChildCount();
        for (int i = 0; i < ct; ++i) {
            DefaultDataSourceNode child = (DefaultDataSourceNode)node.getChildAt(i);
            if (this.dataSourceID.equals(child.getID()) && this.registryID.equals(root.getRegistryID())) {
                if (child instanceof QueryNode) {
                    ((QueryNode)child).setSQL(this.dbInfo.getQuery());
                    if (this.dbFileBytes != null) {
                        ((QueryNode)child).setBytes(this.dbFileBytes[0]);
                    }
                    if (this.dbInfo instanceof QueryFileInfo) {
                        ((QueryNode)child).setInSet(((QueryFileInfo)this.dbInfo).getInSet());
                    }
                    if (this.queryMain == null || sqlStatement) continue;
                    this.queryMain.saveFile(QueryMain.QUERYDIR + ((QueryNode)child).getQueryFile() + ".qry", true);
                    continue;
                }
                if (!(child instanceof DataViewQueryNode)) continue;
                ((DataViewQueryNode)child).setSQL(this.dbInfo.getQuery());
                ((DataViewQueryNode)child).setBytes(this.dbFileBytes);
                if (this.dbInfo instanceof QueryFileInfo) {
                    ((DataViewQueryNode)child).setInSet(((QueryFileInfo)this.dbInfo).getInSet());
                }
                this.cDialog.setDataViewQueryNode((DataViewQueryNode)child);
                this.cDialog.doSaveQuery();
                continue;
            }
            this.overwriteQuery(child, root, sqlStatement);
        }
    }

    private void saveAsNewQuery() {
        this.saveAsNewQuery(false);
    }

    private void saveAsNewQuery(boolean sqlStatement) {
        ReadXMLTable readxml = new ReadXMLTable();
        try {
            String file = this.reportmain.report.dataSourceLoc;
            DefaultDataSourceNode root = (DefaultDataSourceNode)readxml.getDataSources(file);
            this.saveAsNewQuery(root, root, sqlStatement);
            WriteXMLDataSources.writeDataSources(file, root);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot save as new query", ex);
        }
    }

    private void saveAsNewQuery(DefaultDataSourceNode node, DefaultDataSourceNode root, boolean sqlStatement) {
        int ct = node.getChildCount();
        for (int i = 0; i < ct; ++i) {
            DefaultDataSourceNode child = (DefaultDataSourceNode)node.getChildAt(i);
            if (this.dataSourceID.equals(child.getID()) && this.registryID.equals(root.getRegistryID())) {
                String id;
                DefaultDataSourceNode newNode = null;
                if (child instanceof QueryNode) {
                    newNode = this.getNewQueryNode((QueryNode)child, this.getNewFileName(node, ((QueryNode)child).getName()));
                    id = Long.valueOf(Long.parseLong(root.getLastID()) + 1L).toString();
                    root.setLastID(id);
                    ((QueryNode)newNode).setID(id);
                    ((QueryNode)newNode).setSQL(this.dbInfo.getQuery());
                    if (this.dbFileBytes != null) {
                        ((QueryNode)newNode).setBytes(this.dbFileBytes[0]);
                    }
                    if (this.dbInfo instanceof QueryFileInfo) {
                        ((QueryNode)newNode).setInSet(((QueryFileInfo)this.dbInfo).getInSet());
                    }
                    if (this.queryMain != null && !sqlStatement) {
                        this.queryMain.saveFile(QueryMain.QUERYDIR + ((QueryNode)newNode).getQueryFile() + ".qry", true);
                    }
                } else if (child instanceof DataViewQueryNode) {
                    newNode = this.getNewDataViewQueryNode((DataViewQueryNode)child, this.getNewFileName(node, ((DataViewQueryNode)child).getName()));
                    id = Long.valueOf(Long.parseLong(root.getLastID()) + 1L).toString();
                    root.setLastID(id);
                    ((DataViewQueryNode)newNode).setID(id);
                    ((DataViewQueryNode)newNode).setSQL(this.dbInfo.getQuery());
                    ((DataViewQueryNode)newNode).setBytes(this.dbFileBytes);
                    if (this.dbInfo instanceof QueryFileInfo) {
                        ((DataViewQueryNode)newNode).setInSet(((QueryFileInfo)this.dbInfo).getInSet());
                    }
                    this.cDialog.setDataViewQueryNode((DataViewQueryNode)newNode);
                    this.cDialog.doSaveQuery();
                }
                node.add(newNode);
                this.reportmain.report.dataSourceID = newNode.getID();
                this.dataSourceID = newNode.getID();
                continue;
            }
            this.saveAsNewQuery(child, root, sqlStatement);
        }
    }

    private QueryNode getNewQueryNode(QueryNode oldNode, String newNodeName) {
        QueryNode newQueryNode = new QueryNode(newNodeName);
        newQueryNode.setSQL(oldNode.getSQL());
        newQueryNode.setQueryBuilderUsed(oldNode.isQueryBuilderUsed());
        String oldQueryFile = oldNode.getQueryFile();
        if (oldNode.isQueryBuilderUsed() && oldQueryFile != null) {
            String newQueryFile = this.getNewQueryFile(oldNode, newNodeName, false, false);
            newQueryNode.setQueryFile(newQueryFile);
            CopyFile.copy(QueryMain.QUERYDIR + oldQueryFile + ".qry", QueryMain.QUERYDIR + newQueryFile + ".qry");
        }
        newQueryNode.setDictionaryCompatible(oldNode.isDictionaryCompatible());
        newQueryNode.setInSet(oldNode.getInSet());
        return newQueryNode;
    }

    private DataViewQueryNode getNewDataViewQueryNode(DataViewQueryNode oldNode, String newNodeName) {
        String newQueryFile;
        DataViewQueryNode dvQueryNode = new DataViewQueryNode(newNodeName);
        dvQueryNode.setSQL(oldNode.getSQL());
        String newDataViewFile = this.getNewQueryFile(oldNode, newNodeName, false, true);
        dvQueryNode.setDataViewFile(newDataViewFile);
        String oldQueryFile = oldNode.getQueryFile();
        String oldDataViewFile = oldNode.getDataViewFile();
        String tmp = newQueryFile = newDataViewFile + "_query";
        int ct = 0;
        try {
            while (new FileInfo(QueryMain.QUERYDIR + newQueryFile + ".dvw").exists()) {
                newQueryFile = tmp + "_" + ct++;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to choose query file name", ex);
        }
        newQueryFile = QueryMain.QUERYDIR + newQueryFile;
        dvQueryNode.setQueryFile(newQueryFile);
        CopyFile.copy(QueryMain.QUERYDIR + oldDataViewFile + ".dvw", QueryMain.QUERYDIR + newDataViewFile + ".dvw");
        CopyFile.copy(oldQueryFile + ".dvw", newQueryFile + ".dvw");
        return dvQueryNode;
    }

    private String getNewQueryFile(DefaultDataSourceNode oldNode, String newNodeName, boolean forDataViewNode, boolean forDataViewQueryNode) {
        String ext = forDataViewNode || forDataViewQueryNode ? ".dvw" : ".qry";
        String fileprefix = this.reportmain.report.dataSourceLoc;
        fileprefix = fileprefix.substring(fileprefix.lastIndexOf(47) + 1);
        fileprefix = fileprefix.substring(fileprefix.lastIndexOf(92) + 1);
        fileprefix = fileprefix.substring(0, fileprefix.toUpperCase().indexOf(".XML"));
        fileprefix = forDataViewQueryNode ? fileprefix + "_" + ((DataViewNode)oldNode.getParent()).getName() + "_" : fileprefix + "_" + ((DatabaseNode)oldNode.getParent().getParent()).getName() + "_";
        String newQueryFile = fileprefix + newNodeName;
        String tmp = newQueryFile = newQueryFile.replace(' ', '_');
        int ct = 0;
        try {
            while (new FileInfo(QueryMain.QUERYDIR + newQueryFile + ext).exists()) {
                newQueryFile = tmp + "_" + ct++;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to choose query file name", ex);
        }
        return newQueryFile;
    }

    private String getNewFileName(DefaultDataSourceNode parent, String fileName) {
        int len;
        int ct = 0;
        for (len = fileName.length(); Character.isDigit(fileName.charAt(len - 1)) && len > 1; --len) {
        }
        if (len < fileName.length()) {
            String ctstring = fileName.substring(len, fileName.length());
            ct = Integer.parseInt(ctstring);
        }
        String tmp = fileName.substring(0, len);
        String newFile = tmp + ct;
        try {
            boolean exist = true;
            while (exist) {
                exist = false;
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    if (!((String)((DefaultDataSourceNode)parent.getChildAt(i)).getUserObject()).equals(newFile)) continue;
                    exist = true;
                    break;
                }
                if (!exist) continue;
                newFile = tmp + ct++;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to choose file name", ex);
        }
        return newFile;
    }

    private boolean checkParameterChange(QueryInParamSet newParamSet) {
        if (this.reportmain.isSubReport()) {
            return true;
        }
        if (this.report.currentNode != null && !this.report.currentNode.equals((DrillDownNode)this.reportmain.getDrillDownTree().getModel().getRoot())) {
            JMessageDialog msgDialog;
            int response;
            boolean changed = false;
            QueryInParam[] param = null;
            if (this.report.dbInfo instanceof QueryFileInfo) {
                param = ((QueryFileInfo)this.report.dbInfo).getInSet().getParameter();
            } else {
                changed = true;
            }
            if (newParamSet == null || newParamSet.getParameter() == null) {
                changed = true;
            } else if (param != null) {
                QueryInParam[] newParam = newParamSet.getParameter();
                if (param.length != newParam.length) {
                    changed = true;
                } else {
                    for (int i = 0; i < param.length; ++i) {
                        if (param[i].equals((Object)newParam[i])) continue;
                        changed = true;
                        break;
                    }
                }
            }
            if (changed && (response = (msgDialog = new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Changing parameter may cause drilldown report to work incorrectly! Are you sure you want to continue?"), 2)).getResponse()) == 5) {
                return false;
            }
        }
        return true;
    }
}

