/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;

public class ViewerFontSetupDialog
extends JDialog
implements ActionListener {
    ReportMain reportmain;
    JCheckBox adjustFontCheckBox;
    JButton okBtn;
    JButton cancelBtn;
    boolean modified;
    boolean isAdjustFont;

    public ViewerFontSetupDialog(ReportMain reportmain) {
        super(reportmain, LanguageEncoder.getText("Adjust Font"), true);
        this.reportmain = reportmain;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel setupPanel = new JPanel();
        setupPanel.setLayout(new FlowLayout(0));
        this.adjustFontCheckBox = new JCheckBox(LanguageEncoder.getText("Adjust Font"), this.reportmain.report.isAdjustFont());
        setupPanel.add(this.adjustFontCheckBox);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Adjust Font")));
        mainPanel.add(setupPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okBtn = new JButton(LanguageEncoder.getText("OK"));
        this.cancelBtn = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.okBtn);
        buttonPanel.add(this.cancelBtn);
        this.okBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okBtn) {
            this.modified = true;
            this.isAdjustFont = this.adjustFontCheckBox.isSelected();
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isAdjustFont() {
        return this.isAdjustFont;
    }
}

