/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.util.internal.IDataInterchange;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.QueryResultPanel;
import quadbase.reportdesigner.designer.ReportWizard;
import quadbase.reportdesigner.designer.TransposeColumnDialog;
import quadbase.reportdesigner.designer.UpdateDataSourceWizard;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.util.internal.TransposeRS;

public class WizardStep41
extends JPanel
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(WizardStep41.class.getName());
    static int TABLESIZE = 20;
    boolean retrievedAll = false;
    ReportWizard wizard;
    WizardStep41 previousPanel;
    JPanel okpanel;
    JPanel originalAllPanel;
    JPanel originalSomePanel;
    JPanel transposedAllPanel;
    JPanel transposedSomePanel;
    JButton createReportButton;
    JButton prevButton;
    JButton cancelButton;
    JButton chtButton;
    JCheckBox transposeCheckbox;
    JCheckBox showAllCheckbox;
    JLabel statusBar;
    JPanel switchPanel;
    CardLayout card;
    ColData[] originalData;
    ColData[] transposedData;
    boolean[] transposeCol;
    boolean allRowsRetrieved = false;
    private boolean showBackButton = true;
    private IDataInterchange toChart;
    private boolean changingItemState = false;

    public WizardStep41(ReportWizard wizard) {
        this(wizard, true);
    }

    public WizardStep41(ReportWizard wizard, boolean showBack) {
        this(wizard, showBack, null, false);
    }

    public WizardStep41(ReportWizard wizard, boolean showBack, IDataInterchange toChart) {
        this(wizard, showBack, toChart, false);
    }

    public WizardStep41(ReportWizard wizard, boolean showBack, IDataInterchange toChart, boolean inReadOnlyDirectory) {
        boolean showSomeData;
        this.wizard = wizard;
        this.showBackButton = showBack;
        this.toChart = toChart;
        this.originalData = wizard.colData;
        this.transposedData = null;
        wizard.isTransposed = false;
        wizard.transposeCol = null;
        this.setBackground(Color.lightGray);
        JPanel bpanel = new JPanel();
        bpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Query Result")));
        bpanel.setLayout(new BorderLayout());
        this.card = new CardLayout();
        this.switchPanel = new JPanel(this.card);
        boolean bl = showSomeData = this.originalData[0].getSize() >= TABLESIZE;
        if (showSomeData) {
            this.originalSomePanel = new QueryResultPanel(this.originalData, TABLESIZE);
            this.switchPanel.add("originalSome", this.originalSomePanel);
        } else {
            this.originalAllPanel = new QueryResultPanel(this.originalData);
            this.switchPanel.add("originalAll", this.originalAllPanel);
        }
        bpanel.add("Center", this.switchPanel);
        this.okpanel = new JPanel(new FlowLayout(2));
        this.transposeCheckbox = new JCheckBox(LanguageEncoder.getText("Transpose Data"), false);
        this.transposeCheckbox.setToolTipText(LanguageEncoder.getText("This transpose is for Create Report only."));
        this.okpanel.add(this.transposeCheckbox);
        this.transposeCheckbox.addItemListener(this);
        if (showSomeData) {
            this.showAllCheckbox = new JCheckBox(LanguageEncoder.getText("Show All Records"), false);
            this.okpanel.add(this.showAllCheckbox);
            this.showAllCheckbox.addItemListener(this);
        }
        this.prevButton = new JButton(LanguageEncoder.getText("<< Back"));
        if (this.showBackButton) {
            this.okpanel.add(this.prevButton);
        }
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okpanel.add(this.cancelButton);
        if (toChart == null) {
            this.createReportButton = new JButton(LanguageEncoder.getText("Next >>"));
            this.okpanel.add(this.createReportButton);
        } else {
            this.chtButton = new JButton(LanguageEncoder.getText("Create Chart >>"));
            this.okpanel.add(this.chtButton);
            this.chtButton.setToolTipText(LanguageEncoder.getText("Chart data transpose is in chart Data Mapping using Multi Selection."));
            this.createReportButton = new JButton(LanguageEncoder.getText("Create Report >>"));
            this.okpanel.add(this.createReportButton);
        }
        this.prevButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        if (this.chtButton != null) {
            this.chtButton.addActionListener(this);
        }
        this.createReportButton.addActionListener(this);
        this.statusBar = new JLabel("");
        this.statusBar.setHorizontalAlignment(2);
        if (showSomeData) {
            this.statusBar.setText(LanguageEncoder.getText("Showing the first 20 records"));
        }
        bpanel.add("South", this.okpanel);
        this.setLayout(new BorderLayout());
        this.add("Center", bpanel);
        this.add("South", this.statusBar);
    }

    private void newreport(JPanel outPanel) {
        if (this.wizard instanceof UpdateDataSourceWizard) {
            ((UpdateDataSourceWizard)this.wizard).redoDataMapping(outPanel);
        } else {
            this.statusBar.setText(LanguageEncoder.getText("Loading icons, please wait..."));
            this.wizard.newreportType(outPanel);
            this.statusBar.setText("");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.createReportButton) {
            this.doOK(this);
        } else if (this.chtButton != null && source == this.chtButton) {
            QueryFileInfo qfi;
            if (this.wizard.dbInfo instanceof QueryFileInfo && (qfi = (QueryFileInfo)this.wizard.dbInfo).getInSet() != null && qfi.getInSet().hasParameterSequence() && JOptionPane.showConfirmDialog(null, "This data source contains cascading parameters which are not supported in Charts.  \nWould you like to continue without cascading parameters?", LanguageEncoder.getText("Warning"), 2) != 0) {
                return;
            }
            this.toChart.next(true, this.wizard.isTransposed, this.wizard.transposeCol, this);
        } else if (source == this.prevButton) {
            this.wizard.isTransposed = false;
            if (this.chtButton != null) {
                this.chtButton.setEnabled(!this.wizard.isTransposed);
            }
            this.wizard.transposeCol = null;
            if (this.previousPanel != null) {
                this.wizard.swapPanel(this, this.previousPanel);
            } else {
                this.wizard.getStep3(this, this.wizard.step1);
            }
        } else if (source == this.cancelButton) {
            this.wizard.cancel();
        }
    }

    protected void doOK(JPanel outPanel) {
        if (this.wizard.sourceData == 3 || this.wizard.dbInfo instanceof QueryFileInfo || !this.showBackButton || this.wizard.reportmain.isSkipMultiDataSourceStep()) {
            this.newreport(outPanel);
        } else {
            this.wizard.getMultiSource(outPanel);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean showState;
        if (this.changingItemState) {
            return;
        }
        this.disableComponents();
        boolean transposeState = this.transposeCheckbox.isSelected();
        if (this.chtButton != null) {
            this.chtButton.setEnabled(!transposeState);
        }
        boolean bl = showState = this.showAllCheckbox == null || this.showAllCheckbox.isSelected() || this.wizard.colData[0].getSize() <= TABLESIZE && this.allRowsRetrieved;
        if (transposeState) {
            if (this.transposedData == null) {
                try {
                    TransposeColumnDialog transposeDialog = new TransposeColumnDialog(this.wizard.reportmain, this.originalData);
                    transposeDialog.setVisible(true);
                    this.transposeCol = transposeDialog.getTransposeColumn();
                    this.changingItemState = true;
                    this.transposeCheckbox.setSelected(this.transposeCol != null);
                    if (this.chtButton != null) {
                        this.chtButton.setEnabled(!this.transposeCheckbox.isSelected());
                    }
                    this.changingItemState = false;
                    if (this.transposeCol == null) {
                        this.changingItemState = true;
                        this.enableComponents();
                        this.changingItemState = false;
                        return;
                    }
                    this.statusBar.setText(LanguageEncoder.getText("Transposing data, please wait..."));
                    this.transposedData = ColData.getColData(TransposeRS.doTranspose(this.originalData, this.transposeCol));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Cannot transpose data", ex);
                    new JMessageDialog((Frame)this.wizard.reportmain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot transpose data") + "\n" + ex.toString());
                    this.transposeCol = null;
                    this.changingItemState = true;
                    this.transposeCheckbox.setSelected(false);
                    if (this.chtButton != null) {
                        this.chtButton.setEnabled(true);
                    }
                    this.enableComponents();
                    this.changingItemState = false;
                }
            }
            if (showState && this.transposedAllPanel == null) {
                this.showBuildMessage();
                try {
                    if (!this.allRowsRetrieved) {
                        this.wizard.getAllRows();
                        this.originalData = this.wizard.colData;
                        this.transposedData = ColData.getColData(TransposeRS.doTranspose(this.originalData, this.transposeCol));
                    }
                    this.transposedAllPanel = new QueryResultPanel(this.transposedData);
                }
                catch (Error er) {
                    LOGGER.log(Level.FINE, "Cannot build table", er);
                    new JMessageDialog((Frame)this.wizard.reportmain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot build table") + "\n" + er.toString());
                    this.showAllCheckbox.setSelected(false);
                    this.enableComponents();
                    return;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Cannot build table", ex);
                    new JMessageDialog((Frame)this.wizard.reportmain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot build table") + "\n" + ex.toString());
                    this.showAllCheckbox.setSelected(false);
                    this.enableComponents();
                    return;
                }
                this.switchPanel.add("transposedAll", this.transposedAllPanel);
            } else if (!showState && this.transposedSomePanel == null) {
                this.showBuildMessage();
                try {
                    this.transposedSomePanel = new QueryResultPanel(this.transposedData, TABLESIZE);
                }
                catch (Error er) {
                    LOGGER.log(Level.FINE, "Cannot build table", er);
                    new JMessageDialog((Frame)this.wizard.reportmain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot build table") + "\n" + er.toString());
                    this.showAllCheckbox.setSelected(true);
                    this.enableComponents();
                    return;
                }
                this.switchPanel.add("transposedSome", this.transposedSomePanel);
            }
        } else {
            this.transposedData = null;
            this.transposedSomePanel = null;
            this.transposedAllPanel = null;
            if (showState && this.originalAllPanel == null) {
                this.showBuildMessage();
                if (!this.allRowsRetrieved) {
                    this.wizard.getAllRows();
                    this.originalData = this.wizard.colData;
                }
                try {
                    this.originalAllPanel = new QueryResultPanel(this.originalData);
                }
                catch (Error er) {
                    LOGGER.log(Level.FINE, "Cannot build table", er);
                    new JMessageDialog((Dialog)this.wizard, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot build table") + "\n" + er.toString());
                    this.showAllCheckbox.setSelected(false);
                    this.enableComponents();
                    return;
                }
                this.switchPanel.add("originalAll", this.originalAllPanel);
            } else if (!showState && this.originalSomePanel == null) {
                this.showBuildMessage();
                try {
                    this.originalSomePanel = new QueryResultPanel(this.originalData, TABLESIZE);
                }
                catch (Error er) {
                    LOGGER.log(Level.FINE, "Cannot build table", er);
                    new JMessageDialog((Dialog)this.wizard, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot build table") + "\n" + er.toString());
                    this.showAllCheckbox.setSelected(true);
                    this.enableComponents();
                    return;
                }
                this.switchPanel.add("originalSome", this.originalSomePanel);
            }
        }
        if (transposeState) {
            this.wizard.colData = this.transposedData;
            this.wizard.isTransposed = true;
            this.wizard.transposeCol = this.transposeCol;
            if (showState) {
                this.card.show(this.switchPanel, "transposedAll");
            } else {
                this.card.show(this.switchPanel, "transposedSome");
            }
        } else {
            this.wizard.colData = this.originalData;
            this.wizard.isTransposed = false;
            this.wizard.transposeCol = null;
            if (showState) {
                this.card.show(this.switchPanel, "originalAll");
            } else {
                this.card.show(this.switchPanel, "originalSome");
            }
        }
        if (!(this.wizard instanceof UpdateDataSourceWizard)) {
            this.wizard.report = null;
        }
        this.enableComponents();
    }

    private void enableComponents() {
        if (this.transposeCheckbox != null) {
            this.transposeCheckbox.setEnabled(true);
        }
        if (this.showAllCheckbox != null) {
            this.showAllCheckbox.setEnabled(true);
        }
        this.createReportButton.setEnabled(true);
        this.prevButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        this.statusBar.setText("");
    }

    private void disableComponents() {
        if (this.transposeCheckbox != null) {
            this.transposeCheckbox.setEnabled(false);
        }
        if (this.showAllCheckbox != null) {
            this.showAllCheckbox.setEnabled(false);
        }
        this.createReportButton.setEnabled(false);
        this.prevButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
    }

    private void showBuildMessage() {
        this.statusBar.setText(LanguageEncoder.getText("Building table, please wait..."));
    }
}

