/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportWizard;
import quadbase.reportdesigner.designer.UpdateDataSourceWizard;
import quadbase.reportdesigner.report.ColData;

public class WizardStepMultiData
extends JPanel
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(WizardStepMultiData.class.getName());
    JRadioButton cb_Yes;
    JRadioButton cb_No;
    ReportWizard wizard;
    JButton nextButton;
    JButton prevButton;
    JButton cancelButton;
    int prevSourceData = -1;

    public WizardStepMultiData(ReportWizard wizard) {
        this.wizard = wizard;
        this.setBackground(Color.lightGray);
        JPanel bpanel = new JPanel();
        bpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Merge Data From Other Source")));
        bpanel.setLayout(new BorderLayout());
        this.cb_Yes = new JRadioButton(LanguageEncoder.getText("Get Other Data Source"));
        this.cb_No = new JRadioButton(LanguageEncoder.getText("Process Data"));
        this.cb_No.setSelected(true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.cb_Yes);
        bg.add(this.cb_No);
        JPanel gridpanel = new JPanel();
        gridpanel.setLayout(new GridLayout(2, 1));
        gridpanel.add(this.cb_No);
        gridpanel.add(this.cb_Yes);
        bpanel.add("Center", gridpanel);
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(2));
        this.prevButton = new JButton(LanguageEncoder.getText("<< Back"));
        okpanel.add(this.prevButton);
        this.prevButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        okpanel.add(this.cancelButton);
        this.nextButton = new JButton(LanguageEncoder.getText("Next >>"));
        okpanel.add(this.nextButton);
        this.cancelButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.nextButton.requestFocus();
        bpanel.add("South", okpanel);
        this.setLayout(new BorderLayout());
        this.add("Center", bpanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.nextButton) {
            if (this.cb_Yes.isSelected()) {
                this.addColData();
                this.wizard.colData = null;
                this.wizard.newReport(false, false, this);
            } else if (this.wizard.colDataList.size() <= 0) {
                if (this.wizard instanceof UpdateDataSourceWizard) {
                    ((UpdateDataSourceWizard)this.wizard).redoDataMapping(this);
                } else {
                    this.wizard.newreportType(this);
                }
            } else {
                ColData[] colData = null;
                try {
                    this.addColData();
                    colData = ColData.merge(this.wizard.colDataList, true);
                    this.wizard.colData = colData;
                    this.prevSourceData = this.wizard.sourceData;
                    this.wizard.sourceData = 3;
                    this.wizard.displayMergeResult(this);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to to set mutli data", ex);
                    new JMessageDialog((Frame)this.wizard.reportmain, LanguageEncoder.getText("Error"), ex.toString());
                    this.wizard.cancel();
                    return;
                }
            }
        } else if (source == this.prevButton) {
            if (this.wizard.sourceData == 3) {
                this.wizard.sourceData = this.prevSourceData;
                int lastIndex = this.wizard.colDataList.size() - 1;
                if (lastIndex >= 0) {
                    this.wizard.colData = this.wizard.colDataList.elementAt(lastIndex);
                    this.wizard.colDataList.removeElementAt(lastIndex);
                    this.wizard.sourceInfo.removeElementAt(lastIndex);
                    this.wizard.sourceType.removeElementAt(lastIndex);
                    this.wizard.doTranspose.removeElementAt(lastIndex);
                    this.wizard.transposeColList.removeElementAt(lastIndex);
                }
            }
            this.wizard.doMultiDataBack(this, this.wizard.step41);
        } else {
            this.wizard.cancel();
        }
    }

    private void addColData() {
        if (this.wizard.colData != null && this.wizard.sourceData != 3 && (this.wizard.colDataList.size() <= 0 || this.wizard.colData != this.wizard.colDataList.lastElement())) {
            this.wizard.colDataList.addElement(this.wizard.colData);
            this.wizard.doTranspose.addElement(this.wizard.isTransposed);
            this.wizard.transposeColList.addElement(this.wizard.transposeCol);
            this.wizard.isTransposed = false;
            this.wizard.transposeCol = null;
            if (this.wizard.sourceData == 1) {
                this.wizard.sourceInfo.addElement(this.wizard.dbInfo);
            } else if (this.wizard.sourceData == 2 || this.wizard.sourceData == 6 || this.wizard.sourceData == 4) {
                this.wizard.sourceInfo.addElement(this.wizard.sourceFile);
            } else if (this.wizard.sourceData == 5) {
                this.wizard.sourceInfo.addElement(new EJBInfo(this.wizard.jndiName, this.wizard.homeName, this.wizard.remoteName, this.wizard.selectedMethodName, this.wizard.selectedMethodParamVal, this.wizard.environment));
            } else if (this.wizard.sourceData == 7) {
                this.wizard.sourceInfo.addElement(this.wizard.xmlFileQueryInfo);
            }
            this.wizard.sourceType.addElement(this.wizard.sourceData);
        }
    }
}

