/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.designer.ReportMain;

public class ZIndexDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(ZIndexDialog.class.getName());
    ReportElement elt;
    int zIndex = 0;
    boolean modified = false;
    JButton okButton;
    JButton cancelButton;
    JTextField tf;

    public ZIndexDialog(ReportMain reportMain, ReportElement elt) {
        super(reportMain, LanguageEncoder.getText("Set Z-index ..."), true);
        this.elt = elt;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(LanguageEncoder.getText("")));
        panel.setLayout(new GridLayout(1, 2));
        panel.add(new JLabel(LanguageEncoder.getText("Z-Index:")));
        String s = "";
        if (this.elt != null) {
            s = Integer.valueOf(this.elt.getZ()).toString();
        }
        this.tf = new JTextField(s, 8);
        panel.add(this.tf);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        contentPane.add("Center", panel);
        contentPane.add("South", buttonPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.modified = true;
            try {
                this.zIndex = Integer.parseInt(this.tf.getText());
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.FINEST, "Invalid number", nfe);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Integer only please!"));
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }

    public int getZIndex() {
        return this.zIndex;
    }
}

