/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportTitle;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportdesigner.util.DateTimeFormat;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.LocaleDateTimeFormat;
import quadbase.reportdesigner.util.LocaleNumericFormat;
import quadbase.reportdesigner.util.LogicalFormat;
import quadbase.reportdesigner.util.NumericFormat;
import quadbase.reportdesigner.util.StringFormat;

public class ExportGlobalFormat {
    private static final Logger LOGGER = Logger.getLogger(ExportGlobalFormat.class.getName());
    public static final String GLOBALFORMAT = "GlobalFormat";
    public static final String ADJUSTVIEWERFONT = "AdjustViewerFont";
    public static final String LABEL = "Label";
    public static final String IMAGE = "Image";
    public static final String FORMULA = "Formula";
    public static final String COLUMN = "Column";
    public static final String CHART = "Chart";
    public static final String LINE = "Line";
    public static final String GRID = "Grid";
    public static final String COLUMNHEADER = "ColumnHeader";
    public static final String TITLE = "Title";
    public static final String FONTCOLOR = "FontColor";
    public static final String FONTTYPE = "FontType";
    public static final String FONTSTYLE = "FontStyle";
    public static final String FONTSIZE = "FontSize";
    public static final String BACKGROUNDCOLOR = "BackgroundColor";
    public static final String BORDERCOLOR = "BorderColor";
    public static final String BORDERTHICKNESS = "BorderThickness";
    public static final String ROTATION = "Rotation";
    public static final String ALIGNMENT = "Alignment";
    public static final String ALIGNMENT_VERT = "AlignmentVertical";
    public static final String WIDTH = "Width";
    public static final String HEIGHT = "Height";
    public static final String RADIUS = "Radius";
    public static final String FONTCOLOR2 = "FontColor2";
    public static final String FONTTYPE2 = "FontType2";
    public static final String FONTSTYLE2 = "FontStyle2";
    public static final String FONTSIZE2 = "FontSize2";
    public static final String BACKGROUNDCOLOR2 = "BackgroundColor2";
    public static final String ALTERNATEROW = "AlternateRow";
    public static final String AUTO_RESIZE = "AutoResize";
    public static final String POSITION = "Position";
    public static final String LENGTH = "Length";
    public static final String THICKNESS = "Thickness";
    public static final String LINESTYLE = "LineStyle";
    public static final String MATCHCOLUMNWIDTHS = "MatchColumnWidthS";
    public static final String STRING = "String";
    public static final String LOGICAL = "Logical";
    public static final String NUMERIC = "Numeric";
    public static final String LOCALENUMERIC = "LocaleNumeric";
    public static final String DATETIME = "DateTime";
    public static final String LOCALEDATETIME = "LocaleDateTime";
    public static final String USEDEFAULTSIZE = "UseDefaultSize";
    public static final String FORMAT = "Format";
    private static final String TAB = "  ";
    private Report report = null;
    private PrintStream out;

    public ExportGlobalFormat(Report report) {
        this.report = report;
    }

    public void exportXML(String file) throws IOException {
        if (file == null || file.trim().equals("")) {
            throw new IOException("No file name selected !");
        }
        ByteArrayOutputStream outstream = new ByteArrayOutputStream(2048);
        this.out = new PrintStream((OutputStream)outstream, false, ServerMessage.xmlEncoding);
        this.out.println("<?xml version=\"1.0\" encoding=\"" + ServerMessage.xmlEncoding + "\"?>");
        this.out.println("<GlobalFormat>");
        this.out.println("<AdjustViewerFont>" + this.report.isAdjustFont() + "</" + ADJUSTVIEWERFONT + ">");
        this.exportLabel();
        this.exportColumnHeader();
        this.exportTitle();
        this.exportImage();
        this.exportFormula();
        this.exportColumn();
        this.exportChart();
        this.exportLine();
        this.exportGrid();
        this.out.println("</GlobalFormat>");
        this.out.flush();
        this.out.close();
        try {
            WriteDataFile wdfile = new WriteDataFile();
            if (!file.endsWith(".xml")) {
                file = file + ".xml";
            }
            wdfile.output(null, outstream.toByteArray(), file);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to export XML file", ex);
            throw new IOException(ex.getMessage());
        }
        finally {
            outstream.close();
        }
    }

    private void exportLabel() {
        if (this.report != null && this.report.labelSetting != null && this.out != null) {
            ReportCell element = this.report.labelSetting;
            this.out.print(TAB);
            this.out.print("<Label ");
            this.writeAttribute(element, FONTCOLOR);
            this.writeAttribute(element, FONTTYPE);
            this.writeAttribute(element, FONTSTYLE);
            this.writeAttribute(element, FONTSIZE);
            this.writeAttribute(element, ROTATION);
            this.writeAttribute(element, BACKGROUNDCOLOR);
            this.writeAttribute(element, BORDERCOLOR);
            this.writeAttribute(element, BORDERTHICKNESS);
            this.writeAttribute(element, ALIGNMENT);
            this.writeAttribute(element, ALIGNMENT_VERT);
            this.writeAttribute(element, WIDTH);
            this.writeAttribute(element, HEIGHT);
            this.out.println("/>");
        }
    }

    private void exportTitle() {
        if (this.report != null && this.report.titleSetting != null && this.out != null) {
            ReportTitle element = this.report.titleSetting;
            this.out.println(TAB);
            this.out.println("<Title ");
            this.writeAttribute(element, AUTO_RESIZE);
            this.writeAttribute(element, POSITION);
            this.writeAttribute(element, FONTCOLOR);
            this.writeAttribute(element, FONTTYPE);
            this.writeAttribute(element, FONTSTYLE);
            this.writeAttribute(element, FONTSIZE);
            this.writeAttribute(element, BACKGROUNDCOLOR);
            this.writeAttribute(element, BORDERCOLOR);
            this.writeAttribute(element, BORDERTHICKNESS);
            this.writeAttribute(element, ALIGNMENT);
            this.writeAttribute(element, ALIGNMENT_VERT);
            this.writeAttribute(element, WIDTH);
            this.writeAttribute(element, HEIGHT);
            this.out.println("/>");
        }
    }

    private void exportColumnHeader() {
        if (this.report != null && this.report.columnHeaderSetting != null && this.out != null) {
            ColumnHeader element = this.report.columnHeaderSetting;
            this.out.print(TAB);
            this.out.print("<ColumnHeader ");
            this.writeAttribute(element, FONTCOLOR);
            this.writeAttribute(element, FONTTYPE);
            this.writeAttribute(element, FONTSTYLE);
            this.writeAttribute(element, FONTSIZE);
            this.writeAttribute(element, BACKGROUNDCOLOR);
            this.writeAttribute(element, BORDERCOLOR);
            this.writeAttribute(element, BORDERTHICKNESS);
            this.writeAttribute(element, ROTATION);
            this.writeAttribute(element, ALIGNMENT);
            this.writeAttribute(element, ALIGNMENT_VERT);
            this.writeAttribute(element, WIDTH);
            this.writeAttribute(element, HEIGHT);
            this.out.println("/>");
        }
    }

    private void exportImage() {
        if (this.report != null && this.report.imageSetting != null && this.out != null) {
            ReportImage element = this.report.imageSetting;
            this.out.print(TAB);
            this.out.print("<Image ");
            this.writeAttribute(element, BORDERCOLOR);
            this.writeAttribute(element, BORDERTHICKNESS);
            this.writeAttribute(element, ALIGNMENT);
            this.writeAttribute(element, WIDTH);
            this.writeAttribute(element, HEIGHT);
            this.out.print("UseDefaultSize=\"" + !this.report.isApplyBoundSelected() + "\" ");
            this.out.println("/>");
        }
    }

    private void exportFormula() {
        if (this.report != null && this.report.formula != null && this.out != null) {
            ReportCell element = this.report.formula[0];
            this.out.print(TAB);
            this.out.print("<Formula ");
            this.writeAttribute(element, FONTCOLOR);
            this.writeAttribute(element, FONTTYPE);
            this.writeAttribute(element, FONTSTYLE);
            this.writeAttribute(element, FONTSIZE);
            this.writeAttribute(element, BACKGROUNDCOLOR);
            this.writeAttribute(element, BORDERCOLOR);
            this.writeAttribute(element, BORDERTHICKNESS);
            this.writeAttribute(element, ROTATION);
            this.writeAttribute(element, ALIGNMENT);
            this.writeAttribute(element, ALIGNMENT_VERT);
            this.writeAttribute(element, WIDTH);
            this.writeAttribute(element, HEIGHT);
            this.out.println(">");
            for (ReportCell element2 : this.report.formula) {
                IFormat format;
                element = element2;
                if (element == null || (format = element.getDataFormat()) == null) continue;
                if (format instanceof StringFormat) {
                    this.out.println("    <String Format=\"" + XMLUtil.encodeXML(format.getTextFormat()) + "\" />");
                }
                if (format instanceof LogicalFormat) {
                    this.out.println("    <Logical Format=\"" + XMLUtil.encodeXML(format.getTextFormat()) + "\" />");
                }
                if (format instanceof NumericFormat) {
                    this.out.println("    <Numeric Format=\"" + XMLUtil.encodeXML(format.getTextFormat()) + "\" />");
                }
                if (format instanceof LocaleNumericFormat) {
                    this.out.println("    <LocaleNumeric Format=\"" + XMLUtil.encodeXML(format.getTextFormat()) + "\" />");
                }
                if (format instanceof DateTimeFormat) {
                    this.out.println("    <DateTime Format=\"" + XMLUtil.encodeXML(format.getTextFormat()) + "\" />");
                }
                if (!(format instanceof LocaleDateTimeFormat)) continue;
                this.out.println("    <LocaleDateTime Format=\"" + XMLUtil.encodeXML(format.getTextFormat()) + "\" />");
            }
            this.out.println("  </Formula>");
        }
    }

    private void exportColumn() {
        if (this.report != null && this.report.column != null && this.out != null) {
            ReportColumn element = this.report.column[0];
            this.out.print(TAB);
            this.out.print("<Column ");
            this.writeAttribute(element, FONTCOLOR);
            this.writeAttribute(element, FONTTYPE);
            this.writeAttribute(element, FONTSTYLE);
            this.writeAttribute(element, FONTSIZE);
            this.writeAttribute(element, BACKGROUNDCOLOR);
            this.out.print("FontColor2=\"" + element.getFontColor2().getRGB() + "\" ");
            this.out.print("FontType2=\"" + element.getFont2().getName() + "\" ");
            this.out.print("FontStyle2=\"" + element.getFont2().getStyle() + "\" ");
            this.out.print("FontSize2=\"" + element.getFont2().getSize() + "\" ");
            if (element.getBgColor() != null) {
                this.out.print("BackgroundColor2=\"" + element.getBgColor2().getRGB() + "\" ");
            } else {
                this.out.print("BackgroundColor2=\"" + null + "\" ");
            }
            this.out.println("AlternateRow=\"" + element.getAlternateRow() + "\" ");
            this.writeAttribute(element, ROTATION);
            this.writeAttribute(element, BORDERCOLOR);
            this.writeAttribute(element, BORDERTHICKNESS);
            this.writeAttribute(element, ALIGNMENT);
            this.writeAttribute(element, ALIGNMENT_VERT);
            this.writeAttribute(element, WIDTH);
            this.writeAttribute(element, HEIGHT);
            this.out.println(">");
            for (ReportColumn element2 : this.report.column) {
                IFormat format;
                element = element2;
                if (element == null || (format = element.getDataFormat()) == null) continue;
                if (format instanceof StringFormat) {
                    this.out.println("    <String Format=\"" + XMLUtil.encodeXML(format.getTextFormat()) + "\" />");
                }
                if (format instanceof LogicalFormat) {
                    this.out.println("    <Logical Format=\"" + XMLUtil.encodeXML(format.getTextFormat()) + "\" />");
                }
                if (format instanceof NumericFormat) {
                    this.out.println("    <Numeric Format=\"" + XMLUtil.encodeXML(format.getTextFormat()) + "\" />");
                }
                if (format instanceof LocaleNumericFormat) {
                    this.out.println("    <LocaleNumeric Format=\"" + XMLUtil.encodeXML(format.getTextFormat()) + "\" />");
                }
                if (format instanceof DateTimeFormat) {
                    this.out.println("    <DateTime Format=\"" + XMLUtil.encodeXML(format.getTextFormat()) + "\" />");
                }
                if (!(format instanceof LocaleDateTimeFormat)) continue;
                this.out.println("    <LocaleDateTime Format=\"" + XMLUtil.encodeXML(format.getTextFormat()) + "\" />");
            }
            this.out.println("  </Column>");
        }
    }

    private void exportChart() {
        if (this.report != null && this.report.chartSetting != null && this.out != null) {
            ReportChartObject element = this.report.chartSetting;
            this.out.print(TAB);
            this.out.print("<Chart ");
            this.writeAttribute(element, BORDERCOLOR);
            this.writeAttribute(element, BORDERTHICKNESS);
            this.writeAttribute(element, ALIGNMENT);
            this.writeAttribute(element, WIDTH);
            this.writeAttribute(element, HEIGHT);
            this.out.println("/>");
        }
    }

    private void exportLine() {
        if (this.report != null && this.report.lineSetting != null && this.out != null) {
            ReportLine element = this.report.lineSetting;
            this.out.print(TAB);
            this.out.print("<Line ");
            this.writeAttribute(element, LENGTH);
            this.writeAttribute(element, THICKNESS);
            this.writeAttribute(element, LINESTYLE);
            this.writeAttribute(element, BACKGROUNDCOLOR);
            this.writeAttribute(element, MATCHCOLUMNWIDTHS);
            this.out.println("/>");
        }
    }

    private void exportGrid() {
        if (this.report != null && this.report.gridSetting != null && this.out != null) {
            ReportGrid element = this.report.gridSetting;
            this.out.print(TAB);
            this.out.print("<Grid ");
            this.writeAttribute(element, BORDERCOLOR);
            this.writeAttribute(element, BORDERTHICKNESS);
            this.writeAttribute(element, BACKGROUNDCOLOR);
            this.writeAttribute(element, LINESTYLE);
            this.writeAttribute(element, WIDTH);
            this.writeAttribute(element, HEIGHT);
            this.writeAttribute(element, RADIUS);
            this.writeAttribute(element, MATCHCOLUMNWIDTHS);
            this.out.println("/>");
        }
    }

    private void writeAttribute(ReportElement element, String Attr2) {
        if (this.out != null && element != null) {
            if (Attr2.equals(FONTCOLOR)) {
                this.out.print("FontColor=\"" + element.getFontColor().getRGB() + "\" ");
            } else if (Attr2.equals(FONTTYPE)) {
                this.out.print("FontType=\"" + element.getFont().getName() + "\" ");
            } else if (Attr2.equals(FONTSTYLE)) {
                this.out.print("FontStyle=\"" + element.getFont().getStyle() + "\" ");
            } else if (Attr2.equals(FONTSIZE)) {
                this.out.print("FontSize=\"" + element.getFont().getSize() + "\" ");
            } else if (Attr2.equals(BACKGROUNDCOLOR)) {
                String name = BACKGROUNDCOLOR;
                if (element instanceof ReportLine) {
                    name = "LineColor";
                }
                if (element.getBgColor() != null) {
                    this.out.print(name + "=\"" + element.getBgColor().getRGB() + "\" ");
                } else {
                    this.out.print(name + "=\"" + null + "\" ");
                }
            } else if (Attr2.equals(BORDERCOLOR)) {
                if (element.getBorderColor() != null) {
                    this.out.print("BorderColor=\"" + element.getBorderColor().getRGB() + "\" ");
                } else {
                    this.out.print("BorderColor=\"" + null + "\" ");
                }
            } else if (Attr2.equals(BORDERTHICKNESS)) {
                this.out.print("BorderThickness=\"" + element.getBorderThickness() + "\" ");
            } else if (Attr2.equals(ROTATION)) {
                this.out.print("Rotation=\"" + element.getRotateAngle() + "\" ");
            } else if (Attr2.equals(ALIGNMENT)) {
                this.out.print("Alignment=\"" + element.getAlign() + "\" ");
            } else if (Attr2.equals(ALIGNMENT_VERT)) {
                this.out.print("AlignmentVertical=\"" + element.getVAlign() + "\" ");
            } else if (Attr2.equals(WIDTH)) {
                this.out.print("Width=\"" + element.getWidth() + "\" ");
            } else if (Attr2.equals(HEIGHT)) {
                this.out.print("Height=\"" + element.getHeight() + "\" ");
            } else if (Attr2.equals(LENGTH)) {
                this.out.print("Length=\"" + element.getWidth() + "\" ");
            } else if (Attr2.equals(THICKNESS)) {
                this.out.print("Thickness=\"" + QbUtil.toPixel(element.getHeight() - 0.02) + "\" ");
            } else if (Attr2.equals(LINESTYLE)) {
                int lineStyle = 1;
                if (element instanceof ReportLine) {
                    lineStyle = ((ReportLine)element).getLineStyle();
                } else if (element instanceof ReportGrid) {
                    lineStyle = ((ReportGrid)element).getGridStyle();
                }
                String text = "solid";
                if (lineStyle == 2) {
                    text = "double";
                } else if (lineStyle == 3) {
                    text = "dash";
                }
                this.out.print("LineStyle=\"" + text + "\" ");
            } else if (Attr2.equals(AUTO_RESIZE)) {
                if (element instanceof ReportTitle) {
                    this.out.println("AutoResize=\"" + ((ReportTitle)element).autoResize + "\" ");
                }
            } else if (Attr2.equals(POSITION)) {
                if (element instanceof ReportTitle) {
                    this.out.println("Position=\"" + ((ReportTitle)element).position + "\" ");
                }
            } else if (Attr2.equals(MATCHCOLUMNWIDTHS)) {
                if (element instanceof ReportLine && !((ReportLine)element).isVertical()) {
                    this.out.println("MatchColumnWidthS=\"" + ((ReportLine)element).isMatchColumnWidths() + "\" ");
                } else if (element instanceof ReportGrid) {
                    this.out.println("MatchColumnWidthS=\"" + ((ReportGrid)element).isMatchColumnWidths() + "\" ");
                }
            }
        }
    }
}

