/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.globalformat.GlobalSetAlignmentPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetBackgroundColorPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetBorderColorPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetBorderThicknessPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetBoundsPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetDualColorsPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetFontColorPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetFontPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetFormatPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetLineStylePanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetRotationPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetScriptPanel;
import quadbase.reportdesigner.designer.globalformat.IGlobalSet;

public class GlobalFormatDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(GlobalFormatDialog.class.getName());
    private JButton okButton;
    private JButton closeButton;
    private ReportMain reportMain;
    private GlobalSetBoundsPanel setBoundsPanel = null;
    private GlobalSetAlignmentPanel setAlignmentPanel = null;
    private GlobalSetRotationPanel setRotationPanel = null;
    private GlobalSetBorderThicknessPanel setThicknessPanel = null;
    private GlobalSetBackgroundColorPanel setBackgroundColorPanel = null;
    private GlobalSetBorderColorPanel setBorderColorPanel = null;
    private GlobalSetFontColorPanel setFontColorPanel = null;
    private GlobalSetFontPanel setFontPanel = null;
    private GlobalSetFormatPanel setFormatPanel = null;
    private GlobalSetScriptPanel setScriptPanel = null;
    private GlobalSetDualColorsPanel globalSetDualColorsPanel = null;
    private GlobalSetLineStylePanel setLineStylePanel = null;
    private IGlobalSet currentTab;
    private int elementType;

    public GlobalFormatDialog(ReportMain reportMain, int elementType) {
        super(reportMain, LanguageEncoder.getText("Global") + " " + ReportElement.getElementTypeName(elementType) + " " + LanguageEncoder.getText("Format ..."), true);
        this.reportMain = reportMain;
        this.elementType = elementType;
        this.setDefaultCloseOperation(2);
        this.init();
        this.setPosition();
        this.setSize(new Dimension(770, 450));
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        JTabbedPane tabbedPane = new JTabbedPane();
        int idx = 0;
        this.setBoundsPanel = new GlobalSetBoundsPanel(this.reportMain, this.elementType);
        tabbedPane.insertTab(LanguageEncoder.getText("Set Bounds"), null, this.setBoundsPanel, null, idx++);
        if (this.elementType != 3 && this.elementType != 1 && this.elementType != 2 && this.elementType != 0) {
            this.setAlignmentPanel = new GlobalSetAlignmentPanel(this.reportMain, this.elementType);
            tabbedPane.insertTab(LanguageEncoder.getText("Alignment"), null, this.setAlignmentPanel, null, idx++);
        }
        if (this.elementType != 3 && this.elementType != 0) {
            this.setBackgroundColorPanel = new GlobalSetBackgroundColorPanel(this.reportMain, this.elementType);
            tabbedPane.insertTab(LanguageEncoder.getText(this.elementType == 2 ? "Line Color" : "Background Color"), null, this.setBackgroundColorPanel, null, idx++);
        }
        if (this.elementType != 3 && this.elementType != 1 && this.elementType != 2 && this.elementType != 0) {
            this.setFontColorPanel = new GlobalSetFontColorPanel(this.reportMain, this.elementType);
            tabbedPane.insertTab(LanguageEncoder.getText("Font Color"), null, this.setFontColorPanel, null, idx++);
            this.setFontPanel = new GlobalSetFontPanel(this.reportMain, this.elementType);
            tabbedPane.insertTab(LanguageEncoder.getText("Font Style and Size"), null, this.setFontPanel, null, idx++);
        }
        if (this.elementType != 2) {
            this.setThicknessPanel = new GlobalSetBorderThicknessPanel(this.reportMain, this.elementType);
            tabbedPane.insertTab(LanguageEncoder.getText("Border Thickness"), null, this.setThicknessPanel, null, idx++);
            this.setBorderColorPanel = new GlobalSetBorderColorPanel(this.reportMain, this.elementType);
            tabbedPane.insertTab(LanguageEncoder.getText("Border Color"), null, this.setBorderColorPanel, null, idx++);
        }
        if (this.elementType == 4 || this.elementType == 5) {
            this.setFormatPanel = new GlobalSetFormatPanel(this.reportMain, this.elementType);
            tabbedPane.insertTab(LanguageEncoder.getText("Data Format"), null, this.setFormatPanel, null, idx);
        }
        if (this.elementType == 4) {
            this.globalSetDualColorsPanel = new GlobalSetDualColorsPanel(this.reportMain);
            tabbedPane.insertTab(LanguageEncoder.getText("Dual Colors"), null, this.globalSetDualColorsPanel, null, idx++);
        }
        if (this.elementType != 13 && this.elementType != 0) {
            this.setScriptPanel = new GlobalSetScriptPanel(this.reportMain, this.elementType);
            tabbedPane.insertTab(LanguageEncoder.getText("Script"), null, this.setScriptPanel, null, idx++);
        }
        if (this.elementType != 13 && this.elementType != 3 && this.elementType != 1 && this.elementType != 2 && this.elementType != 0) {
            this.setRotationPanel = new GlobalSetRotationPanel(this.reportMain, this.elementType);
            tabbedPane.insertTab(LanguageEncoder.getText("Rotation"), null, this.setRotationPanel, null, idx++);
        }
        if (this.elementType != 0 && (this.elementType == 1 || this.elementType == 2)) {
            this.setLineStylePanel = new GlobalSetLineStylePanel(this.reportMain, this.elementType, true);
        }
        this.currentTab = this.setBoundsPanel;
        tabbedPane.addChangeListener(this);
        tabbedPane.setSelectedIndex(0);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", tabbedPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.closeButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.closeButton);
        contentPane.add("South", buttonPanel);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabbedPane;
        if (e.getSource() instanceof JTabbedPane && (tabbedPane = (JTabbedPane)e.getSource()).getSelectedComponent() != this.currentTab) {
            try {
                this.currentTab.verify();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to perform action", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
                tabbedPane.setSelectedComponent((JComponent)((Object)this.currentTab));
                return;
            }
            this.currentTab = (IGlobalSet)((Object)tabbedPane.getSelectedComponent());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.reportMain.createBackupReport();
            this.reportMain.menuBar.setUndoEnabled(false);
            try {
                if (this.setBoundsPanel != null) {
                    this.setBoundsPanel.apply();
                }
                if (this.setAlignmentPanel != null) {
                    this.setAlignmentPanel.apply();
                }
                if (this.setThicknessPanel != null) {
                    this.setThicknessPanel.apply();
                }
                if (this.setBackgroundColorPanel != null) {
                    this.setBackgroundColorPanel.apply();
                }
                if (this.setBorderColorPanel != null) {
                    this.setBorderColorPanel.apply();
                }
                if (this.setFontColorPanel != null) {
                    this.setFontColorPanel.apply();
                }
                if (this.setFontPanel != null) {
                    this.setFontPanel.apply();
                }
                if (this.setFormatPanel != null) {
                    this.setFormatPanel.apply();
                }
                if (this.globalSetDualColorsPanel != null) {
                    this.globalSetDualColorsPanel.apply();
                }
                if (this.setRotationPanel != null) {
                    this.setRotationPanel.apply();
                }
                if (this.setScriptPanel != null) {
                    this.setScriptPanel.apply();
                }
                if (this.setLineStylePanel != null) {
                    this.setLineStylePanel.apply();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to apply new settings", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
                this.setFontPanel.setDrawPreviewPanel(true);
                return;
            }
            this.reportMain.designPanel.rulerPanel.repaintPanel();
            this.reportMain.setModified();
            this.reportMain.menuBar.setUndoEnabled(true);
        }
        this.setVisible(false);
        this.dispose();
    }
}

