/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.report.Script;

public class GlobalScriptSelectionDialog
extends JDialog
implements ActionListener {
    JList scriptList;
    Vector<Script> scripts;
    String[] scriptNames;
    JButton okButton;
    JButton cancelButton;
    boolean modified;
    String selectedScript;

    public GlobalScriptSelectionDialog(JDialog dialog, Vector<Script> scripts) {
        super(dialog, LanguageEncoder.getText("select script"), true);
        this.scripts = scripts;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        if (this.scripts != null) {
            this.scriptNames = new String[this.scripts.size() + 1];
            for (int i = 0; i < this.scripts.size(); ++i) {
                this.scriptNames[i + 1] = this.scripts.elementAt(i).getName();
            }
        } else {
            this.scriptNames = new String[1];
        }
        this.scriptNames[0] = "None";
        this.scriptList = new JList<String>(this.scriptNames);
        JPanel p2 = new JPanel();
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        p2.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        p2.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new GridLayout(2, 1));
        contentPane.add(this.scriptList);
        contentPane.add(p2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            int index = this.scriptList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.selectedScript = this.scriptNames[index];
            this.modified = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getSelectedScript() {
        return this.selectedScript;
    }
}

