/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.globalformat.IGlobalSet;

public class GlobalSetAlignmentPanel
extends JPanel
implements IGlobalSet,
ItemListener {
    private ReportMain reportMain;
    private JRadioButton left;
    private JRadioButton center;
    private JRadioButton right;
    private JRadioButton top;
    private JRadioButton middle;
    private JRadioButton bottom;
    private boolean isModified = false;
    private JCheckBox apply = null;
    private int elementType;

    public GlobalSetAlignmentPanel(ReportMain reportMain, int elementType) {
        this.reportMain = reportMain;
        this.elementType = elementType;
        this.init();
    }

    private void init() {
        short tt;
        short t;
        JPanel p11 = new JPanel();
        p11.setBorder(new TitledBorder(LanguageEncoder.getText("Horizontal Alignment")));
        p11.setLayout(new FlowLayout());
        this.left = new JRadioButton(LanguageEncoder.getText("Left"), false);
        this.center = new JRadioButton(LanguageEncoder.getText("Center"), false);
        this.right = new JRadioButton(LanguageEncoder.getText("Right"), false);
        JPanel p12 = new JPanel();
        p12.setBorder(new TitledBorder(LanguageEncoder.getText("Vertical Alignment")));
        p12.setLayout(new FlowLayout());
        this.top = new JRadioButton(LanguageEncoder.getText("Top"), false);
        this.middle = new JRadioButton(LanguageEncoder.getText("Middle"), false);
        this.bottom = new JRadioButton(LanguageEncoder.getText("Bottom"), false);
        if (this.elementType == 6) {
            t = this.reportMain.report.labelSetting.getAlign();
            tt = this.reportMain.report.labelSetting.getVAlign();
        } else if (this.elementType == 12) {
            t = this.reportMain.report.columnHeaderSetting.getAlign();
            tt = this.reportMain.report.columnHeaderSetting.getVAlign();
        } else if (this.elementType == 13) {
            t = this.reportMain.report.titleSetting.getAlign();
            tt = this.reportMain.report.titleSetting.getVAlign();
        } else if (this.elementType == 5) {
            t = this.reportMain.report.stringFormulaSetting.getAlign();
            tt = this.reportMain.report.stringFormulaSetting.getVAlign();
        } else {
            t = this.reportMain.report.stringColumnSetting.getAlign();
            tt = this.reportMain.report.stringColumnSetting.getVAlign();
        }
        if (t == 1) {
            this.left.setSelected(true);
        } else if (t == 0) {
            this.center.setSelected(true);
        } else {
            this.right.setSelected(true);
        }
        if (tt == 1) {
            this.top.setSelected(true);
        } else if (tt == 0) {
            this.middle.setSelected(true);
        } else {
            this.bottom.setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.left);
        group.add(this.center);
        group.add(this.right);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.top);
        group2.add(this.middle);
        group2.add(this.bottom);
        p11.add(this.left);
        p11.add(this.center);
        p11.add(this.right);
        p12.add(this.top);
        p12.add(this.middle);
        p12.add(this.bottom);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add("North", p11);
        p1.add("Center", p12);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        this.apply = new JCheckBox(LanguageEncoder.getText("Apply Property"));
        p2.add(this.apply);
        this.left.addItemListener(this);
        this.center.addItemListener(this);
        this.right.addItemListener(this);
        this.top.addItemListener(this);
        this.middle.addItemListener(this);
        this.bottom.addItemListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Alignment...")));
        this.add("Center", p1);
        this.add("South", p2);
    }

    public short getSelection() {
        if (this.left.isSelected()) {
            return 1;
        }
        if (this.center.isSelected()) {
            return 0;
        }
        if (this.right.isSelected()) {
            return 2;
        }
        return 0;
    }

    public short getSelection2() {
        if (this.top.isSelected()) {
            return 1;
        }
        if (this.middle.isSelected()) {
            return 0;
        }
        if (this.bottom.isSelected()) {
            return 2;
        }
        return 0;
    }

    boolean isModified() {
        return this.isModified;
    }

    private void setValues(ReportElement elt, short align, short valign) {
        elt.setAlign(align);
        elt.setVAlign(valign);
        this.isModified = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.apply.setSelected(true);
    }

    public void setLabelAlignment(short align, short valign) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (!(relt instanceof ReportSection)) continue;
            ReportElement[] rc = ((ReportSection)relt).getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Label");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                this.setValues(t, align, valign);
            }
        }
        this.setValues(this.reportMain.report.labelSetting, align, valign);
    }

    public void setTitleAlignment(short align, short valign) {
        ReportSection section = this.reportMain.report.getReportHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "Title");
        for (int j = 0; j < temp.size(); ++j) {
            ReportElement t = (ReportElement)temp.elementAt(j);
            this.setValues(t, align, valign);
        }
        this.setValues(this.reportMain.report.titleSetting, align, valign);
    }

    public void setColumnHeaderAlignment(short align, short valign) {
        ReportElement t;
        int j;
        ReportTable table = this.reportMain.report.getReportTables().elementAt(0);
        ReportSection section = table.getHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
        for (j = 0; j < temp.size(); ++j) {
            t = (ReportElement)temp.elementAt(j);
            this.setValues(t, align, valign);
        }
        if (this.reportMain.report.getReportType() == 3 || this.reportMain.report.getReportType() == 1) {
            if (((ReportTreeTable)table).getSubTable().size() > 0) {
                section = ((ReportTreeTable)table).getSubTable(0).getHeader();
            }
            rc = section.getData();
            temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
            for (j = 0; j < temp.size(); ++j) {
                t = (ReportElement)temp.elementAt(j);
                this.setValues(t, align, valign);
            }
            section = table.getMasterSection();
            if (section != null) {
                temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
                for (j = 0; j < temp.size(); ++j) {
                    t = (ReportElement)temp.elementAt(j);
                    this.setValues(t, align, valign);
                }
            }
        }
        this.setValues(this.reportMain.report.columnHeaderSetting, align, valign);
    }

    public void setFormulaAlignment(short align, short valign) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportSection rs;
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (relt instanceof ReportSection) {
                ReportElement[] rc = ((ReportSection)relt).getData();
                Vector<Object> temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "Formula");
                for (int j = 0; j < temp.size(); ++j) {
                    ReportElement t = (ReportElement)temp.elementAt(j);
                    this.setValues(t, align, valign);
                }
                continue;
            }
            if (!(relt instanceof ReportTable) || (rs = ((ReportTable)relt).getMasterSection()) == null) continue;
            ReportElement[] rc = rs.getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Formula");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                this.setValues(t, align, valign);
            }
        }
        ReportCell[] formula = this.reportMain.report.formula;
        for (int j = 0; j < Array.getLength(this.reportMain.report.formula); ++j) {
            this.setValues(formula[j], align, valign);
        }
    }

    public void setColumnAlignment(short align, short valign) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) continue;
            ReportTable relt = elt.getOriginalReportTable();
            ReportElement[] rc = relt.getColumn();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Column");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                this.setValues(t, align, valign);
            }
        }
        ReportColumn[] column = this.reportMain.report.column;
        for (int j = 0; j < Array.getLength(this.reportMain.report.column); ++j) {
            this.setValues(column[j], align, valign);
        }
    }

    @Override
    public void verify() {
    }

    @Override
    public void apply() {
        if (!this.apply.isSelected()) {
            return;
        }
        short align = this.getSelection();
        short valign = this.getSelection2();
        if (this.elementType == 6) {
            this.setLabelAlignment(align, valign);
        } else if (this.elementType == 12) {
            this.setColumnHeaderAlignment(align, valign);
        } else if (this.elementType == 13) {
            this.setTitleAlignment(align, valign);
        } else if (this.elementType == 5) {
            this.setFormulaAlignment(align, valign);
        } else {
            this.setColumnAlignment(align, valign);
        }
    }
}

