/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.ColorButton;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ColorDialog;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.globalformat.IGlobalSet;

public class GlobalSetBackgroundColorPanel
extends JPanel
implements IGlobalSet,
ActionListener,
ItemListener {
    private ColorButton colorButton;
    private JCheckBox transparentCheck;
    private ReportMain reportMain;
    private Color currentColor;
    private boolean isTransparent;
    private JCheckBox apply;
    private int elementType;

    public GlobalSetBackgroundColorPanel(ReportMain reportMain, int elementType) {
        this.reportMain = reportMain;
        this.elementType = elementType;
        this.currentColor = null;
        this.init();
    }

    private void init() {
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        p1.add(new JLabel(LanguageEncoder.getText("Current Color :")));
        this.colorButton = new ColorButton(LanguageEncoder.getText("Click"));
        p1.add(this.colorButton);
        Color c = this.elementType == 6 ? this.reportMain.report.labelSetting.getBgColor() : (this.elementType == 12 ? this.reportMain.report.columnHeaderSetting.getBgColor() : (this.elementType == 13 ? this.reportMain.report.titleSetting.getBgColor() : (this.elementType == 5 ? this.reportMain.report.stringFormulaSetting.getBgColor() : (this.elementType == 4 ? this.reportMain.report.stringColumnSetting.getBgColor() : (this.elementType == 2 ? this.reportMain.report.lineSetting.getBgColor() : (this.elementType == 1 ? this.reportMain.report.gridSetting.getBgColor() : null))))));
        this.isTransparent = c == null;
        this.transparentCheck = new JCheckBox(LanguageEncoder.getText("Transparent"), this.isTransparent);
        p1.add(this.transparentCheck);
        this.colorButton.setEnabled(!this.isTransparent);
        this.setColor(c);
        this.currentColor = c;
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        this.apply = new JCheckBox(LanguageEncoder.getText("Apply Property"));
        p2.add(this.apply);
        this.colorButton.addActionListener(this);
        this.transparentCheck.addItemListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Set Color ...")));
        this.add("Center", p1);
        this.add("South", p2);
    }

    public Color getColor() {
        if (this.isTransparent) {
            return null;
        }
        return this.currentColor;
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.colorButton.setColor(color);
        this.reportMain.addRecentColor(color);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.colorButton.setEnabled(!this.transparentCheck.isSelected());
        this.apply.setSelected(true);
    }

    public void setLabelBackground(Color color) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (!(relt instanceof ReportSection)) continue;
            ReportElement[] rc = ((ReportSection)relt).getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Label");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setBgColor(color);
            }
        }
        this.reportMain.report.labelSetting.setBgColor(color);
    }

    public void setTitleBackground(Color color) {
        ReportSection section = this.reportMain.report.getReportHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "Title");
        for (int j = 0; j < temp.size(); ++j) {
            ReportElement t = (ReportElement)temp.elementAt(j);
            t.setBgColor(color);
        }
        this.reportMain.report.titleSetting.setBgColor(color);
    }

    public void setColumnHeaderBackground(Color color) {
        ReportElement t;
        int j;
        ReportTable table = this.reportMain.report.getReportTables().elementAt(0);
        ReportSection section = table.getHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
        for (j = 0; j < temp.size(); ++j) {
            t = (ReportElement)temp.elementAt(j);
            t.setBgColor(color);
        }
        if (this.reportMain.report.getReportType() == 3 || this.reportMain.report.getReportType() == 1) {
            if (((ReportTreeTable)table).getSubTable().size() > 0) {
                section = ((ReportTreeTable)table).getSubTable(0).getHeader();
            }
            rc = section.getData();
            temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
            for (j = 0; j < temp.size(); ++j) {
                t = (ReportElement)temp.elementAt(j);
                t.setBgColor(color);
            }
            section = table.getMasterSection();
            if (section != null) {
                rc = section.getData();
                temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
                for (j = 0; j < temp.size(); ++j) {
                    t = (ReportElement)temp.elementAt(j);
                    t.setBgColor(color);
                }
            }
        }
        this.reportMain.report.columnHeaderSetting.setBgColor(color);
    }

    public void setFormulaBackground(Color color) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportSection rs;
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (relt instanceof ReportSection) {
                ReportElement[] rc = ((ReportSection)relt).getData();
                Vector<Object> temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "Formula");
                for (int j = 0; j < temp.size(); ++j) {
                    ReportElement t = (ReportElement)temp.elementAt(j);
                    t.setBgColor(color);
                }
                continue;
            }
            if (!(relt instanceof ReportTable) || (rs = ((ReportTable)relt).getMasterSection()) == null) continue;
            ReportElement[] rc = rs.getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Formula");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setBgColor(color);
            }
        }
        ReportCell[] formula = this.reportMain.report.formula;
        for (int j = 0; j < Array.getLength(this.reportMain.report.formula); ++j) {
            formula[j].setBgColor(color);
        }
    }

    public void setColumnBackground(Color color) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) continue;
            ReportTable relt = elt.getOriginalReportTable();
            ReportElement[] rc = relt.getColumn();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Column");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setBgColor(color);
            }
        }
        ReportColumn[] column = this.reportMain.report.column;
        for (int j = 0; j < Array.getLength(this.reportMain.report.column); ++j) {
            column[j].setBgColor(color);
        }
    }

    public void setLineBackground(Color color) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "ReportLine");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "ReportLine");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                if (t instanceof GuideLine) continue;
                t.setBgColor(color);
            }
        }
        this.reportMain.report.lineSetting.setBgColor(color);
    }

    public void setGridBackground(Color color) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "ReportGrid");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "ReportGrid");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setBgColor(color);
            }
        }
        this.reportMain.report.gridSetting.setBgColor(color);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.colorButton) {
            this.apply.setSelected(true);
            Color initColor = Color.lightGray;
            if (this.currentColor != null) {
                initColor = this.currentColor;
            }
            this.currentColor = ColorDialog.showDialog(this.reportMain, LanguageEncoder.getText("Set Background Color..."), initColor);
            this.setColor(this.currentColor);
            return;
        }
    }

    @Override
    public void verify() {
    }

    @Override
    public void apply() {
        if (!this.apply.isSelected()) {
            return;
        }
        this.isTransparent = this.transparentCheck.isSelected();
        this.currentColor = this.colorButton.getColor();
        if (this.elementType == 6) {
            this.setLabelBackground(this.getColor());
        } else if (this.elementType == 12) {
            this.setColumnHeaderBackground(this.getColor());
        } else if (this.elementType == 13) {
            this.setTitleBackground(this.getColor());
        } else if (this.elementType == 5) {
            this.setFormulaBackground(this.getColor());
        } else if (this.elementType == 4) {
            this.setColumnBackground(this.getColor());
        } else if (this.elementType == 2) {
            this.setLineBackground(this.getColor());
        } else if (this.elementType == 1) {
            this.setGridBackground(this.getColor());
        }
    }
}

