/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.lang.reflect.Array;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.globalformat.IGlobalSet;

public class GlobalSetBorderThicknessPanel
extends JPanel
implements IGlobalSet,
InputMethodListener,
CaretListener {
    private static final Logger LOGGER = Logger.getLogger(GlobalSetBorderThicknessPanel.class.getName());
    private ReportMain reportMain;
    private int borderThickness;
    private JTextField borderThicknessField;
    private JCheckBox apply = null;
    private boolean initializing = false;
    private int elementType;

    public GlobalSetBorderThicknessPanel(ReportMain reportMain, int elementType) {
        this.reportMain = reportMain;
        this.elementType = elementType;
        if (elementType == 6) {
            this.borderThickness = reportMain.report.labelSetting.getBorderThickness();
        }
        if (elementType == 12) {
            this.borderThickness = reportMain.report.columnHeaderSetting.getBorderThickness();
        }
        if (elementType == 13) {
            this.borderThickness = reportMain.report.titleSetting.getBorderThickness();
        }
        if (elementType == 5) {
            this.borderThickness = reportMain.report.stringFormulaSetting.getBorderThickness();
        }
        if (elementType == 4) {
            this.borderThickness = reportMain.report.stringColumnSetting.getBorderThickness();
        }
        if (elementType == 3) {
            this.borderThickness = reportMain.report.imageSetting.getBorderThickness();
        }
        if (elementType == 0) {
            this.borderThickness = reportMain.report.chartSetting.getBorderThickness();
        }
        if (elementType == 1) {
            this.borderThickness = reportMain.report.gridSetting.getBorderThickness();
        }
        this.init();
    }

    private void init() {
        this.initializing = true;
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        p1.add(new JLabel(LanguageEncoder.getText("Thickness")));
        this.borderThicknessField = new JTextField(3);
        p1.add(this.borderThicknessField);
        this.borderThicknessField.setText(this.borderThickness + "");
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        this.apply = new JCheckBox(LanguageEncoder.getText("Apply Property"));
        p2.add(this.apply);
        this.borderThicknessField.addInputMethodListener(this);
        this.borderThicknessField.addCaretListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Border")));
        this.add("Center", p1);
        this.add("South", p2);
        this.initializing = false;
    }

    public void setLabelThickness(int thickness) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (!(relt instanceof ReportSection)) continue;
            ReportElement[] rc = ((ReportSection)relt).getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Label");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setBorderThickness(thickness);
            }
        }
        this.reportMain.report.labelSetting.setBorderThickness(thickness);
    }

    public void setColumnHeaderThickness(int thickness) {
        ReportElement t;
        int j;
        ReportTable table = this.reportMain.report.getReportTables().elementAt(0);
        ReportSection section = table.getHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
        for (j = 0; j < temp.size(); ++j) {
            t = (ReportElement)temp.elementAt(j);
            t.setBorderThickness(thickness);
        }
        if (this.reportMain.report.getReportType() == 3 || this.reportMain.report.getReportType() == 1) {
            if (((ReportTreeTable)table).getSubTable().size() > 0) {
                section = ((ReportTreeTable)table).getSubTable(0).getHeader();
            }
            rc = section.getData();
            temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
            for (j = 0; j < temp.size(); ++j) {
                t = (ReportElement)temp.elementAt(j);
                t.setBorderThickness(thickness);
            }
            section = table.getMasterSection();
            if (section != null) {
                rc = section.getData();
                temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
                for (j = 0; j < temp.size(); ++j) {
                    t = (ReportElement)temp.elementAt(j);
                    t.setBorderThickness(thickness);
                }
            }
        }
        this.reportMain.report.columnHeaderSetting.setBorderThickness(thickness);
    }

    public void setFormulaThickness(int thickness) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportSection rs;
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (relt instanceof ReportSection) {
                ReportElement[] rc = ((ReportSection)relt).getData();
                Vector<Object> temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "Formula");
                for (int j = 0; j < temp.size(); ++j) {
                    ReportElement t = (ReportElement)temp.elementAt(j);
                    t.setBorderThickness(thickness);
                }
                continue;
            }
            if (!(relt instanceof ReportTable) || (rs = ((ReportTable)relt).getMasterSection()) == null) continue;
            ReportElement[] rc = rs.getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Formula");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setBorderThickness(thickness);
            }
        }
        ReportCell[] formula = this.reportMain.report.formula;
        for (int j = 0; j < Array.getLength(this.reportMain.report.formula); ++j) {
            formula[j].setBorderThickness(thickness);
        }
    }

    public void setTitleThickness(int thickness) {
        ReportSection section = this.reportMain.report.getReportHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "Title");
        for (int j = 0; j < temp.size(); ++j) {
            ReportElement t = (ReportElement)temp.elementAt(j);
            t.setBorderThickness(thickness);
        }
        this.reportMain.report.titleSetting.setBorderThickness(thickness);
    }

    public void setColumnThickness(int thickness) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) continue;
            ReportTable relt = elt.getOriginalReportTable();
            ReportElement[] rc = relt.getColumn();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Column");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setBorderThickness(thickness);
            }
        }
        ReportColumn[] column = this.reportMain.report.column;
        for (int j = 0; j < Array.getLength(this.reportMain.report.column); ++j) {
            column[j].setBorderThickness(thickness);
        }
    }

    public void setImageThickness(int thickness) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "Image");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "Image");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setBorderThickness(thickness);
            }
        }
        this.reportMain.report.imageSetting.setBorderThickness(thickness);
    }

    public void setChartThickness(int thickness) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "Chart");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "Chart");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setBorderThickness(thickness);
            }
        }
        this.reportMain.report.chartSetting.setBorderThickness(thickness);
    }

    public void setGridThickness(int thickness) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "ReportGrid");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "ReportGrid");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setBorderThickness(thickness);
            }
        }
        this.reportMain.report.gridSetting.setBorderThickness(thickness);
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent e) {
        if (this.initializing) {
            return;
        }
        this.apply.setSelected(true);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.initializing) {
            return;
        }
        this.apply.setSelected(true);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent e) {
    }

    @Override
    public void verify() throws Exception {
        try {
            Integer.parseInt(this.borderThicknessField.getText());
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Invalid number", ex);
            throw new Exception(LanguageEncoder.getText("Value must be an integer."));
        }
    }

    @Override
    public void apply() throws Exception {
        if (!this.apply.isSelected()) {
            return;
        }
        this.borderThickness = Integer.parseInt(this.borderThicknessField.getText());
        if (this.borderThickness < 0) {
            this.borderThicknessField.setText("0");
            this.borderThickness = 0;
        }
        if (this.elementType == 6) {
            this.setLabelThickness(this.borderThickness);
        }
        if (this.elementType == 12) {
            this.setColumnHeaderThickness(this.borderThickness);
        }
        if (this.elementType == 13) {
            this.setTitleThickness(this.borderThickness);
        }
        if (this.elementType == 5) {
            this.setFormulaThickness(this.borderThickness);
        }
        if (this.elementType == 4) {
            this.setColumnThickness(this.borderThickness);
        }
        if (this.elementType == 3) {
            this.setImageThickness(this.borderThickness);
        }
        if (this.elementType == 0) {
            this.setChartThickness(this.borderThickness);
        }
        if (this.elementType == 1) {
            this.setGridThickness(this.borderThickness);
        }
    }
}

