/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Array;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTitle;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.GridLine;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.globalformat.IGlobalSet;

public class GlobalSetBoundsPanel
extends JPanel
implements IGlobalSet,
InputMethodListener,
CaretListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(GlobalSetBoundsPanel.class.getName());
    private ReportMain reportMain;
    private JTextField widthField;
    private JTextField heightField;
    private JTextField radiusField;
    private JCheckBox selection;
    private JCheckBox matchColumnWidthsBox;
    private JCheckBox autoSizeBox;
    private JRadioButton pOff;
    private JRadioButton pLeft;
    private JRadioButton pCenter;
    private JRadioButton pRight;
    private boolean isModified = false;
    private JCheckBox apply;
    private boolean imported = false;
    private boolean initializing = false;
    private int elementType;

    public GlobalSetBoundsPanel(ReportMain reportMain, int elementType) {
        this.reportMain = reportMain;
        this.elementType = elementType;
        this.init();
    }

    private void init() {
        JPanel checkBoxPanel;
        this.initializing = true;
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Dimension ...")));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(0, 1));
        this.widthField = new JTextField(7);
        mainPanel.add(this.widthField);
        this.heightField = new JTextField(7);
        mainPanel.add(this.heightField);
        this.radiusField = new JTextField(7);
        String l1 = LanguageEncoder.getText("(in inches)");
        if (this.reportMain.isCm) {
            l1 = LanguageEncoder.getText("(in cms)");
        }
        if (this.elementType == 2) {
            labelPanel.add(new JLabel(LanguageEncoder.getText("Length") + " " + l1 + " "));
            labelPanel.add(new JLabel(LanguageEncoder.getText("Thickness")));
        } else {
            labelPanel.add(new JLabel(LanguageEncoder.getText("Width") + " " + l1 + " "));
            labelPanel.add(new JLabel(LanguageEncoder.getText("Height") + " " + l1 + " "));
        }
        if (this.elementType == 1) {
            mainPanel.add(this.radiusField);
            this.radiusField.addInputMethodListener(this);
            labelPanel.add(new JLabel(LanguageEncoder.getText("Radius") + " " + l1 + " "));
        }
        p1.add("West", labelPanel);
        p1.add("East", mainPanel);
        if (this.elementType == 2 || this.elementType == 1) {
            checkBoxPanel = new JPanel(new FlowLayout(0));
            boolean match = false;
            this.matchColumnWidthsBox = new JCheckBox(LanguageEncoder.getText("Match Column Widths"), match);
            checkBoxPanel.add(this.matchColumnWidthsBox);
            match = this.elementType == 2 ? this.reportMain.report.lineSetting.isMatchColumnWidths() : this.reportMain.report.gridSetting.isMatchColumnWidths();
            p1.add("South", checkBoxPanel);
        } else if (this.elementType == 13) {
            checkBoxPanel = new JPanel(new FlowLayout(0));
            boolean b = this.reportMain.report.titleSetting.autoResize;
            this.autoSizeBox = new JCheckBox(LanguageEncoder.getText("Auto Size"), b);
            checkBoxPanel.add(this.autoSizeBox);
            p1.add("South", this.autoSizeBox);
        }
        if (this.elementType == 3) {
            boolean isSelected = this.reportMain.report.isApplyBoundSelected();
            this.selection = new JCheckBox(LanguageEncoder.getText("Default Size"), !isSelected);
            p1.add("South", this.selection);
        }
        this.widthField.addInputMethodListener(this);
        this.heightField.addInputMethodListener(this);
        this.widthField.addCaretListener(this);
        this.heightField.addCaretListener(this);
        this.radiusField.addCaretListener(this);
        if (this.selection != null) {
            this.selection.addItemListener(this);
        }
        if (this.matchColumnWidthsBox != null) {
            this.matchColumnWidthsBox.addItemListener(this);
        }
        if (this.autoSizeBox != null) {
            this.autoSizeBox.addItemListener(this);
        }
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Bounds ...")));
        this.add("North", p1);
        if (this.elementType == 13) {
            JPanel p13 = new JPanel(new FlowLayout());
            p13.setBorder(new TitledBorder(LanguageEncoder.getText("Auto Position")));
            this.pOff = new JRadioButton(LanguageEncoder.getText("Off"), false);
            this.pLeft = new JRadioButton(LanguageEncoder.getText("Left"), false);
            this.pCenter = new JRadioButton(LanguageEncoder.getText("Center"), false);
            this.pRight = new JRadioButton(LanguageEncoder.getText("Right"), false);
            int p = this.reportMain.report.titleSetting.position;
            if (p == 0) {
                this.pOff.setSelected(true);
            }
            if (p == 2) {
                this.pCenter.setSelected(true);
            }
            if (p == 1) {
                this.pLeft.setSelected(true);
            }
            if (p == 3) {
                this.pRight.setSelected(true);
            }
            p13.add(this.pOff);
            p13.add(this.pLeft);
            p13.add(this.pCenter);
            p13.add(this.pRight);
            ButtonGroup group3 = new ButtonGroup();
            group3.add(this.pOff);
            group3.add(this.pLeft);
            group3.add(this.pCenter);
            group3.add(this.pRight);
            this.add("Center", p13);
            this.pOff.addItemListener(this);
            this.pLeft.addItemListener(this);
            this.pCenter.addItemListener(this);
            this.pRight.addItemListener(this);
        }
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout(0));
        this.apply = new JCheckBox(LanguageEncoder.getText("Apply Property"));
        p3.add(this.apply);
        this.add("South", p3);
        if (this.elementType == 6) {
            this.setField(this.reportMain.report.labelSetting);
        } else if (this.elementType == 12) {
            this.setField(this.reportMain.report.columnHeaderSetting);
        } else if (this.elementType == 13) {
            this.setField(this.reportMain.report.titleSetting);
        } else if (this.elementType == 5) {
            this.setField(this.reportMain.report.stringFormulaSetting);
        } else if (this.elementType == 4) {
            this.setField(this.reportMain.report.stringColumnSetting);
        } else if (this.elementType == 0) {
            this.setField(this.reportMain.report.chartSetting);
        } else if (this.elementType == 3) {
            this.setField(this.reportMain.report.imageSetting);
        } else if (this.elementType == 1) {
            this.setField(this.reportMain.report.gridSetting);
        } else if (this.elementType == 2) {
            this.setField(this.reportMain.report.lineSetting);
        }
        this.initializing = false;
    }

    void setField(ReportElement elt) {
        double multipler = 1.0;
        if (this.reportMain.isCm) {
            multipler = 2.54;
        }
        String width = this.setFractionDigits((int)Math.round(elt.getWidth() * multipler * 100.0));
        String height = this.setFractionDigits((int)Math.round(elt.getHeight() * multipler * 100.0));
        if (this.elementType == 2 || this.imported) {
            height = QbUtil.toPixel(elt.getHeight() - 0.02) + "";
        }
        this.widthField.setText(width);
        this.heightField.setText(height);
        if (elt instanceof ReportLine) {
            if (this.elementType == -1) {
                this.matchColumnWidthsBox = new JCheckBox(LanguageEncoder.getText("Match Column Width"));
                this.matchColumnWidthsBox.addItemListener(this);
            }
            boolean matchColumnWidths = ((ReportLine)elt).isMatchColumnWidths();
            this.matchColumnWidthsBox.setSelected(matchColumnWidths);
            this.widthField.setEnabled(!matchColumnWidths);
            this.widthField.setText("-1.0");
        }
        if (elt instanceof ReportGrid) {
            if (this.elementType == -1) {
                this.matchColumnWidthsBox = new JCheckBox(LanguageEncoder.getText("Match Column Width"));
            }
            this.matchColumnWidthsBox.setSelected(((ReportGrid)elt).isMatchColumnWidths());
        }
        if (elt instanceof ReportTitle) {
            if (this.elementType == -1) {
                this.autoSizeBox = new JCheckBox(LanguageEncoder.getText("Auto Size"));
                this.pOff = new JRadioButton(LanguageEncoder.getText("Off"), false);
                this.pLeft = new JRadioButton(LanguageEncoder.getText("Left"), false);
                this.pCenter = new JRadioButton(LanguageEncoder.getText("Center"), false);
                this.pRight = new JRadioButton(LanguageEncoder.getText("Right"), false);
            }
            this.autoSizeBox.setSelected(((ReportTitle)elt).autoResize);
            if (((ReportTitle)elt).position == 0) {
                this.pOff.setSelected(true);
            }
            if (((ReportTitle)elt).position == 1) {
                this.pLeft.setSelected(true);
            }
            if (((ReportTitle)elt).position == 2) {
                this.pCenter.setSelected(true);
            }
            if (((ReportTitle)elt).position == 3) {
                this.pRight.setSelected(true);
            }
        }
    }

    private int getPosition() {
        if (this.pOff != null && this.pOff.isSelected()) {
            return 0;
        }
        if (this.pLeft != null && this.pLeft.isSelected()) {
            return 1;
        }
        if (this.pCenter != null && this.pCenter.isSelected()) {
            return 2;
        }
        if (this.pRight != null && this.pRight.isSelected()) {
            return 3;
        }
        return 0;
    }

    boolean isModified() {
        return this.isModified;
    }

    private void setValues(ReportElement elt) throws Exception {
        double multiplier = 1.0;
        if (this.reportMain.isCm) {
            multiplier = 0.39370078740157477;
        }
        try {
            double w = Double.parseDouble(this.widthField.getText()) * multiplier;
            double h = Double.parseDouble(this.heightField.getText()) * multiplier;
            if (elt instanceof ReportLine) {
                if (((ReportLine)elt).isVertical()) {
                    elt.setHeight(w);
                    elt.setWidth(QbUtil.toInch(Double.parseDouble(this.heightField.getText())) + 0.02);
                } else {
                    if (w > 0.0) {
                        elt.setWidth(w);
                    } else {
                        this.matchColumnWidthsBox.setSelected(true);
                    }
                    elt.setHeight(QbUtil.toInch(Double.parseDouble(this.heightField.getText())) + 0.02);
                    ((ReportLine)elt).setMatchColumnWidths(this.matchColumnWidthsBox.isSelected());
                }
                if (GlobalSetBoundsPanel.gridSpansMultiSection((ReportLine)elt)) {
                    Vector<JPanel> vec = this.reportMain.designPanel.rulerPanel.getVisiblePanel();
                    ReportLine cell = (ReportLine)ReportElementPanel.getHeadNode(elt, vec);
                    boolean isVertical = cell.isVertical();
                    if (isVertical) {
                        h = w;
                        w = QbUtil.toInch(Double.parseDouble(this.heightField.getText())) + 0.02;
                    } else {
                        h = QbUtil.toInch(Double.parseDouble(this.heightField.getText())) + 0.02;
                    }
                    GridLine gl = new GridLine(vec);
                    int panelIdx = ReportElementPanel.getPanel(cell, vec);
                    if (panelIdx < 0) {
                        return;
                    }
                    ReportCell newCell = gl.set(panelIdx, QbUtil.toPixel(cell.getX()), QbUtil.toPixel(cell.getY()), QbUtil.toPixel(w + cell.getX()), QbUtil.toPixel(h + cell.getY()), true, isVertical, cell);
                    gl.remove(cell);
                    elt = newCell;
                }
            } else if (elt instanceof ReportGrid) {
                elt.setWidth(w);
                elt.setHeight(h);
                ((ReportGrid)elt).setMatchColumnWidths(this.matchColumnWidthsBox.isSelected());
                if (GlobalSetBoundsPanel.gridSpansMultiSection((ReportGrid)elt)) {
                    Vector<JPanel> vec = this.reportMain.designPanel.rulerPanel.getVisiblePanel();
                    ReportGrid cell = (ReportGrid)ReportElementPanel.getHeadNode(elt, vec);
                    GridLine gl = new GridLine(vec);
                    int panelIdx = ReportElementPanel.getPanel(cell, vec);
                    if (panelIdx < 0) {
                        return;
                    }
                    ReportCell newCell = gl.set(panelIdx, QbUtil.toPixel(cell.getX()), QbUtil.toPixel(cell.getY()), QbUtil.toPixel(w + cell.getX()), QbUtil.toPixel(h + cell.getY()), false, false, cell);
                    gl.remove(cell);
                    elt = newCell;
                }
            } else if (elt instanceof ReportTitle) {
                if (this.autoSizeBox != null) {
                    ((ReportTitle)elt).autoResize = this.autoSizeBox.isSelected();
                }
                ((ReportTitle)elt).position = this.getPosition();
                elt.setWidth(w);
                elt.setHeight(h);
            } else {
                elt.setWidth(w);
                elt.setHeight(h);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to set report element values", ex);
            throw new Exception(LanguageEncoder.getText("Please input numeric values only."));
        }
        this.isModified = true;
    }

    private static boolean gridSpansMultiSection(ReportGrid grid) {
        ReportGrid head = grid.getHeadNode();
        return head.next() != null;
    }

    private static boolean gridSpansMultiSection(ReportLine line) {
        ReportLine head = line.getHeadNode();
        return head.next() != null;
    }

    private void setGridLineSettingsValue(ReportElement elt) throws Exception {
        double h;
        double w;
        double multipler = 1.0;
        if (this.reportMain.isCm) {
            multipler = 0.39370078740157477;
        }
        try {
            w = Double.parseDouble(this.widthField.getText()) * multipler;
            h = Double.parseDouble(this.heightField.getText()) * multipler;
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Field dimensions: Invalid number", ex);
            throw new Exception(LanguageEncoder.getText("Please input numeric values only."));
        }
        if (elt instanceof ReportLine) {
            boolean isVertical = ((ReportLine)elt).isVertical();
            if (isVertical) {
                elt.setHeight(w);
                elt.setWidth(QbUtil.toInch(Double.parseDouble(this.heightField.getText())) + 0.02);
            } else {
                elt.setWidth(w);
                elt.setHeight(QbUtil.toInch(Double.parseDouble(this.heightField.getText())) + 0.02);
                ((ReportLine)elt).setMatchColumnWidths(this.matchColumnWidthsBox.isSelected());
            }
        } else if (elt instanceof ReportGrid) {
            elt.setWidth(w);
            elt.setHeight(h);
            ((ReportGrid)elt).setMatchColumnWidths(this.matchColumnWidthsBox.isSelected());
        }
        this.isModified = true;
    }

    private String setFractionDigits(int v) {
        String t = Integer.toString(v);
        if (t.endsWith("0")) {
            double d = (double)v / 100.0;
            t = Double.toString(d).concat("0");
            return t;
        }
        double d = (double)v / 100.0;
        t = Double.toString(d);
        return t;
    }

    public void setLabelBounds() throws Exception {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (!(relt instanceof ReportSection)) continue;
            ReportElement[] rc = ((ReportSection)relt).getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Label");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                this.setValues(t);
            }
        }
        this.setValues(this.reportMain.report.labelSetting);
    }

    public void setTitleBounds() throws Exception {
        ReportSection section = this.reportMain.report.getReportHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "Title");
        for (int j = 0; j < temp.size(); ++j) {
            ReportElement t = (ReportElement)temp.elementAt(j);
            this.setValues(t);
        }
        this.setValues(this.reportMain.report.titleSetting);
    }

    public void setColumnHeaderBounds() throws Exception {
        ReportElement t;
        int j;
        ReportTable table = this.reportMain.report.getReportTables().elementAt(0);
        ReportSection section = table.getHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
        for (j = 0; j < temp.size(); ++j) {
            t = (ReportElement)temp.elementAt(j);
            this.setValues(t);
        }
        if (this.reportMain.report.getReportType() == 3 || this.reportMain.report.getReportType() == 1) {
            if (((ReportTreeTable)table).getSubTable().size() > 0) {
                section = ((ReportTreeTable)table).getSubTable(0).getHeader();
            }
            rc = section.getData();
            temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
            for (j = 0; j < temp.size(); ++j) {
                t = (ReportElement)temp.elementAt(j);
                this.setValues(t);
            }
            section = table.getMasterSection();
            if (section != null) {
                rc = section.getData();
                temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
                for (j = 0; j < temp.size(); ++j) {
                    t = (ReportElement)temp.elementAt(j);
                    this.setValues(t);
                }
            }
        }
        this.setValues(this.reportMain.report.columnHeaderSetting);
    }

    public void setFormulaBounds() throws Exception {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportSection rs;
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (relt instanceof ReportSection) {
                ReportElement[] rc = ((ReportSection)relt).getData();
                Vector<Object> temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "Formula");
                for (int j = 0; j < temp.size(); ++j) {
                    ReportElement t = (ReportElement)temp.elementAt(j);
                    this.setValues(t);
                }
                continue;
            }
            if (!(relt instanceof ReportTable) || (rs = ((ReportTable)relt).getMasterSection()) == null) continue;
            ReportElement[] rc = rs.getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Formula");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                this.setValues(t);
            }
        }
        ReportCell[] formula = this.reportMain.report.formula;
        for (int j = 0; j < Array.getLength(this.reportMain.report.formula); ++j) {
            this.setValues(formula[j]);
        }
    }

    public void setColumnBounds() throws Exception {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) continue;
            ReportTable relt = elt.getOriginalReportTable();
            ReportElement[] rc = relt.getColumn();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Column");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                this.setValues(t);
            }
        }
        ReportColumn[] column = this.reportMain.report.column;
        for (int j = 0; j < Array.getLength(this.reportMain.report.column); ++j) {
            this.setValues(column[j]);
        }
    }

    public void setImageBounds() throws Exception {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "Image");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "Image");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                this.setValues(t);
            }
        }
        this.setValues(this.reportMain.report.imageSetting);
    }

    public void setChartBounds() throws Exception {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "Chart");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "Chart");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                this.setValues(t);
            }
        }
        this.setValues(this.reportMain.report.chartSetting);
    }

    public void setGridBounds() throws Exception {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "ReportGrid");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "ReportGrid");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                if (!(t instanceof ReportGrid) || ((ReportGrid)t).previous() != null) continue;
                this.setValues(t);
            }
        }
        this.setGridLineSettingsValue(this.reportMain.report.gridSetting);
    }

    public void setLineBounds() throws Exception {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "ReportLine");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "ReportLine");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                if (!(t instanceof ReportLine) || t instanceof GuideLine || ((ReportLine)t).previous() != null || ((ReportLine)t).isVertical()) continue;
                this.setValues(t);
            }
        }
        this.setGridLineSettingsValue(this.reportMain.report.lineSetting);
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent e) {
        if (this.initializing) {
            return;
        }
        this.apply.setSelected(true);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent e) {
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.initializing) {
            return;
        }
        this.apply.setSelected(true);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object srcObj = e.getSource();
        if (srcObj == this.matchColumnWidthsBox) {
            this.widthField.setEnabled(!this.matchColumnWidthsBox.isSelected());
            this.widthField.setText((this.matchColumnWidthsBox.isSelected() ? -1.0 : 1.0) + "");
        }
        if (this.initializing) {
            return;
        }
        this.apply.setSelected(true);
    }

    @Override
    public void verify() throws Exception {
        try {
            Double.parseDouble(this.widthField.getText());
            Double.parseDouble(this.heightField.getText());
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Field dimensions: Invalid number", ex);
            throw new Exception(LanguageEncoder.getText("Please input numeric values only."));
        }
    }

    public void setImported(boolean imported) {
        this.imported = imported;
    }

    @Override
    public void apply() throws Exception {
        if (!this.apply.isSelected()) {
            return;
        }
        if (this.elementType == 6) {
            this.setLabelBounds();
        }
        if (this.elementType == 12) {
            this.setColumnHeaderBounds();
        }
        if (this.elementType == 13) {
            this.setTitleBounds();
        }
        if (this.elementType == 5) {
            this.setFormulaBounds();
        }
        if (this.elementType == 4) {
            this.setColumnBounds();
        }
        if (this.elementType == 0) {
            this.setChartBounds();
        }
        if (this.elementType == 1) {
            this.setGridBounds();
        }
        if (this.elementType == 2) {
            this.setLineBounds();
        }
        if (this.elementType == 3) {
            if (this.selection.isSelected()) {
                this.reportMain.report.setIsApplyBoundSelected(false);
            } else {
                this.reportMain.report.setIsApplyBoundSelected(true);
                this.setImageBounds();
            }
        }
    }
}

