/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Array;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ColorDialog;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.SetFontDialog;
import quadbase.reportdesigner.designer.globalformat.IGlobalSet;
import quadbase.reportdesigner.util.ColInfo;

public class GlobalSetDualColorsPanel
extends JPanel
implements IGlobalSet,
ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(GlobalSetDualColorsPanel.class.getName());
    private JButton bgColorButton;
    private JButton fontStyleButton;
    private JCheckBox dualCheck;
    private JRadioButton rowIndexButton;
    private JRadioButton rowBreakButton;
    private JRadioButton columnValueButton;
    private JTextField indexField;
    private JList columnList;
    private ReportColumn column;
    private ReportMain reportMain;
    private ColorDialog bgColorDialog;
    private SetFontDialog fontStyleDialog;
    private Color bgColor;
    private Color fontColor;
    private Font font;
    private boolean isUnderline;
    private int rowIndex;
    private boolean rowBreak;
    private int[] colInfoIndex;
    private int[] colInfo;

    public GlobalSetDualColorsPanel(ReportMain reportMain) {
        this.reportMain = reportMain;
        this.init();
    }

    private void init() {
        int i;
        this.setBackground(Color.lightGray);
        this.bgColor = new Color(233, 233, 233);
        this.fontColor = Color.black;
        boolean isAdjustFont = this.reportMain.report == null ? true : this.reportMain.report.isAdjustFont();
        this.font = new Font("Dialog", 0, QbUtil.getAdjustedFont(12, isAdjustFont));
        this.rowIndex = 0;
        this.rowBreak = false;
        this.colInfoIndex = null;
        this.column = this.reportMain.report.stringColumnSetting;
        if (this.column != null) {
            this.bgColor = this.column.getBgColor2();
            this.fontColor = this.column.getFontColor2();
            this.font = this.column.getFont2();
            this.rowIndex = this.column.getAlternateRow();
            this.rowBreak = this.column.isDualColorOnRowBreak();
            this.colInfoIndex = this.column.getDualColorColInfoIndex();
            this.isUnderline = this.column.isUnderline2();
        }
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Set Dual Colors")));
        p1.setLayout(new BorderLayout());
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new BorderLayout());
        JPanel dualCheckPanel = new JPanel(new FlowLayout(0));
        this.dualCheck = new JCheckBox(LanguageEncoder.getText("Enable Dual Colors"), this.rowIndex > 0 || this.rowBreak || this.colInfoIndex != null);
        dualCheckPanel.add(this.dualCheck);
        this.dualCheck.addItemListener(this);
        ButtonGroup group = new ButtonGroup();
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setBorder(new TitledBorder(""));
        radioButtonPanel.setLayout(new BorderLayout());
        JPanel indexPanel = new JPanel();
        indexPanel.setLayout(new GridLayout(1, 2));
        this.rowIndexButton = new JRadioButton(LanguageEncoder.getText("Row Index"), this.rowIndex > 0);
        indexPanel.add(this.rowIndexButton);
        this.rowIndexButton.addItemListener(this);
        this.indexField = new JTextField(this.rowIndex + "", 5);
        indexPanel.add(this.indexField);
        group.add(this.rowIndexButton);
        JPanel breakPanel = new JPanel();
        breakPanel.setLayout(new GridLayout(1, 2));
        this.rowBreakButton = new JRadioButton(LanguageEncoder.getText("Row Break"), this.rowBreak);
        breakPanel.add(this.rowBreakButton);
        group.add(this.rowBreakButton);
        JPanel columnPanel = new JPanel();
        columnPanel.setLayout(new GridLayout(1, 2));
        this.columnValueButton = new JRadioButton(LanguageEncoder.getText("Column Value Change"), this.colInfoIndex != null);
        columnPanel.add(this.columnValueButton);
        this.columnValueButton.addItemListener(this);
        group.add(this.columnValueButton);
        if (this.reportMain.report.reportType == 2) {
            int ct = 0;
            for (ColInfo element : this.reportMain.report.colInfo) {
                if (!element.isRowBreak()) continue;
                ++ct;
            }
            this.colInfo = new int[ct];
            ct = 0;
            for (i = 0; i < this.reportMain.report.colInfo.length; ++i) {
                if (!this.reportMain.report.colInfo[i].isRowBreak()) continue;
                this.colInfo[ct++] = i;
            }
        } else {
            this.colInfo = new int[this.reportMain.report.colInfo.length];
            for (int i2 = 0; i2 < this.reportMain.report.colInfo.length; ++i2) {
                this.colInfo[i2] = i2;
            }
        }
        String[] columnNames = new String[this.colInfo.length];
        for (i = 0; i < columnNames.length; ++i) {
            columnNames[i] = this.reportMain.report.colInfo[this.colInfo[i]].getName();
        }
        this.columnList = new JList<String>(columnNames);
        if (this.colInfoIndex != null) {
            int[] temp = new int[this.colInfoIndex.length];
            for (int i3 = 0; i3 < this.colInfoIndex.length; ++i3) {
                for (int j = 0; j < this.colInfo.length; ++j) {
                    if (this.colInfoIndex[i3] != this.colInfo[j]) continue;
                    temp[i3] = j;
                }
            }
            this.columnList.setSelectedIndices(temp);
        }
        columnPanel.add(new JScrollPane(this.columnList));
        radioButtonPanel.add((Component)indexPanel, "North");
        radioButtonPanel.add((Component)breakPanel, "Center");
        radioButtonPanel.add((Component)columnPanel, "South");
        upperPanel.add((Component)dualCheckPanel, "North");
        upperPanel.add((Component)radioButtonPanel, "Center");
        upperPanel.add((Component)new JPanel(), "South");
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new GridLayout(1, 3, 5, 5));
        this.bgColorButton = new JButton(LanguageEncoder.getText("Background Color"));
        optionPanel.add(this.bgColorButton);
        this.bgColorButton.addActionListener(this);
        this.fontStyleButton = new JButton(LanguageEncoder.getText("Font Style"));
        optionPanel.add(this.fontStyleButton);
        this.fontStyleButton.addActionListener(this);
        p1.add((Component)upperPanel, "Center");
        p1.add((Component)optionPanel, "South");
        this.setDualEnabled();
        this.setLayout(new BorderLayout());
        this.add("Center", p1);
    }

    public void setColumnDualColors(int rowIndex, boolean rowBreak, Color bgColor, Color fontColor, Font fontStyle, boolean isUnderline) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) continue;
            ReportTable relt = elt.getOriginalReportTable();
            ReportElement[] rc = relt.getColumn();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Column");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement r = (ReportElement)temp.elementAt(j);
                ReportColumn t = (ReportColumn)r;
                if (this.reportMain.report.isCrossTab() && rowIndex > 0) {
                    int[] nArray;
                    if (this.colInfoIndex != null) {
                        nArray = this.colInfoIndex;
                    } else {
                        int[] nArray2 = new int[1];
                        nArray = nArray2;
                        nArray2[0] = 0;
                    }
                    t.setDualColorColInfoIndex(nArray);
                } else {
                    t.setAlternateRow(rowIndex);
                    t.setDualColorOnRowBreak(rowBreak);
                    t.setDualColorColInfoIndex(this.colInfoIndex);
                }
                t.setBgColor2(bgColor);
                t.setFontColor2(fontColor);
                t.setFont2(fontStyle);
                t.setUnderline2(isUnderline);
                this.reportMain.designPanel.rulerPanel.repaintPanel();
                this.reportMain.setModified();
            }
        }
        ReportColumn[] column = this.reportMain.report.column;
        for (int i = 0; i < Array.getLength(column); ++i) {
            column[i].setAlternateRow(rowIndex);
            column[i].setDualColorOnRowBreak(rowBreak);
            column[i].setDualColorColInfoIndex(this.colInfoIndex);
            column[i].setBgColor2(bgColor);
            column[i].setFontColor2(fontColor);
            column[i].setFont2(fontStyle);
            column[i].setUnderline2(isUnderline);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setDualEnabled();
    }

    private void setDualEnabled() {
        this.rowIndexButton.setEnabled(this.dualCheck.isSelected());
        this.rowBreakButton.setEnabled(this.dualCheck.isSelected());
        this.indexField.setEnabled(this.rowIndexButton.isSelected());
        this.columnValueButton.setEnabled(this.dualCheck.isSelected());
        if (this.columnList != null) {
            this.columnList.setEnabled(this.columnValueButton.isSelected());
        }
        this.bgColorButton.setEnabled(this.dualCheck.isSelected());
        this.fontStyleButton.setEnabled(this.dualCheck.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bgColorButton) {
            if (this.bgColorDialog == null) {
                this.bgColorDialog = new ColorDialog(this.reportMain, true, 4, this.bgColor);
            }
            this.bgColorDialog.setVisible(true);
            return;
        }
        if (e.getSource() == this.fontStyleButton) {
            if (this.fontStyleDialog == null) {
                this.fontStyleDialog = new SetFontDialog(this.reportMain, this.font, this.isUnderline, this.fontColor, 4);
            }
            this.fontStyleDialog.setVisible(true);
            return;
        }
    }

    @Override
    public void verify() throws Exception {
        if (this.dualCheck.isSelected()) {
            try {
                int tmpIndex;
                this.rowIndex = tmpIndex = Integer.parseInt(this.indexField.getText());
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Number of rows must be an integer", ex);
                throw new Exception(LanguageEncoder.getText("Number of rows must be an integer."));
            }
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.dualCheck.isSelected()) {
            if (this.rowIndexButton.isSelected()) {
                try {
                    int tmpIndex;
                    this.rowIndex = tmpIndex = Integer.parseInt(this.indexField.getText());
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.FINEST, "Number of rows must be an integer", ex);
                    throw new Exception(LanguageEncoder.getText("Number of rows must be an integer."));
                }
            } else {
                this.rowIndex = 0;
            }
            this.rowBreak = this.rowBreakButton.isSelected();
            if (this.columnValueButton.isSelected()) {
                if (this.columnList.getSelectedIndices() == null || this.columnList.getSelectedIndices().length == 0) {
                    throw new Exception(LanguageEncoder.getText("You must select at least one column which the value change is based on"));
                }
                this.colInfoIndex = new int[this.columnList.getSelectedIndices().length];
                for (int i = 0; i < this.columnList.getSelectedIndices().length; ++i) {
                    this.colInfoIndex[i] = this.colInfo[this.columnList.getSelectedIndices()[i]];
                }
            } else {
                this.colInfoIndex = null;
            }
        } else {
            this.rowIndex = 0;
            this.rowBreak = false;
            this.colInfoIndex = null;
        }
        if (this.bgColorDialog != null) {
            this.bgColor = this.bgColorDialog.getColor();
        }
        if (this.fontStyleDialog != null) {
            this.font = this.fontStyleDialog.getFont();
            this.isUnderline = this.fontStyleDialog.isUnderline();
            this.fontColor = this.fontStyleDialog.getFontColor();
        }
        this.setColumnDualColors(this.rowIndex, this.rowBreak, this.bgColor, this.fontColor, this.font, this.isUnderline);
    }
}

