/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Array;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.globalformat.IGlobalSet;

public class GlobalSetFontPanel
extends JPanel
implements IGlobalSet,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(GlobalSetFontPanel.class.getName());
    private ReportMain reportMain;
    private Font currentFont;
    private boolean currentUnderline;
    private String[] fontList;
    private JCheckBox underlineBox;
    private JComboBox nameList;
    private JComboBox styleList;
    private JTextField sizeField;
    private JCheckBox apply = null;
    private boolean initializing = false;
    private FontPreviewPanel previewPanel;
    private String text;
    private boolean drawPreviewPanel = true;
    private int elementType;

    public void setDrawPreviewPanel(boolean drawPreviewPanel) {
        this.drawPreviewPanel = drawPreviewPanel;
    }

    public GlobalSetFontPanel(ReportMain reportMain, int elementType) {
        this.reportMain = reportMain;
        this.elementType = elementType;
        this.init();
    }

    private void init() {
        this.initializing = true;
        boolean initUnderline = false;
        Font initFont = null;
        if (this.elementType == 6) {
            initFont = this.reportMain.report.labelSetting.getFont();
            initUnderline = this.reportMain.report.labelSetting.isUnderline();
        }
        if (this.elementType == 12) {
            initFont = this.reportMain.report.columnHeaderSetting.getFont();
            initUnderline = this.reportMain.report.columnHeaderSetting.isUnderline();
        }
        if (this.elementType == 13) {
            initFont = this.reportMain.report.titleSetting.getFont();
            initUnderline = this.reportMain.report.titleSetting.isUnderline();
        }
        if (this.elementType == 5) {
            initFont = this.reportMain.report.stringFormulaSetting.getFont();
            initUnderline = this.reportMain.report.stringFormulaSetting.isUnderline();
        }
        if (this.elementType == 4) {
            initFont = this.reportMain.report.stringColumnSetting.getFont();
            initUnderline = this.reportMain.report.stringColumnSetting.isUnderline();
        }
        this.nameList = new JComboBox();
        for (String element : this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            this.nameList.addItem(element);
        }
        this.styleList = new JComboBox();
        this.styleList.addItem(LanguageEncoder.getText("Plain"));
        this.styleList.addItem(LanguageEncoder.getText("Bold"));
        this.styleList.addItem(LanguageEncoder.getText("Italic"));
        this.styleList.addItem(LanguageEncoder.getText("Bold Italic"));
        this.sizeField = new JTextField();
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(3, 3, 5, 5));
        p1.add(new JLabel(LanguageEncoder.getText("Name")));
        p1.add(this.nameList);
        p1.add(new JLabel(""));
        p1.add(new JLabel(LanguageEncoder.getText("Style")));
        p1.add(this.styleList);
        this.underlineBox = new JCheckBox("Underline Text");
        p1.add(this.underlineBox);
        p1.add(new JLabel(LanguageEncoder.getText("Size")));
        p1.add(this.sizeField);
        p1.add(new JLabel("(between 3 and 99)"));
        this.previewPanel = new FontPreviewPanel();
        this.previewPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Preview")));
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        this.apply = new JCheckBox(LanguageEncoder.getText("Apply Property"));
        p2.add(this.apply);
        this.setDefaultFont(initFont, initUnderline);
        this.underlineBox.addItemListener(this);
        this.nameList.addItemListener(this);
        this.styleList.addItemListener(this);
        this.sizeField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (GlobalSetFontPanel.this.initializing) {
                    return;
                }
                GlobalSetFontPanel.this.apply.setSelected(true);
                GlobalSetFontPanel.this.previewPanel.repaint();
            }
        });
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Set Font ...")));
        this.add("North", p1);
        this.add("Center", this.previewPanel);
        this.add("South", p2);
        this.initializing = false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.initializing) {
            return;
        }
        this.apply.setSelected(true);
        this.previewPanel.repaint();
    }

    private void setDefaultFont(Font font, boolean isUnderline) {
        if (font == null) {
            return;
        }
        this.nameList.setSelectedIndex(this.getName(font.getName()));
        this.styleList.setSelectedIndex(font.getStyle());
        this.sizeField.setText(font.getSize() + "");
        this.underlineBox.setSelected(isUnderline);
    }

    @Override
    public Font getFont() {
        return this.currentFont;
    }

    public boolean isUnderline() {
        return this.currentUnderline;
    }

    private int getName(String str) {
        for (int i = 0; i < this.fontList.length; ++i) {
            if (!this.fontList[i].equals(str)) continue;
            return i;
        }
        return 0;
    }

    public void setLabelFont(Font font, boolean isUnderline) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (!(relt instanceof ReportSection)) continue;
            ReportElement[] rc = ((ReportSection)relt).getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Label");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setFont(font);
                t.setUnderline(isUnderline);
            }
        }
        this.reportMain.report.labelSetting.setFont(font);
        this.reportMain.report.labelSetting.setUnderline(isUnderline);
    }

    public void setTitleFont(Font font, boolean isUnderline) {
        ReportSection section = this.reportMain.report.getReportHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "Title");
        for (int j = 0; j < temp.size(); ++j) {
            ReportElement t = (ReportElement)temp.elementAt(j);
            t.setFont(font);
            t.setUnderline(isUnderline);
        }
        this.reportMain.report.titleSetting.setFont(font);
        this.reportMain.report.titleSetting.setUnderline(isUnderline);
    }

    public void setColumnHeaderFont(Font font, boolean isUnderline) {
        ReportElement t;
        int j;
        ReportTable table = this.reportMain.report.getReportTables().elementAt(0);
        ReportSection section = table.getHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
        for (j = 0; j < temp.size(); ++j) {
            t = (ReportElement)temp.elementAt(j);
            t.setFont(font);
            t.setUnderline(isUnderline);
        }
        if (this.reportMain.report.getReportType() == 3 || this.reportMain.report.getReportType() == 1) {
            if (((ReportTreeTable)table).getSubTable().size() > 0) {
                section = ((ReportTreeTable)table).getSubTable(0).getHeader();
            }
            rc = section.getData();
            temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
            for (j = 0; j < temp.size(); ++j) {
                t = (ReportElement)temp.elementAt(j);
                t.setFont(font);
                t.setUnderline(isUnderline);
            }
            section = table.getMasterSection();
            if (section != null) {
                rc = section.getData();
                temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
                for (j = 0; j < temp.size(); ++j) {
                    t = (ReportElement)temp.elementAt(j);
                    t.setFont(font);
                    t.setUnderline(isUnderline);
                }
            }
        }
        this.reportMain.report.columnHeaderSetting.setFont(font);
        this.reportMain.report.columnHeaderSetting.setUnderline(isUnderline);
    }

    public void setFormulaFont(Font font, boolean isUnderline) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportSection rs;
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (relt instanceof ReportSection) {
                ReportElement[] rc = ((ReportSection)relt).getData();
                Vector<Object> temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "Formula");
                for (int j = 0; j < temp.size(); ++j) {
                    ReportElement t = (ReportElement)temp.elementAt(j);
                    t.setFont(font);
                    t.setUnderline(isUnderline);
                }
                continue;
            }
            if (!(relt instanceof ReportTable) || (rs = ((ReportTable)relt).getMasterSection()) == null) continue;
            ReportElement[] rc = rs.getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Formula");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setFont(font);
                t.setUnderline(isUnderline);
            }
        }
        ReportCell[] formula = this.reportMain.report.formula;
        for (int j = 0; j < Array.getLength(this.reportMain.report.formula); ++j) {
            formula[j].setFont(font);
            formula[j].setUnderline(isUnderline);
        }
    }

    public void setColumnFont(Font font, boolean isUnderline) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) continue;
            ReportTable relt = elt.getOriginalReportTable();
            ReportElement[] rc = relt.getColumn();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Column");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setFont(font);
                t.setUnderline(isUnderline);
            }
        }
        ReportColumn[] column = this.reportMain.report.column;
        for (int j = 0; j < Array.getLength(this.reportMain.report.column); ++j) {
            column[j].setFont(font);
            column[j].setUnderline(isUnderline);
        }
    }

    @Override
    public void verify() throws Exception {
        Integer.parseInt(this.sizeField.getText());
    }

    @Override
    public void apply() throws Exception {
        this.drawPreviewPanel = false;
        if (!this.apply.isSelected()) {
            return;
        }
        String name = (String)this.nameList.getSelectedItem();
        int style = this.styleList.getSelectedIndex();
        int size = 0;
        try {
            size = Integer.parseInt(this.sizeField.getText());
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Font size must be a non-negative integer", ex);
            throw new Exception(LanguageEncoder.getText("Font size must be a non-negative integer."));
        }
        if (size < 3 || size > 99) {
            throw new Exception(LanguageEncoder.getText("Font Size : can't be smaller than 3 or bigger than 99!"));
        }
        this.currentFont = new Font(name, style, size);
        this.currentUnderline = this.underlineBox.isSelected();
        this.drawPreviewPanel = true;
        if (this.elementType == 6) {
            this.setLabelFont(this.currentFont, this.currentUnderline);
        }
        if (this.elementType == 12) {
            this.setColumnHeaderFont(this.currentFont, this.currentUnderline);
        }
        if (this.elementType == 13) {
            this.setTitleFont(this.currentFont, this.currentUnderline);
        }
        if (this.elementType == 5) {
            this.setFormulaFont(this.currentFont, this.currentUnderline);
        }
        if (this.elementType == 4) {
            this.setColumnFont(this.currentFont, this.currentUnderline);
        }
    }

    class FontPreviewPanel
    extends JPanel {
        FontPreviewPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            if (g == null) {
                return;
            }
            if (!GlobalSetFontPanel.this.drawPreviewPanel) {
                return;
            }
            super.paintComponent(g);
            if (GlobalSetFontPanel.this.text == null || GlobalSetFontPanel.this.text.equals("")) {
                GlobalSetFontPanel.this.text = "abc ABC";
            }
            try {
                int size = Integer.parseInt(GlobalSetFontPanel.this.sizeField.getText());
                if (size < 3) {
                    size = 3;
                }
                if (size > 99) {
                    size = 99;
                }
                Font font = FontTable.newFont((String)GlobalSetFontPanel.this.nameList.getSelectedItem(), GlobalSetFontPanel.this.styleList.getSelectedIndex(), size);
                boolean underline = GlobalSetFontPanel.this.underlineBox.isSelected();
                if (font != null) {
                    g.setColor(new Color(255, 255, 255));
                    g.fillRect(20, 20, 370, 50);
                    g.setColor(new Color(0, 0, 0));
                    g.setFont(font);
                    g.drawString(GlobalSetFontPanel.this.text, 50, 50);
                }
                if (underline) {
                    FontMetrics fm = g.getFontMetrics(font);
                    int strWidth = fm.stringWidth(GlobalSetFontPanel.this.text);
                    int underLineY = 50 + fm.getDescent();
                    g.drawLine(50, underLineY, 50 + strWidth, underLineY);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to apply font settings", ex);
            }
        }
    }
}

