/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.DateTimeSamplePanel;
import quadbase.reportdesigner.designer.LogicalPanel;
import quadbase.reportdesigner.designer.NumericSamplePanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.StringPanel;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.LogicalFormat;

public class GlobalSetFormatDialog
extends JDialog
implements ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    private ReportMain reportMain;
    private IFormat initFormat;
    private int type;
    private JPanel formatPanel;
    private boolean modified = false;

    public GlobalSetFormatDialog(ReportMain reportMain, IFormat initFormat, int dataType) {
        super(reportMain, LanguageEncoder.getText("Set Format ..."), true);
        this.reportMain = reportMain;
        this.initFormat = initFormat;
        this.type = dataType;
        this.init();
        this.setPosition();
        this.setVisible(true);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        if (this.type == 7) {
            this.formatPanel = new StringPanel(this.reportMain, this.initFormat);
        } else if (this.type == 0) {
            this.formatPanel = new LogicalPanel(true);
            ((LogicalPanel)this.formatPanel).setFormat(((LogicalFormat)this.initFormat).getformat());
        } else {
            this.formatPanel = this.type == 9 ? new DateTimeSamplePanel(this.reportMain, this.initFormat, false, true, true) : (this.type == 8 ? new DateTimeSamplePanel(this.reportMain, this.initFormat, true, false, true) : (this.type == 10 ? new DateTimeSamplePanel(this.reportMain, this.initFormat, true, true, true) : new NumericSamplePanel(this.reportMain, this.initFormat)));
        }
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", this.formatPanel);
        contentPane.add("South", p2);
        this.pack();
    }

    public IFormat getFormat() {
        return this.initFormat;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.modified = true;
            if (this.formatPanel instanceof NumericSamplePanel) {
                this.initFormat = ((NumericSamplePanel)this.formatPanel).getformat();
            } else if (this.formatPanel instanceof DateTimeSamplePanel) {
                this.initFormat = ((DateTimeSamplePanel)this.formatPanel).getFormat();
            } else if (this.formatPanel instanceof LogicalPanel) {
                this.initFormat = new LogicalFormat(((LogicalPanel)this.formatPanel).getFormatInt());
            } else if (this.formatPanel instanceof StringPanel) {
                this.initFormat = ((StringPanel)this.formatPanel).getFormat();
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }
}

