/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.globalformat.GlobalSetFormatDialog;
import quadbase.reportdesigner.designer.globalformat.IGlobalSet;
import quadbase.reportdesigner.util.DateTimeFormat;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.LocaleDateTimeFormat;
import quadbase.reportdesigner.util.LogicalFormat;
import quadbase.reportdesigner.util.NumericFormat;
import quadbase.reportdesigner.util.StringFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class GlobalSetFormatPanel
extends JPanel
implements IGlobalSet,
ActionListener {
    private ReportMain reportMain;
    private JButton[] buttons = new JButton[4];
    private IFormat[] formats = new IFormat[4];
    private boolean[] modified = new boolean[4];
    private JCheckBox apply = null;
    private int elementType;

    public GlobalSetFormatPanel(ReportMain reportMain, int elementType) {
        this.reportMain = reportMain;
        this.elementType = elementType;
        this.init();
    }

    private void init() {
        if (this.elementType == 5) {
            this.formats[0] = this.reportMain.report.stringFormulaSetting.getDataFormat();
            this.formats[1] = this.reportMain.report.logicFormulaSetting.getDataFormat();
            this.formats[3] = this.reportMain.report.timeFormulaSetting.getDataFormat();
            this.formats[2] = this.reportMain.report.numericFormulaSetting.getDataFormat();
        } else {
            this.formats[0] = this.reportMain.report.stringColumnSetting.getDataFormat();
            this.formats[1] = this.reportMain.report.logicColumnSetting.getDataFormat();
            this.formats[3] = this.reportMain.report.timeColumnSetting.getDataFormat();
            this.formats[2] = this.reportMain.report.numericColumnSetting.getDataFormat();
        }
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(1, 5, 5));
        this.buttons[0] = new JButton(LanguageEncoder.getText("String Format"));
        this.buttons[1] = new JButton(LanguageEncoder.getText("Logic Format"));
        this.buttons[2] = new JButton(LanguageEncoder.getText("Numeric Format"));
        this.buttons[3] = new JButton(LanguageEncoder.getText("Time Format"));
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].addActionListener(this);
            p1.add(this.buttons[i]);
            this.modified[i] = false;
        }
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        this.apply = new JCheckBox(LanguageEncoder.getText("Apply Property"));
        p2.add(this.apply);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Data Format...")));
        this.add("Center", p1);
        this.add("South", p2);
    }

    public void setFormulaFormat(IFormat selectedFormat, IFormat initFormat) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportSection rs;
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            ReportElement[] rc = null;
            if (relt instanceof ReportSection) {
                rc = ((ReportSection)relt).getData();
            } else if (relt instanceof ReportTable && (rs = ((ReportTable)relt).getMasterSection()) != null) {
                rc = rs.getData();
            }
            if (rc == null) continue;
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Formula");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                IFormat elementFormat = ((ReportCell)t).getDataFormat();
                if (elementFormat == null) {
                    ((ReportCell)t).setDataFormat(FormatUtil.createFormat(DataType.mapType(((ReportCell)t).getSQLType()), this.reportMain.report.getLocale(), this.reportMain.report.getTimeZone()));
                    elementFormat = ((ReportCell)t).getDataFormat();
                }
                if (!FormatUtil.isFormatAppliabled(selectedFormat, elementFormat)) continue;
                if (initFormat instanceof LocaleDateTimeFormat) {
                    int datatype = DataType.mapType(((ReportCell)t).getSQLType());
                    LocaleDateTimeFormat tempformat = null;
                    if (datatype == 9) {
                        tempformat = LocaleDateTimeFormat.getTimeInstance(((LocaleDateTimeFormat)initFormat).getTimeStyle());
                        ((ReportCell)t).setDataFormat(tempformat);
                        continue;
                    }
                    if (datatype == 8) {
                        tempformat = LocaleDateTimeFormat.getDateInstance(((LocaleDateTimeFormat)initFormat).getDateStyle());
                        ((ReportCell)t).setDataFormat(tempformat);
                        continue;
                    }
                    if (datatype != 10) continue;
                    ((ReportCell)t).setDataFormat(initFormat);
                    continue;
                }
                ((ReportCell)t).setDataFormat(initFormat);
            }
        }
        ReportCell[] formula = this.reportMain.report.formula;
        for (int i = 0; i < Array.getLength(formula); ++i) {
            if (!FormatUtil.isFormatAppliabled(selectedFormat, formula[i].getDataFormat())) continue;
            formula[i].setDataFormat(initFormat);
            break;
        }
        this.reportMain.designPanel.rulerPanel.repaintPanel();
        this.reportMain.setModified();
    }

    public void setColumnFormat(IFormat selectedFormat, IFormat initFormat) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) continue;
            ReportTable relt = elt.getOriginalReportTable();
            ReportElement[] rc = relt.getColumn();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Column");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                IFormat elementFormat = ((ReportColumn)t).getDataFormat();
                if (!FormatUtil.isFormatAppliabled(selectedFormat, elementFormat)) continue;
                if (initFormat instanceof LocaleDateTimeFormat) {
                    LocaleDateTimeFormat tempformat = null;
                    int datatype = this.reportMain.report.getDataType(this.reportMain.report.getColInfoIndex((ReportColumn)t));
                    if (datatype == 9) {
                        tempformat = LocaleDateTimeFormat.getTimeInstance(((LocaleDateTimeFormat)initFormat).getTimeStyle());
                        ((ReportColumn)t).setDataFormat(tempformat);
                        continue;
                    }
                    if (datatype == 8) {
                        tempformat = LocaleDateTimeFormat.getDateInstance(((LocaleDateTimeFormat)initFormat).getDateStyle());
                        ((ReportColumn)t).setDataFormat(tempformat);
                        continue;
                    }
                    if (datatype != 10) continue;
                    ((ReportColumn)t).setDataFormat(initFormat);
                    continue;
                }
                ((ReportColumn)t).setDataFormat(initFormat);
            }
        }
        ReportColumn[] column = this.reportMain.report.column;
        for (int i = 0; i < Array.getLength(column); ++i) {
            if (!FormatUtil.isFormatAppliabled(selectedFormat, column[i].getDataFormat())) continue;
            column[i].setDataFormat(initFormat);
            break;
        }
        this.reportMain.designPanel.rulerPanel.repaintPanel();
        this.reportMain.setModified();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GlobalSetFormatDialog sfd;
        if (e.getSource() == this.buttons[0]) {
            GlobalSetFormatDialog sfd2 = new GlobalSetFormatDialog(this.reportMain, this.formats[0], 7);
            if (sfd2.isModified()) {
                this.formats[0] = sfd2.getFormat();
                this.modified[0] = true;
                this.apply.setSelected(true);
            }
        } else if (e.getSource() == this.buttons[1]) {
            GlobalSetFormatDialog sfd3 = new GlobalSetFormatDialog(this.reportMain, this.formats[1], 0);
            if (sfd3.isModified()) {
                this.formats[1] = sfd3.getFormat();
                this.modified[1] = true;
                this.apply.setSelected(true);
            }
        } else if (e.getSource() == this.buttons[2]) {
            GlobalSetFormatDialog sfd4 = new GlobalSetFormatDialog(this.reportMain, this.formats[2], 5);
            if (sfd4.isModified()) {
                this.formats[2] = sfd4.getFormat();
                this.modified[2] = true;
                this.apply.setSelected(true);
            }
        } else if (e.getSource() == this.buttons[3] && (sfd = new GlobalSetFormatDialog(this.reportMain, this.formats[3], 10)).isModified()) {
            this.formats[3] = sfd.getFormat();
            this.modified[3] = true;
            this.apply.setSelected(true);
        }
    }

    @Override
    public void verify() {
    }

    @Override
    public void apply() {
        if (!this.apply.isSelected()) {
            return;
        }
        if (this.elementType == 5) {
            if (this.modified[0]) {
                this.setFormulaFormat(new StringFormat(), this.formats[0]);
            }
            if (this.modified[1]) {
                this.setFormulaFormat(new LogicalFormat(1), this.formats[1]);
            }
            if (this.modified[2]) {
                this.setFormulaFormat(new NumericFormat(), this.formats[2]);
            }
            if (this.modified[3]) {
                this.setFormulaFormat(new DateTimeFormat(), this.formats[3]);
            }
        } else {
            if (this.modified[0]) {
                this.setColumnFormat(new StringFormat(), this.formats[0]);
            }
            if (this.modified[1]) {
                this.setColumnFormat(new LogicalFormat(1), this.formats[1]);
            }
            if (this.modified[2]) {
                this.setColumnFormat(new NumericFormat(), this.formats[2]);
            }
            if (this.modified[3]) {
                this.setColumnFormat(new DateTimeFormat(), this.formats[3]);
            }
        }
    }
}

