/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.StyleChooser;
import quadbase.reportdesigner.designer.globalformat.IGlobalSet;

public class GlobalSetLineStylePanel
extends JPanel
implements IGlobalSet,
MouseListener {
    private ReportMain reportMain;
    private int initStyle;
    private ReportElement element = null;
    private StyleChooser styleChooser = null;
    private JCheckBox apply = null;
    private boolean isForGrid = false;
    private int elementType;

    public GlobalSetLineStylePanel(ReportMain reportMain, int elementType) {
        this(reportMain, elementType, false);
    }

    public GlobalSetLineStylePanel(ReportMain reportMain, int elementType, boolean isForGrid) {
        this.reportMain = reportMain;
        this.isForGrid = isForGrid;
        this.elementType = elementType;
        this.init();
    }

    private void init() {
        if (this.elementType == 1) {
            this.initStyle = this.reportMain.report.gridSetting.getGridStyle();
            this.element = new ReportGrid();
            ((ReportGrid)this.element).setGridStyle(this.initStyle);
        } else if (this.elementType == 2) {
            this.initStyle = this.reportMain.report.lineSetting.getLineStyle();
            this.element = new ReportLine();
            ((ReportLine)this.element).setLineStyle(this.initStyle);
        }
        if (this.isForGrid) {
            this.setBorder(new TitledBorder(LanguageEncoder.getText("Rectangle Style ...")));
        } else {
            this.setBorder(new TitledBorder(LanguageEncoder.getText("Line Style ...")));
        }
        StyleChooser mainPanel = this.styleChooser = new StyleChooser(this.reportMain, this.element);
        GridBagLayout glayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        JPanel centerpanel = new JPanel();
        centerpanel.setLayout(glayout);
        JLabel comp = this.isForGrid ? new JLabel(LanguageEncoder.getText("Rectangle Style")) : new JLabel(LanguageEncoder.getText("Line Style"));
        glayout.setConstraints(comp, gbc);
        centerpanel.add(comp);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        mainPanel.setPreferredSize(new Dimension(82, 18));
        mainPanel.setMinimumSize(new Dimension(82, 18));
        mainPanel.setSize(new Dimension(82, 18));
        mainPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        glayout.setConstraints(mainPanel, gbc);
        centerpanel.add(mainPanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        this.apply = new JCheckBox(LanguageEncoder.getText("Apply Property"));
        p2.add(this.apply);
        mainPanel.addMouseListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)centerpanel, "Center");
        this.add((Component)p2, "South");
    }

    public void setGridStyle(int style) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "ReportGrid");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "ReportGrid");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                if (!(t instanceof ReportGrid)) continue;
                ((ReportGrid)t).setGridStyle(style);
            }
        }
        this.reportMain.report.gridSetting.setGridStyle(style);
    }

    public void setLineStyle(int style) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "ReportLine");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "ReportLine");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                if (!(t instanceof ReportLine) || t instanceof GuideLine) continue;
                ((ReportLine)t).setLineStyle(style);
            }
        }
        this.reportMain.report.lineSetting.setLineStyle(style);
    }

    @Override
    public void verify() throws Exception {
    }

    @Override
    public void apply() throws Exception {
        if (!this.apply.isSelected()) {
            return;
        }
        this.styleChooser.setStyle();
        if (this.elementType == 1) {
            this.initStyle = ((ReportGrid)this.element).getGridStyle();
        } else if (this.elementType == 2) {
            this.initStyle = ((ReportLine)this.element).getLineStyle();
        }
        if (this.elementType == 1) {
            this.setGridStyle(this.initStyle);
        } else if (this.elementType == 2) {
            this.setLineStyle(this.initStyle);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.apply.setSelected(true);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

