/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.globalformat.IGlobalSet;

public class GlobalSetRotationPanel
extends JPanel
implements IGlobalSet,
ItemListener {
    private ReportMain reportMain;
    private JRadioButton none;
    private JRadioButton clockwise;
    private JRadioButton counterclockwise;
    private boolean isModified = false;
    private JCheckBox apply = null;
    private int elementType;

    public GlobalSetRotationPanel(ReportMain reportMain, int elementType) {
        this.reportMain = reportMain;
        this.elementType = elementType;
        this.init();
    }

    private void init() {
        JPanel p11 = new JPanel();
        p11.setBorder(new TitledBorder(LanguageEncoder.getText("Rotation")));
        p11.setLayout(new FlowLayout());
        this.none = new JRadioButton(LanguageEncoder.getText("None"), false);
        this.clockwise = new JRadioButton(LanguageEncoder.getText("Clockwise"), false);
        this.counterclockwise = new JRadioButton(LanguageEncoder.getText("Counterclockwise"), false);
        double r = this.elementType == 6 ? this.reportMain.report.labelSetting.getRotateAngle() : (this.elementType == 12 ? this.reportMain.report.columnHeaderSetting.getRotateAngle() : (this.elementType == 13 ? this.reportMain.report.titleSetting.getRotateAngle() : (this.elementType == 5 ? this.reportMain.report.stringFormulaSetting.getRotateAngle() : this.reportMain.report.stringColumnSetting.getRotateAngle())));
        if (r == 0.0) {
            this.none.setSelected(true);
        } else if (r == 90.0) {
            this.clockwise.setSelected(true);
        } else {
            this.counterclockwise.setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.none);
        group.add(this.clockwise);
        group.add(this.counterclockwise);
        p11.add(this.none);
        p11.add(this.clockwise);
        p11.add(this.counterclockwise);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add("Center", p11);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        this.apply = new JCheckBox(LanguageEncoder.getText("Apply Property"));
        p2.add(this.apply);
        this.none.addItemListener(this);
        this.clockwise.addItemListener(this);
        this.counterclockwise.addItemListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Rotation...")));
        this.add("Center", p1);
        this.add("South", p2);
    }

    public double getSelection() {
        if (this.none.isSelected()) {
            return 0.0;
        }
        if (this.clockwise.isSelected()) {
            return 90.0;
        }
        if (this.counterclockwise.isSelected()) {
            return -90.0;
        }
        return 0.0;
    }

    boolean isModified() {
        return this.isModified;
    }

    private void setValues(ReportElement elt, double rotation) {
        elt.setRotateAngle(rotation);
        this.isModified = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.apply.setSelected(true);
    }

    public void setLabelRotation(double rotation) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (!(relt instanceof ReportSection)) continue;
            ReportElement[] rc = ((ReportSection)relt).getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Label");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                this.setValues(t, rotation);
            }
        }
        this.setValues(this.reportMain.report.labelSetting, rotation);
    }

    public void setTitleRotation(double rotation) {
        ReportSection section = this.reportMain.report.getReportHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "Title");
        for (int j = 0; j < temp.size(); ++j) {
            ReportElement t = (ReportElement)temp.elementAt(j);
            this.setValues(t, rotation);
        }
        this.setValues(this.reportMain.report.titleSetting, rotation);
    }

    public void setColumnHeaderRotation(double rotation) {
        ReportElement t;
        int j;
        ReportTable table = this.reportMain.report.getReportTables().elementAt(0);
        ReportSection section = table.getHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
        for (j = 0; j < temp.size(); ++j) {
            t = (ReportElement)temp.elementAt(j);
            this.setValues(t, rotation);
        }
        if (this.reportMain.report.getReportType() == 3 || this.reportMain.report.getReportType() == 1) {
            if (((ReportTreeTable)table).getSubTable().size() > 0) {
                section = ((ReportTreeTable)table).getSubTable(0).getHeader();
            }
            rc = section.getData();
            temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
            for (j = 0; j < temp.size(); ++j) {
                t = (ReportElement)temp.elementAt(j);
                this.setValues(t, rotation);
            }
            section = table.getMasterSection();
            if (section != null) {
                temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
                for (j = 0; j < temp.size(); ++j) {
                    t = (ReportElement)temp.elementAt(j);
                    this.setValues(t, rotation);
                }
            }
        }
        this.setValues(this.reportMain.report.columnHeaderSetting, rotation);
    }

    public void setFormulaRotation(double rotation) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportSection rs;
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (relt instanceof ReportSection) {
                ReportElement[] rc = ((ReportSection)relt).getData();
                Vector<Object> temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "Formula");
                for (int j = 0; j < temp.size(); ++j) {
                    ReportElement t = (ReportElement)temp.elementAt(j);
                    this.setValues(t, rotation);
                }
                continue;
            }
            if (!(relt instanceof ReportTable) || (rs = ((ReportTable)relt).getMasterSection()) == null) continue;
            ReportElement[] rc = rs.getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Formula");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                this.setValues(t, rotation);
            }
        }
        ReportCell[] formula = this.reportMain.report.formula;
        for (int j = 0; j < Array.getLength(this.reportMain.report.formula); ++j) {
            this.setValues(formula[j], rotation);
        }
    }

    public void setColumnRotation(double rotation) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) continue;
            ReportTable relt = elt.getOriginalReportTable();
            ReportElement[] rc = relt.getColumn();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Column");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                this.setValues(t, rotation);
            }
        }
        ReportColumn[] column = this.reportMain.report.column;
        for (int j = 0; j < Array.getLength(this.reportMain.report.column); ++j) {
            this.setValues(column[j], rotation);
        }
    }

    @Override
    public void verify() {
    }

    @Override
    public void apply() {
        if (!this.apply.isSelected()) {
            return;
        }
        double rotation = this.getSelection();
        if (this.elementType == 6) {
            this.setLabelRotation(rotation);
        } else if (this.elementType == 12) {
            this.setColumnHeaderRotation(rotation);
        } else if (this.elementType == 13) {
            this.setTitleRotation(rotation);
        } else if (this.elementType == 5) {
            this.setFormulaRotation(rotation);
        } else {
            this.setColumnRotation(rotation);
        }
    }
}

