/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.globalformat.GlobalScriptSelectionDialog;
import quadbase.reportdesigner.designer.globalformat.IGlobalSet;
import quadbase.reportdesigner.report.Script;

public class GlobalSetScriptPanel
extends JPanel
implements IGlobalSet,
ActionListener {
    private ReportMain reportMain;
    private String currentScript;
    private JTextField scriptField;
    private JButton changeButton;
    private JCheckBox apply;
    private int elementType;

    public GlobalSetScriptPanel(ReportMain reportMain, int elementType) {
        this.reportMain = reportMain;
        this.elementType = elementType;
        this.currentScript = null;
        this.init();
    }

    private void init() {
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        p1.add(new JLabel(LanguageEncoder.getText("Current Script :")));
        this.scriptField = new JTextField(20);
        p1.add(this.scriptField);
        this.changeButton = new JButton(LanguageEncoder.getText("Change"));
        p1.add(this.changeButton);
        if (this.elementType == 6) {
            this.currentScript = this.reportMain.report.labelSetting.getScriptName();
        } else if (this.elementType == 12) {
            this.currentScript = this.reportMain.report.columnHeaderSetting.getScriptName();
        } else if (this.elementType == 5) {
            this.currentScript = this.reportMain.report.stringFormulaSetting.getScriptName();
        } else if (this.elementType == 4) {
            this.currentScript = this.reportMain.report.stringColumnSetting.getScriptName();
        } else if (this.elementType == 2) {
            this.currentScript = this.reportMain.report.lineSetting.getScriptName();
        }
        this.scriptField.setText(this.currentScript);
        this.scriptField.setEnabled(false);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        this.apply = new JCheckBox(LanguageEncoder.getText("Apply Property"));
        p2.add(this.apply);
        this.changeButton.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Script ...")));
        this.add("Center", p1);
        this.add("South", p2);
    }

    public void setLabelScript(Script script) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (!(relt instanceof ReportSection)) continue;
            ReportElement[] rc = ((ReportSection)relt).getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Label");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setScriptObjNull(script);
            }
        }
        this.reportMain.report.labelSetting.setScriptObjNull(script);
    }

    public void setColumnHeaderScript(Script script) {
        ReportElement t;
        int j;
        ReportTable table = this.reportMain.report.getReportTables().elementAt(0);
        ReportSection section = table.getHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
        for (j = 0; j < temp.size(); ++j) {
            t = (ReportElement)temp.elementAt(j);
            t.setScriptObjNull(script);
        }
        if (this.reportMain.report.getReportType() == 3 || this.reportMain.report.getReportType() == 1) {
            section = ((ReportTreeTable)table).getSubTable(0).getHeader();
            rc = section.getData();
            temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
            for (j = 0; j < temp.size(); ++j) {
                t = (ReportElement)temp.elementAt(j);
                t.setScriptObjNull(script);
            }
            section = table.getMasterSection();
            if (section != null) {
                rc = section.getData();
                temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
                for (j = 0; j < temp.size(); ++j) {
                    t = (ReportElement)temp.elementAt(j);
                    t.setScriptObjNull(script);
                }
            }
        }
        this.reportMain.report.columnHeaderSetting.setScriptObjNull(script);
    }

    public void setFormulaScript(Script script) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportSection rs;
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            ReportElement relt = elt.getElement();
            if (relt instanceof ReportSection) {
                ReportElement[] rc = ((ReportSection)relt).getData();
                Vector<Object> temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "Formula");
                for (int j = 0; j < temp.size(); ++j) {
                    ReportElement t = (ReportElement)temp.elementAt(j);
                    t.setScriptObjNull(script);
                }
                continue;
            }
            if (!(relt instanceof ReportTable) || (rs = ((ReportTable)relt).getMasterSection()) == null) continue;
            ReportElement[] rc = rs.getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Formula");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setScriptObjNull(script);
            }
        }
        ReportCell[] formula = this.reportMain.report.formula;
        for (int j = 0; j < Array.getLength(this.reportMain.report.formula); ++j) {
            formula[j].setScriptObjNull(script);
        }
    }

    public void setColumnScript(Script script) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) continue;
            elt.setApplyScript(true);
            ReportTable relt = elt.getOriginalReportTable();
            ReportElement[] rc = relt.getColumn();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Column");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setScriptObjNull(script);
            }
        }
        ReportColumn[] column = this.reportMain.report.column;
        for (int j = 0; j < Array.getLength(this.reportMain.report.column); ++j) {
            column[j].setScriptObjNull(script);
        }
    }

    public void setLineScript(Script script) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "ReportLine");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "ReportLine");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                if (t instanceof GuideLine) continue;
                t.setScriptObjNull(script);
            }
        }
        this.reportMain.report.lineSetting.setScriptObjNull(script);
    }

    public void setGridScript(Script script) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "ReportGrid");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "ReportGrid");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setScriptObjNull(script);
            }
        }
        this.reportMain.report.gridSetting.setScriptObjNull(script);
    }

    public void setImageScript(Script script) {
        int size = this.reportMain.designPanel.rulerPanel.panelList.size();
        Vector<Object> temp = new Vector();
        for (int i = 0; i < size - 1; ++i) {
            ReportElementPanel elt = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (elt.isReportSection()) {
                ReportElement relt = elt.getElement();
                ReportElement[] rc = ((ReportSection)relt).getData();
                temp = ReportElement.findSpecificElements(rc, "ReportImage");
            } else {
                ReportTable rt = elt.getOriginalReportTable();
                ReportElement[] ri = rt.getImage();
                temp = ReportElement.findSpecificElements(ri, "ReportImage");
            }
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                t.setScriptObjNull(script);
            }
        }
        this.reportMain.report.imageSetting.setScriptObjNull(script);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.changeButton) {
            this.apply.setSelected(true);
            GlobalScriptSelectionDialog d = new GlobalScriptSelectionDialog(new JDialog(), this.reportMain.report.scripts);
            d.setVisible(true);
            if (d.isModified()) {
                this.currentScript = d.getSelectedScript();
                this.scriptField.setText(this.currentScript);
            }
            return;
        }
    }

    @Override
    public void verify() {
    }

    @Override
    public void apply() {
        if (!this.apply.isSelected()) {
            return;
        }
        Script script = null;
        if (!this.currentScript.equals("None")) {
            for (int i = 0; i < this.reportMain.report.scripts.size(); ++i) {
                Script s = this.reportMain.report.scripts.elementAt(i);
                if (!s.getName().equals(this.currentScript)) continue;
                script = s;
            }
        }
        if (this.elementType == 6) {
            this.setLabelScript(script);
        } else if (this.elementType == 12) {
            this.setColumnHeaderScript(script);
        } else if (this.elementType == 5) {
            this.setFormulaScript(script);
        } else if (this.elementType == 4) {
            this.setColumnScript(script);
        } else if (this.elementType == 2) {
            this.setLineScript(script);
        } else if (this.elementType == 1) {
            this.setGridScript(script);
        } else if (this.elementType == 3) {
            this.setImageScript(script);
        }
    }
}

