/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportTitle;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.globalformat.GlobalSetAlignmentPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetBackgroundColorPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetBorderColorPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetBorderThicknessPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetBoundsPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetDualColorsPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetFontColorPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetFontPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetFormatPanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetLineStylePanel;
import quadbase.reportdesigner.designer.globalformat.GlobalSetRotationPanel;
import quadbase.reportdesigner.designer.globalformat.ImportGlobalFormatHelper;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.DateTimeFormat;
import quadbase.reportdesigner.util.LogicalFormat;
import quadbase.reportdesigner.util.NumericFormat;
import quadbase.reportdesigner.util.StringFormat;

public class ImportGlobalFormat {
    private static final Logger LOGGER = Logger.getLogger(ImportGlobalFormat.class.getName());
    private GlobalSetFontColorPanel set_font_color;
    private GlobalSetFontPanel set_font;
    private GlobalSetBackgroundColorPanel set_background_color;
    private GlobalSetBorderColorPanel set_border_color;
    private GlobalSetBorderThicknessPanel set_border_thickness;
    private GlobalSetBoundsPanel set_bounds;
    private GlobalSetAlignmentPanel set_alignment;
    private GlobalSetRotationPanel set_rotation;
    private GlobalSetFormatPanel set_format;
    private GlobalSetDualColorsPanel set_dual_colors;
    private GlobalSetLineStylePanel set_line_style;
    private Report report = null;
    private ReportMain reportmain;
    private boolean useDefaultImageSize = true;
    int resize = 0;
    boolean imported = false;

    public ImportGlobalFormat(ReportMain reportmain) {
        this.reportmain = reportmain;
        if (reportmain != null) {
            this.report = reportmain.report;
        }
    }

    public void importXML(String path) throws IOException {
        if (path == null || path.trim().equals("")) {
            throw new IOException("No file name selected !");
        }
        try (DataInputStream istream = null;){
            istream = ServerMessage.useServer || !ServerMessage.isLoadBalancer ? ImportGlobalFormat.getInputStreamFromServer(path) : new DataInputStream(new ByteArrayInputStream(new ImportGlobalFormatHelper().getInputStream(path)));
            this.importXMLDocument(istream);
            this.imported = true;
        }
    }

    private Font resizeFont(Font font, int flag) {
        if (flag == 0) {
            return font;
        }
        if (flag == 1) {
            return QbUtil.resizeViewerFont(font, true);
        }
        return new Font(font.getName(), font.getStyle(), QbUtil.getAdjustedFont(font.getSize(), true));
    }

    public void applyGlobalFormat(Vector<ReportElement> setting) {
        if (this.reportmain != null && this.report != null) {
            this.report.setSetting(setting);
            this.set_font_color = new GlobalSetFontColorPanel(this.reportmain, -1);
            this.set_font = new GlobalSetFontPanel(this.reportmain, -1);
            this.set_background_color = new GlobalSetBackgroundColorPanel(this.reportmain, -1);
            this.set_border_color = new GlobalSetBorderColorPanel(this.reportmain, -1);
            this.set_border_thickness = new GlobalSetBorderThicknessPanel(this.reportmain, -1);
            this.set_bounds = new GlobalSetBoundsPanel(this.reportmain, -1);
            this.set_alignment = new GlobalSetAlignmentPanel(this.reportmain, -1);
            this.set_rotation = new GlobalSetRotationPanel(this.reportmain, -1);
            this.set_format = new GlobalSetFormatPanel(this.reportmain, -1);
            this.set_dual_colors = new GlobalSetDualColorsPanel(this.reportmain);
            this.set_format = new GlobalSetFormatPanel(this.reportmain, -1);
            this.set_line_style = new GlobalSetLineStylePanel(this.reportmain, -1);
            this.importLabel(this.report.labelSetting);
            this.importColumnHeader(this.report.columnHeaderSetting);
            this.importTitle(this.report.titleSetting);
            this.importImage(this.report.imageSetting);
            this.importChart(this.report.chartSetting);
            this.importStringFormula(this.report.stringFormulaSetting);
            this.importLogicalFormula(this.report.logicFormulaSetting);
            this.importNumericFormula(this.report.numericFormulaSetting);
            this.importDateTimeFormula(this.report.timeFormulaSetting);
            this.importStringColumn(this.report.stringColumnSetting);
            this.importLogicalColumn(new ReportCell(this.report.logicColumnSetting, 0));
            this.importNumericColumn(new ReportCell(this.report.numericColumnSetting, 0));
            this.importDateTimeColumn(new ReportCell(this.report.timeColumnSetting, 0));
            this.importLine(this.report.lineSetting);
            this.importGrid(this.report.gridSetting);
        }
    }

    private void importXMLDocument(DataInputStream in) throws Exception {
        if (this.report != null && in != null && this.reportmain != null) {
            this.set_font_color = new GlobalSetFontColorPanel(this.reportmain, -1);
            this.set_font = new GlobalSetFontPanel(this.reportmain, -1);
            this.set_background_color = new GlobalSetBackgroundColorPanel(this.reportmain, -1);
            this.set_border_color = new GlobalSetBorderColorPanel(this.reportmain, -1);
            this.set_border_thickness = new GlobalSetBorderThicknessPanel(this.reportmain, -1);
            this.set_bounds = new GlobalSetBoundsPanel(this.reportmain, -1);
            this.set_alignment = new GlobalSetAlignmentPanel(this.reportmain, -1);
            this.set_rotation = new GlobalSetRotationPanel(this.reportmain, -1);
            this.set_format = new GlobalSetFormatPanel(this.reportmain, -1);
            this.set_dual_colors = new GlobalSetDualColorsPanel(this.reportmain);
            this.set_format = new GlobalSetFormatPanel(this.reportmain, -1);
            this.set_line_style = new GlobalSetLineStylePanel(this.reportmain, -1);
            int version = in.readInt();
            boolean isAdjustFont = false;
            if (version >= 166 || version >= 147 && version < 160) {
                isAdjustFont = in.readBoolean();
            }
            this.resize = this.report.isAdjustFont() == isAdjustFont ? 0 : (this.report.isAdjustFont() ? -1 : 1);
            ReportElement element = null;
            if (in.readBoolean()) {
                element = ReportCell.createCell(in, version);
                this.importLabel(element);
            }
            if (in.readBoolean()) {
                element = ColumnHeader.createColumnHeader(in, version);
                this.importColumnHeader(element);
            }
            if (in.readBoolean()) {
                element = ReportTitle.createReportTitle(in, version);
                this.importTitle(element);
            }
            if (in.readBoolean()) {
                element = ReportImage.createImage(in, version);
                this.useDefaultImageSize = in.readBoolean();
                this.importImage(element);
            }
            if (in.readBoolean()) {
                element = ReportChartObject.createChartObject(in, version);
                this.importChart(element);
            }
            if (in.readBoolean()) {
                element = ReportCell.createCell(in, version);
                this.importStringFormula((ReportCell)element);
            }
            if (in.readBoolean()) {
                element = ReportCell.createCell(in, version);
                this.importLogicalFormula((ReportCell)element);
            }
            if (in.readBoolean()) {
                element = ReportCell.createCell(in, version);
                this.importNumericFormula((ReportCell)element);
            }
            if (in.readBoolean()) {
                element = ReportCell.createCell(in, version);
                this.importDateTimeFormula((ReportCell)element);
            }
            if (in.readBoolean()) {
                element = ReportColumn.createColumn(in, version);
                this.importStringColumn((ReportColumn)element);
            }
            if (in.readBoolean()) {
                element = ReportCell.createCell(in, version);
                this.importLogicalColumn((ReportCell)element);
            }
            if (in.readBoolean()) {
                element = ReportCell.createCell(in, version);
                this.importNumericColumn((ReportCell)element);
            }
            if (in.readBoolean()) {
                element = ReportCell.createCell(in, version);
                this.importDateTimeColumn((ReportCell)element);
            }
            if (in.readBoolean()) {
                element = ReportLine.createLine(in, version);
                this.importLine((ReportLine)element);
            }
            if (in.readBoolean()) {
                element = ReportGrid.createGrid(in, version);
                this.importGrid((ReportGrid)element);
            }
        }
    }

    private void importLabel(ReportElement element) {
        if (element != null) {
            try {
                this.set_font_color.setLabelFontColor(element.getFontColor());
                this.set_font.setLabelFont(this.resizeFont(element.getFont(), this.resize), element.isUnderline());
                this.set_background_color.setLabelBackground(element.getBgColor());
                this.set_border_color.setLabelBorderColor(element.getBorderColor());
                this.set_border_thickness.setLabelThickness(element.getBorderThickness());
                this.set_alignment.setLabelAlignment(element.getAlign(), element.getVAlign());
                this.set_rotation.setLabelRotation(element.getRotateAngle());
                this.set_bounds.setField(element);
                this.set_bounds.setLabelBounds();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import label", ex);
            }
        }
    }

    private void importTitle(ReportElement element) {
        if (element != null) {
            try {
                this.set_font_color.setTitleFontColor(element.getFontColor());
                this.set_font.setTitleFont(this.resizeFont(element.getFont(), this.resize), element.isUnderline());
                this.set_background_color.setTitleBackground(element.getBgColor());
                this.set_border_color.setTitleBorderColor(element.getBorderColor());
                this.set_border_thickness.setTitleThickness(element.getBorderThickness());
                this.set_alignment.setTitleAlignment(element.getAlign(), element.getVAlign());
                this.set_bounds.setField(element);
                this.set_bounds.setTitleBounds();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import title", ex);
            }
        }
    }

    private void importColumnHeader(ReportElement element) {
        if (element != null) {
            try {
                this.set_font_color.setColumnHeaderFontColor(element.getFontColor());
                this.set_font.setColumnHeaderFont(this.resizeFont(element.getFont(), this.resize), element.isUnderline());
                this.set_background_color.setColumnHeaderBackground(element.getBgColor());
                this.set_border_color.setColumnHeaderBorderColor(element.getBorderColor());
                this.set_border_thickness.setColumnHeaderThickness(element.getBorderThickness());
                this.set_alignment.setColumnHeaderAlignment(element.getAlign(), element.getVAlign());
                this.set_rotation.setColumnHeaderRotation(element.getRotateAngle());
                this.set_bounds.setField(element);
                this.set_bounds.setColumnHeaderBounds();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import column header", ex);
            }
        }
    }

    private void importImage(ReportElement element) {
        if (element != null) {
            try {
                this.set_border_color.setImageBorderColor(element.getBorderColor());
                this.set_border_thickness.setImageThickness(element.getBorderThickness());
                this.set_bounds.setField(element);
                if (this.report != null) {
                    this.report.setIsApplyBoundSelected(!this.useDefaultImageSize);
                    if (!this.useDefaultImageSize) {
                        this.set_bounds.setImageBounds();
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import image", ex);
            }
        }
    }

    private void importChart(ReportElement element) {
        if (element != null) {
            try {
                this.set_border_color.setChartBorderColor(element.getBorderColor());
                this.set_border_thickness.setChartThickness(element.getBorderThickness());
                this.set_bounds.setField(element);
                this.set_bounds.setChartBounds();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import chart", ex);
            }
        }
    }

    private void importStringFormula(ReportCell element) {
        if (element != null) {
            try {
                this.set_font_color.setFormulaFontColor(element.getFontColor());
                this.set_font.setFormulaFont(this.resizeFont(element.getFont(), this.resize), element.isUnderline());
                this.set_background_color.setFormulaBackground(element.getBgColor());
                this.set_border_color.setFormulaBorderColor(element.getBorderColor());
                this.set_border_thickness.setFormulaThickness(element.getBorderThickness());
                this.set_alignment.setFormulaAlignment(element.getAlign(), element.getVAlign());
                this.set_rotation.setFormulaRotation(element.getRotateAngle());
                this.set_bounds.setField(element);
                this.set_bounds.setFormulaBounds();
                this.set_format.setFormulaFormat(new StringFormat(), element.getDataFormat());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import string formula", ex);
            }
        }
    }

    private void importLogicalFormula(ReportCell element) {
        if (element != null) {
            try {
                this.set_format.setFormulaFormat(new LogicalFormat(1), element.getDataFormat());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import logical formula", ex);
            }
        }
    }

    private void importNumericFormula(ReportCell element) {
        if (element != null) {
            try {
                this.set_format.setFormulaFormat(new NumericFormat(), element.getDataFormat());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import numeric formula", ex);
            }
        }
    }

    private void importDateTimeFormula(ReportCell element) {
        if (element != null) {
            try {
                this.set_format.setFormulaFormat(new DateTimeFormat(), element.getDataFormat());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import date formula", ex);
            }
        }
    }

    private void importStringColumn(ReportColumn element) {
        if (element != null) {
            try {
                this.set_font_color.setColumnFontColor(element.getFontColor());
                this.set_font.setColumnFont(this.resizeFont(element.getFont(), this.resize), element.isUnderline());
                this.set_background_color.setColumnBackground(element.getBgColor());
                this.set_border_color.setColumnBorderColor(element.getBorderColor());
                this.set_border_thickness.setColumnThickness(element.getBorderThickness());
                this.set_alignment.setColumnAlignment(element.getAlign(), element.getVAlign());
                this.set_rotation.setColumnRotation(element.getRotateAngle());
                this.set_bounds.setField(element);
                this.set_bounds.setColumnBounds();
                this.set_format.setColumnFormat(new StringFormat(), element.getDataFormat());
                this.set_dual_colors.setColumnDualColors(element.getAlternateRow(), element.isDualColorOnRowBreak(), element.getBgColor2(), element.getFontColor2(), this.resizeFont(element.getFont2(), this.resize), element.isUnderline2());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import string column", ex);
            }
        }
    }

    private void importLogicalColumn(ReportCell element) {
        if (element != null) {
            try {
                this.set_format.setColumnFormat(new LogicalFormat(1), element.getDataFormat());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import logical column", ex);
            }
        }
    }

    private void importNumericColumn(ReportCell element) {
        if (element != null) {
            try {
                this.set_format.setColumnFormat(new NumericFormat(), element.getDataFormat());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import numeric column", ex);
            }
        }
    }

    private void importDateTimeColumn(ReportCell element) {
        if (element != null) {
            try {
                this.set_format.setColumnFormat(new DateTimeFormat(), element.getDataFormat());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import datetime column", ex);
            }
        }
    }

    private void importGrid(ReportGrid element) {
        if (element != null) {
            try {
                this.set_border_color.setGridBorderColor(element.getBorderColor());
                this.set_border_thickness.setGridThickness(element.getBorderThickness());
                this.set_background_color.setGridBackground(element.getBgColor());
                this.set_line_style.setGridStyle(element.getGridStyle());
                this.set_bounds.setField(element);
                this.set_bounds.setGridBounds();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import grid", ex);
            }
        }
    }

    public void importLine(ReportLine element) {
        if (element != null) {
            try {
                this.set_background_color.setLineBackground(element.getBgColor());
                this.set_line_style.setLineStyle(element.getLineStyle());
                this.set_bounds.setImported(this.imported);
                this.set_bounds.setField(element);
                this.set_bounds.setLineBounds();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import line", ex);
            }
        }
    }

    private static DataInputStream getInputStreamFromServer(String file) throws Exception {
        byte[] indata;
        file = file.replace('\\', '/');
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(25579);
        IOUtil.writeString(dout, file);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot get input stream from server", ex);
            socket.close();
            throw ex;
        }
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int len = dstream.readInt();
            indata = new byte[len];
            dstream.readFully(indata, 0, len);
            dstream.close();
            socket.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot get server response", ex);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            throw ex;
        }
        catch (Error err) {
            LOGGER.log(Level.FINE, "Cannot get server response", err);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            throw new Exception(err.getMessage());
        }
        return new DataInputStream(new ByteArrayInputStream(indata));
    }
}

