/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer.globalformat;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportTitle;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.util.DateTimeFormat;
import quadbase.reportdesigner.util.LocaleDateTimeFormat;
import quadbase.reportdesigner.util.LocaleNumericFormat;
import quadbase.reportdesigner.util.LogicalFormat;
import quadbase.reportdesigner.util.NumericFormat;
import quadbase.reportdesigner.util.StringFormat;

public class ImportGlobalFormatHelper {
    private static final Logger LOGGER = Logger.getLogger(ImportGlobalFormatHelper.class.getName());

    public byte[] getInputStream(String path) throws IOException {
        if (path == null || path.trim().equals("")) {
            throw new IOException("No file name selected !");
        }
        try (InputStream istream = null;){
            istream = new ReadDataFile().getInputStream(null, path);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(istream);
            byte[] byArray = this.importXMLDocument(document);
            return byArray;
        }
    }

    private byte[] importXMLDocument(Document document) throws Exception {
        boolean useDefaultImageSize = true;
        boolean isAdjustFont = false;
        ReportElement label = null;
        ReportElement image = null;
        ReportElement chart = null;
        ColumnHeader columnHeader = null;
        ReportTitle title = null;
        ReportElement[] formula = new ReportElement[4];
        ReportElement[] column = new ReportElement[4];
        ReportLine line = null;
        ReportGrid grid = null;
        if (document != null) {
            NodeList nlist = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nlist.getLength(); ++i) {
                Node tempnode = nlist.item(i);
                if (tempnode == null) continue;
                String nodename = tempnode.getNodeName();
                if (nodename.equals("AdjustViewerFont")) {
                    String str = XMLUtil.readText(tempnode);
                    isAdjustFont = XMLUtil.parseBoolean(str);
                }
                if (nodename.equals("Label")) {
                    label = new ReportCell();
                    this.importElement(tempnode, label);
                }
                if (nodename.equals("ColumnHeader")) {
                    columnHeader = new ColumnHeader();
                    this.importElement(tempnode, columnHeader);
                }
                if (nodename.equals("Title")) {
                    title = new ReportTitle();
                    this.importElement(tempnode, title);
                }
                if (nodename.equals("Image")) {
                    Node temp;
                    image = new ReportImage();
                    this.importElement(tempnode, image);
                    NamedNodeMap map = tempnode.getAttributes();
                    if (map != null && (temp = map.getNamedItem("UseDefaultSize")) != null) {
                        useDefaultImageSize = Boolean.valueOf(temp.getNodeValue());
                    }
                }
                if (nodename.equals("Chart")) {
                    chart = new ReportChartObject();
                    this.importElement(tempnode, chart);
                }
                if (nodename.equals("Formula")) {
                    formula[0] = new ReportCell();
                    ((ReportCell)formula[0]).setDataFormat(new StringFormat());
                    this.importFormula(tempnode, formula);
                }
                if (nodename.equals("Column")) {
                    column[0] = new ReportColumn();
                    ((ReportColumn)column[0]).setDataFormat(new StringFormat());
                    this.importColumn(tempnode, column);
                }
                if (nodename.equals("Line")) {
                    line = new ReportLine();
                    this.importElement(tempnode, line);
                }
                if (!nodename.equals("Grid")) continue;
                grid = new ReportGrid();
                this.importElement(tempnode, grid);
            }
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        out.writeInt(7004);
        out.writeBoolean(isAdjustFont);
        if (label != null) {
            out.writeBoolean(true);
            label.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (columnHeader != null) {
            out.writeBoolean(true);
            columnHeader.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (title != null) {
            out.writeBoolean(true);
            title.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (image != null) {
            out.writeBoolean(true);
            image.write(out);
            out.writeBoolean(useDefaultImageSize);
        } else {
            out.writeBoolean(false);
        }
        if (chart != null) {
            out.writeBoolean(true);
            chart.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (formula[0] != null) {
            out.writeBoolean(true);
            formula[0].write(out);
        } else {
            out.writeBoolean(false);
        }
        if (formula[1] != null) {
            out.writeBoolean(true);
            formula[1].write(out);
        } else {
            out.writeBoolean(false);
        }
        if (formula[2] != null) {
            out.writeBoolean(true);
            formula[2].write(out);
        } else {
            out.writeBoolean(false);
        }
        if (formula[3] != null) {
            out.writeBoolean(true);
            formula[3].write(out);
        } else {
            out.writeBoolean(false);
        }
        if (column[0] != null) {
            out.writeBoolean(true);
            column[0].write(out);
        } else {
            out.writeBoolean(false);
        }
        if (column[1] != null) {
            out.writeBoolean(true);
            column[1].write(out);
        } else {
            out.writeBoolean(false);
        }
        if (column[2] != null) {
            out.writeBoolean(true);
            column[2].write(out);
        } else {
            out.writeBoolean(false);
        }
        if (column[3] != null) {
            out.writeBoolean(true);
            column[3].write(out);
        } else {
            out.writeBoolean(false);
        }
        if (line != null) {
            out.writeBoolean(true);
            line.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (grid != null) {
            out.writeBoolean(true);
            grid.write(out);
        } else {
            out.writeBoolean(false);
        }
        out.flush();
        out.close();
        fstream.close();
        return fstream.toByteArray();
    }

    private void importElement(Node labelnode, ReportElement label) {
        if (labelnode != null) {
            NamedNodeMap nnm = labelnode.getAttributes();
            this.processAttributes(nnm, label);
        }
    }

    private void importFormula(Node formulanode, ReportElement[] elements) {
        if (formulanode != null) {
            NamedNodeMap nnm = formulanode.getAttributes();
            this.processAttributes(nnm, elements[0]);
            this.processFormat(formulanode, elements);
        }
    }

    private void importColumn(Node columnnode, ReportElement[] elements) {
        if (columnnode != null) {
            String fonttype = "Dialog";
            int fontstyle = 0;
            int fontsize = 9;
            Color fontcolor = Color.black;
            int rowindex = 0;
            NamedNodeMap nnm = columnnode.getAttributes();
            this.processAttributes(nnm, elements[0]);
            if (nnm != null) {
                Node temp;
                try {
                    temp = nnm.getNamedItem("FontColor2");
                    if (temp != null) {
                        fontcolor = new Color(Integer.parseInt(temp.getNodeValue()));
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.FINER, "Failed to import FontColor2: Invalid number", e);
                }
                temp = nnm.getNamedItem("FontType2");
                if (temp != null) {
                    String[] fontList;
                    for (String element : fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                        if (!element.equals(temp.getNodeValue())) continue;
                        fonttype = element;
                    }
                }
                try {
                    temp = nnm.getNamedItem("FontStyle2");
                    if (temp != null) {
                        fontstyle = Integer.parseInt(temp.getNodeValue());
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.FINER, "Failed to import FontStyle2: Invalid number", e);
                }
                try {
                    temp = nnm.getNamedItem("FontSize2");
                    if (temp != null) {
                        fontsize = Integer.parseInt(temp.getNodeValue());
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.FINER, "Failed to import FontSize2: Invalid number", e);
                }
                try {
                    Font newfont = new Font(fonttype, fontstyle, fontsize);
                    ((ReportColumn)elements[0]).setFont2(newfont);
                    ((ReportColumn)elements[0]).setFontColor2(fontcolor);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINER, "Failed to apply font settings", ex);
                }
                try {
                    temp = nnm.getNamedItem("BackgroundColor2");
                    if (temp != null) {
                        String colorstr = temp.getNodeValue();
                        Color bgcolor = null;
                        if (!colorstr.equalsIgnoreCase("null")) {
                            bgcolor = new Color(Integer.parseInt(colorstr));
                        }
                        ((ReportColumn)elements[0]).setBgColor2(bgcolor);
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.FINER, "Failed to import BgColor2: Invalid number", e);
                }
                try {
                    temp = nnm.getNamedItem("AlternateRow");
                    if (temp != null) {
                        rowindex = Integer.parseInt(temp.getNodeValue());
                        if (rowindex < 0) {
                            rowindex = 0;
                        }
                        ((ReportColumn)elements[0]).setAlternateRow(rowindex);
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.FINER, "Failed to import AlternateRow: Invalid number", e);
                }
            }
            this.processFormat(columnnode, elements);
        }
    }

    private void processAttributes(NamedNodeMap nnm, ReportElement defaultsetting) {
        if (nnm != null) {
            String str;
            Color color;
            String colorstr;
            Node temp;
            try {
                temp = nnm.getNamedItem("FontColor");
                if (temp != null) {
                    defaultsetting.setFontColor(new Color(Integer.parseInt(temp.getNodeValue())));
                }
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Failed to import FontColor", e);
            }
            String fonttype = "Dialog";
            int fontstyle = 0;
            int fontsize = 9;
            temp = nnm.getNamedItem("FontType");
            if (temp != null) {
                String[] fontList;
                for (String element : fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                    if (!element.equals(temp.getNodeValue())) continue;
                    fonttype = element;
                }
            }
            try {
                temp = nnm.getNamedItem("FontStyle");
                if (temp != null) {
                    fontstyle = Integer.parseInt(temp.getNodeValue());
                }
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Failed to import font style", e);
            }
            try {
                temp = nnm.getNamedItem("FontSize");
                if (temp != null) {
                    fontsize = Integer.parseInt(temp.getNodeValue());
                }
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Failed to import font size", e);
            }
            try {
                Font newfont = new Font(fonttype, fontstyle, fontsize);
                defaultsetting.setFont(newfont);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to apply font settings", ex);
            }
            try {
                temp = nnm.getNamedItem("BackgroundColor");
                if (temp != null) {
                    colorstr = temp.getNodeValue();
                    color = null;
                    if (!colorstr.equalsIgnoreCase("null")) {
                        color = new Color(Integer.parseInt(colorstr));
                    }
                    defaultsetting.setBgColor(color);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Failed to import BackgroundColor", e);
            }
            try {
                temp = nnm.getNamedItem("BorderColor");
                if (temp != null) {
                    colorstr = temp.getNodeValue();
                    color = null;
                    if (!colorstr.equalsIgnoreCase("null")) {
                        color = new Color(Integer.parseInt(colorstr));
                    }
                    defaultsetting.setBorderColor(color);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Failed to import BorderColor", e);
            }
            try {
                temp = nnm.getNamedItem("BorderThickness");
                if (temp != null) {
                    int bthickness = Integer.parseInt(temp.getNodeValue());
                    if (bthickness < 0) {
                        bthickness = 0;
                    }
                    defaultsetting.setBorderThickness(bthickness);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Failed to import BorderThickness", e);
            }
            try {
                temp = nnm.getNamedItem("Alignment");
                if (temp != null) {
                    short align = Short.parseShort(temp.getNodeValue());
                    if (align != 1 && align != 2 && align != 0) {
                        align = 0;
                    }
                    defaultsetting.setAlign(align);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Failed to import horizontal alignment", e);
            }
            try {
                temp = nnm.getNamedItem("AlignmentVertical");
                if (temp != null) {
                    short align = Short.parseShort(temp.getNodeValue());
                    if (align != 1 && align != 2 && align != 0) {
                        align = 0;
                    }
                    defaultsetting.setVAlign(align);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Failed to import vertical alignment", e);
            }
            double width = 1.0;
            double height = 0.3;
            if (defaultsetting instanceof ReportLine) {
                height = QbUtil.toInch(1.0) + 0.02;
            }
            try {
                temp = nnm.getNamedItem("Width");
                if (temp == null) {
                    temp = nnm.getNamedItem("Length");
                }
                if (temp != null) {
                    width = Double.parseDouble(temp.getNodeValue());
                }
                if ((temp = nnm.getNamedItem("Thickness")) != null) {
                    height = Double.parseDouble(temp.getNodeValue());
                } else {
                    temp = nnm.getNamedItem("Height");
                    if (temp != null) {
                        height = Double.parseDouble(temp.getNodeValue());
                    }
                }
                defaultsetting.setWidth(width);
                defaultsetting.setHeight(height);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import bounds", ex);
            }
            try {
                temp = nnm.getNamedItem("LineStyle");
                if (temp != null) {
                    String styletext = temp.getNodeValue();
                    int style = 1;
                    if (styletext.equalsIgnoreCase("double")) {
                        style = 2;
                    } else if (styletext.equalsIgnoreCase("dash")) {
                        style = 3;
                    }
                    if (defaultsetting instanceof ReportLine) {
                        ((ReportLine)defaultsetting).setLineStyle(style);
                    } else if (defaultsetting instanceof ReportGrid) {
                        ((ReportGrid)defaultsetting).setGridStyle(style);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import line style", ex);
            }
            try {
                temp = nnm.getNamedItem("MatchColumnWidthS");
                if (temp != null) {
                    str = temp.getNodeValue();
                    boolean match = XMLUtil.parseBoolean(str);
                    if (defaultsetting instanceof ReportLine) {
                        ((ReportLine)defaultsetting).setMatchColumnWidths(match);
                    } else if (defaultsetting instanceof ReportGrid) {
                        ((ReportGrid)defaultsetting).setMatchColumnWidths(match);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import 'match column widths' settings", ex);
            }
            try {
                temp = nnm.getNamedItem("AutoResize");
                if (temp != null) {
                    boolean autoResize;
                    str = temp.getNodeValue();
                    ((ReportTitle)defaultsetting).autoResize = autoResize = XMLUtil.parseBoolean(str);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import 'auto resize' settings", ex);
            }
            try {
                temp = nnm.getNamedItem("Position");
                if (temp != null) {
                    int position;
                    str = temp.getNodeValue();
                    ((ReportTitle)defaultsetting).position = position = Integer.parseInt(str);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import 'position' settings", ex);
            }
            try {
                temp = nnm.getNamedItem("Rotation");
                if (temp != null) {
                    str = temp.getNodeValue();
                    double rotation = Double.parseDouble(str);
                    defaultsetting.setRotateAngle(rotation);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to import 'rotation' settings", ex);
            }
        }
    }

    private void processFormat(Node formulanode, ReportElement[] elements) {
        NodeList nlist = formulanode.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            String nodename;
            Node formatattr;
            block23: {
                Node formatnode = nlist.item(i);
                formatattr = null;
                NamedNodeMap nnmap = formatnode.getAttributes();
                if (nnmap != null) {
                    formatattr = nnmap.getNamedItem("Format");
                }
                nodename = formatnode.getNodeName();
                if (formatattr == null) continue;
                if (nodename.equals("String")) {
                    try {
                        if (elements[0] instanceof ReportCell) {
                            ((ReportCell)elements[0]).setDataFormat(StringFormat.createFormat(formatattr.getNodeValue()));
                        } else if (elements[0] instanceof ReportColumn) {
                            ((ReportColumn)elements[0]).setDataFormat(StringFormat.createFormat(formatattr.getNodeValue()));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINEST, "Failed to process data format, using String", e);
                        if (elements[0] instanceof ReportCell) {
                            ((ReportCell)elements[0]).setDataFormat(new StringFormat());
                        }
                        if (!(elements[0] instanceof ReportColumn)) break block23;
                        ((ReportColumn)elements[0]).setDataFormat(new StringFormat());
                    }
                }
            }
            if (nodename.equals("Logical")) {
                try {
                    elements[1] = new ReportCell();
                    ((ReportCell)elements[1]).setDataFormat(LogicalFormat.createFormat(formatattr.getNodeValue()));
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINER, "Failed to process LogicalFormat", e);
                    elements[1] = null;
                }
            }
            if (nodename.equals("Numeric")) {
                try {
                    elements[2] = new ReportCell();
                    ((ReportCell)elements[2]).setDataFormat(NumericFormat.createFormat(formatattr.getNodeValue()));
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINER, "Failed to process NumericFormat", e);
                    elements[2] = null;
                }
            }
            if (nodename.equals("LocaleNumeric")) {
                try {
                    elements[2] = new ReportCell();
                    ((ReportCell)elements[2]).setDataFormat(LocaleNumericFormat.createFormat(formatattr.getNodeValue()));
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINER, "Failed to process LocaleNumericFormat", e);
                    elements[2] = null;
                }
            }
            if (nodename.equals("DateTime")) {
                try {
                    elements[3] = new ReportCell();
                    ((ReportCell)elements[3]).setDataFormat(DateTimeFormat.createFormat(formatattr.getNodeValue()));
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINER, "Failed to process DatetimeFormat", e);
                    elements[3] = null;
                }
            }
            if (!nodename.equals("LocaleDateTime")) continue;
            try {
                elements[3] = new ReportCell();
                ((ReportCell)elements[3]).setDataFormat(LocaleDateTimeFormat.createFormat(formatattr.getNodeValue()));
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, "Failed to process LocateDatetimeFormat", e);
                elements[3] = null;
            }
        }
    }
}

