/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.lang;

import quadbase.reportdesigner.lang.DateTimeObject;
import quadbase.reportdesigner.lang.IObject;
import quadbase.reportdesigner.lang.NumericObject;
import quadbase.reportdesigner.lang.ObjectBasic;
import quadbase.reportdesigner.lang.StringObject;
import quadbase.reportdesigner.util.IAggregateConstants;
import quadbase.util.IFunctionConstants;

public class BooleanObject
extends ObjectBasic
implements IObject,
IFunctionConstants {
    private String formula = null;

    public BooleanObject(boolean state) {
        this.formula = DECL[7] + "(" + (state ? "true" : "false") + ")";
    }

    protected BooleanObject(String formula) {
        this.formula = formula;
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    @Override
    public int getSQLType() {
        return -7;
    }

    public static BooleanObject getColumnValue(int colInfoIndex) {
        return BooleanObject.getColumnValue(new NumericObject(colInfoIndex));
    }

    public static BooleanObject getColumnValue(NumericObject colInfoIndex) {
        return BooleanObject.buildBOOL(DECL[3], colInfoIndex);
    }

    public static BooleanObject getColumnValue(int colInfoIndex, short aggregation) {
        return BooleanObject.getColumnValue(new NumericObject(colInfoIndex), aggregation);
    }

    public static BooleanObject getColumnValue(NumericObject colInfoIndex, short aggregation) {
        return BooleanObject.buildBOOL(DECL[3], (IObject)colInfoIndex, IAggregateConstants.AGGR[aggregation]);
    }

    public static BooleanObject withIn(IObject lower, IObject upper, IObject obj) {
        return BooleanObject.buildBOOL(BOOL_FUNC[0], lower, upper, obj);
    }

    public static BooleanObject greaterThanEqualTo(IObject a, IObject b) {
        return BooleanObject.buildBOOL(BOOL_FUNC[1], a, b);
    }

    public static BooleanObject lessThanEqualTo(IObject a, IObject b) {
        return BooleanObject.buildBOOL(BOOL_FUNC[2], a, b);
    }

    public static BooleanObject equals(IObject a, IObject b) {
        return BooleanObject.buildBOOL(BOOL_FUNC[3], a, b);
    }

    public static BooleanObject greaterThan(IObject a, IObject b) {
        return BooleanObject.buildBOOL(BOOL_FUNC[4], a, b);
    }

    public static BooleanObject lessThan(IObject a, IObject b) {
        return BooleanObject.buildBOOL(BOOL_FUNC[5], a, b);
    }

    public static BooleanObject not(BooleanObject a) {
        return BooleanObject.buildBOOL(BOOL_FUNC[6], a);
    }

    public static BooleanObject xnor(BooleanObject a, BooleanObject b) {
        return BooleanObject.buildBOOL(BOOL_FUNC[7], (IObject)a, b);
    }

    public static BooleanObject xor(BooleanObject a, BooleanObject b) {
        return BooleanObject.buildBOOL(BOOL_FUNC[8], (IObject)a, b);
    }

    public static BooleanObject nand(BooleanObject a, BooleanObject b) {
        return BooleanObject.buildBOOL(BOOL_FUNC[9], (IObject)a, b);
    }

    public static BooleanObject nor(BooleanObject a, BooleanObject b) {
        return BooleanObject.buildBOOL(BOOL_FUNC[10], (IObject)a, b);
    }

    public static BooleanObject and(BooleanObject a, BooleanObject b) {
        return BooleanObject.buildBOOL(BOOL_FUNC[11], (IObject)a, b);
    }

    public static BooleanObject and(BooleanObject[] f) {
        return BooleanObject.buildBOOL(BOOL_FUNC[11], f);
    }

    public static BooleanObject or(BooleanObject a, BooleanObject b) {
        return BooleanObject.buildBOOL(BOOL_FUNC[12], (IObject)a, b);
    }

    public static BooleanObject or(BooleanObject[] f) {
        return BooleanObject.buildBOOL(BOOL_FUNC[12], f);
    }

    public static BooleanObject ifElse(BooleanObject exp, BooleanObject ifState, BooleanObject elseState) {
        return BooleanObject.buildBOOL(BOOL_FUNC[13], exp, ifState, elseState);
    }

    public static NumericObject ifElse(BooleanObject exp, NumericObject ifState, NumericObject elseState) {
        return BooleanObject.buildNUM(NUM_FUNC[40], exp, ifState, elseState);
    }

    public static StringObject ifElse(BooleanObject exp, StringObject ifState, StringObject elseState) {
        return BooleanObject.buildSTR(STR_FUNC[18], exp, ifState, elseState);
    }

    public static DateTimeObject ifElse(BooleanObject exp, DateTimeObject ifState, DateTimeObject elseState) {
        return BooleanObject.buildDATE(DATE_FUNC[5], (IObject)exp, ifState, (IObject)elseState);
    }
}

