/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.lang;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import quadbase.reportdesigner.lang.IObject;
import quadbase.reportdesigner.lang.NumericObject;
import quadbase.reportdesigner.lang.ObjectBasic;
import quadbase.reportdesigner.lang.StringObject;
import quadbase.reportdesigner.util.IAggregateConstants;
import quadbase.util.IFunctionConstants;

public class DateTimeObject
extends ObjectBasic
implements IObject,
IFunctionConstants {
    private String formula = null;
    private int sqlType = 93;

    public DateTimeObject(String date) {
        boolean isTime;
        this.formula = DECL[6] + "(" + date + ")";
        boolean isDate = this.formula.indexOf(47) >= 0;
        boolean bl = isTime = this.formula.indexOf(58) >= 0;
        this.sqlType = isDate && !isTime ? 91 : (isTime && !isDate ? 92 : 93);
    }

    public DateTimeObject(StringObject date) {
        boolean isTime;
        this.formula = DECL[6] + "(" + date.getFormula() + ")";
        boolean isDate = this.formula.indexOf(47) >= 0;
        boolean bl = isTime = this.formula.indexOf(58) >= 0;
        this.sqlType = isDate && !isTime ? 91 : (isTime && !isDate ? 92 : 93);
    }

    public DateTimeObject(Date date) {
        this(DateTimeObject.convertDate(date));
    }

    protected DateTimeObject(String formula, int sqlType) {
        this.formula = formula;
        this.sqlType = sqlType;
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    @Override
    public int getSQLType() {
        return this.sqlType;
    }

    public static DateTimeObject getColumnValue(int colInfoIndex) {
        return DateTimeObject.getColumnValue(colInfoIndex, 93);
    }

    public static DateTimeObject getColumnValue(int colInfoIndex, int sqlType) {
        return DateTimeObject.getColumnValue(new NumericObject(colInfoIndex), sqlType);
    }

    public static DateTimeObject getColumnValue(NumericObject colInfoIndex, int sqlType) {
        return DateTimeObject.buildDATECOL(DECL[2], colInfoIndex, sqlType);
    }

    public static DateTimeObject getColumnValue(int colInfoIndex, short aggregation) {
        return DateTimeObject.getColumnValue(new NumericObject(colInfoIndex), aggregation, 93);
    }

    public static DateTimeObject getColumnValue(int colInfoIndex, short aggregation, int sqlType) {
        return DateTimeObject.getColumnValue(new NumericObject(colInfoIndex), aggregation, sqlType);
    }

    public static DateTimeObject getColumnValue(NumericObject colInfoIndex, short aggregation, int sqlType) {
        return DateTimeObject.buildDATECOL(DECL[2], colInfoIndex, IAggregateConstants.AGGR[aggregation], sqlType);
    }

    public static DateTimeObject getCurrentDateTime() {
        return DateTimeObject.buildDATE(DATE_FUNC[0], 93);
    }

    public static DateTimeObject getCurrentDate() {
        return DateTimeObject.buildDATE(DATE_FUNC[1], 91);
    }

    public static DateTimeObject getCurrentTime() {
        return DateTimeObject.buildDATE(DATE_FUNC[2], 92);
    }

    public static DateTimeObject add(DateTimeObject date, short calendarField, NumericObject amt) {
        return DateTimeObject.buildDATE(DATE_FUNC[3], (IObject)date, CALENDAR_CONST[calendarField], (IObject)amt);
    }

    public static DateTimeObject roll(DateTimeObject date, short calendarField, NumericObject amt) {
        return DateTimeObject.buildDATE(DATE_FUNC[4], (IObject)date, CALENDAR_CONST[calendarField], (IObject)amt);
    }

    public static NumericObject getDateTime(DateTimeObject date, short calendarField) {
        return DateTimeObject.buildNUM(NUM_FUNC[38], (IObject)date, CALENDAR_CONST[calendarField]);
    }

    public static NumericObject getDayDifference(DateTimeObject date1, DateTimeObject date2) {
        return DateTimeObject.buildNUM(NUM_FUNC[39], (IObject)date1, date2);
    }

    public static StringObject getDayOfWeek(DateTimeObject date) {
        return DateTimeObject.buildSTR(STR_FUNC[11], date);
    }

    public static StringObject getMonth(DateTimeObject date) {
        return DateTimeObject.buildSTR(STR_FUNC[12], date);
    }

    public static StringObject getAmPm(DateTimeObject date) {
        return DateTimeObject.buildSTR(STR_FUNC[13], date);
    }

    public static StringObject getERA(DateTimeObject date) {
        return DateTimeObject.buildSTR(STR_FUNC[14], date);
    }

    public static StringObject printDateTime(DateTimeObject date) {
        return DateTimeObject.buildSTR(STR_FUNC[15], date);
    }

    public static StringObject printDateTime(DateTimeObject date, StringObject pattern) {
        return DateTimeObject.buildSTR(STR_FUNC[15], (IObject)date, pattern);
    }

    public static StringObject printTime(DateTimeObject date) {
        return DateTimeObject.buildSTR(STR_FUNC[16], date);
    }

    public static StringObject printTime(DateTimeObject date, StringObject pattern) {
        return DateTimeObject.buildSTR(STR_FUNC[16], (IObject)date, pattern);
    }

    public static StringObject printDate(DateTimeObject date) {
        return DateTimeObject.buildSTR(STR_FUNC[17], date);
    }

    public static StringObject printDate(DateTimeObject date, StringObject pattern) {
        return DateTimeObject.buildSTR(STR_FUNC[17], (IObject)date, pattern);
    }

    private static String convertDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String str = "";
        if (!(date instanceof Time)) {
            str = cal.get(2) + 1 + "/" + cal.get(5) + "/" + cal.get(1);
            if (date instanceof java.sql.Date) {
                return str;
            }
            str = str + " ";
        }
        str = str + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
        if (date instanceof Timestamp) {
            str = str + ":" + cal.get(14);
        }
        return str;
    }
}

