/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.lang;

import quadbase.reportdesigner.lang.BooleanObject;
import quadbase.reportdesigner.lang.IObject;
import quadbase.reportdesigner.lang.ObjectBasic;
import quadbase.reportdesigner.lang.StringObject;
import quadbase.reportdesigner.util.IAggregateConstants;
import quadbase.util.IFunctionConstants;

public class NumericObject
extends ObjectBasic
implements IObject,
IFunctionConstants {
    private String formula = null;
    private int sqlType = 4;

    public NumericObject(short number) {
        this.formula = DECL[4] + "(" + number + ")";
        this.sqlType = 5;
    }

    public NumericObject(int number) {
        this.formula = DECL[4] + "(" + number + ")";
        this.sqlType = 4;
    }

    public NumericObject(long number) {
        this.formula = DECL[4] + "(" + number + ")";
        this.sqlType = -5;
    }

    public NumericObject(float number) {
        this.formula = DECL[4] + "(" + number + ")";
        this.sqlType = 8;
    }

    public NumericObject(double number) {
        this.formula = DECL[4] + "(" + number + ")";
        this.sqlType = 8;
    }

    public NumericObject(byte val) {
        this.formula = DECL[4] + "(" + Byte.valueOf(val).doubleValue() + ")";
        this.sqlType = -6;
    }

    protected NumericObject(String formula, int sqlType) {
        this.formula = formula;
        this.sqlType = sqlType;
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    @Override
    public int getSQLType() {
        return this.sqlType;
    }

    public static NumericObject getColumnValue(int colInfoIndex) {
        return NumericObject.getColumnValue(new NumericObject(colInfoIndex), 8);
    }

    public static NumericObject getColumnValue(int colInfoIndex, int sqlType) {
        return NumericObject.getColumnValue(new NumericObject(colInfoIndex), sqlType);
    }

    public static NumericObject getColumnValue(NumericObject colInfoIndex, int sqlType) {
        return NumericObject.buildNUMCOL(DECL[0], colInfoIndex, sqlType);
    }

    public static NumericObject getColumnValue(int colInfoIndex, short aggregation) {
        return NumericObject.getColumnValue(new NumericObject(colInfoIndex), aggregation, 8);
    }

    public static NumericObject getColumnValue(int colInfoIndex, short aggregation, int sqlType) {
        return NumericObject.getColumnValue(new NumericObject(colInfoIndex), aggregation, sqlType);
    }

    public static NumericObject getColumnValue(NumericObject colInfoIndex, short aggregation, int sqlType) {
        return NumericObject.buildNUMCOL(DECL[0], colInfoIndex, IAggregateConstants.AGGR[aggregation], sqlType);
    }

    public static NumericObject add(NumericObject f1, NumericObject f2) {
        return NumericObject.buildNUM(NUM_FUNC[0], (IObject)f1, f2);
    }

    public static NumericObject add(NumericObject[] f) {
        return NumericObject.buildNUM(NUM_FUNC[0], f);
    }

    public static NumericObject subtract(NumericObject f1, NumericObject f2) {
        return NumericObject.buildNUM(NUM_FUNC[1], (IObject)f1, f2);
    }

    public static NumericObject subtract(NumericObject[] f) {
        return NumericObject.buildNUM(NUM_FUNC[1], f);
    }

    public static NumericObject multiply(NumericObject f1, NumericObject f2) {
        return NumericObject.buildNUM(NUM_FUNC[2], (IObject)f1, f2);
    }

    public static NumericObject multiply(NumericObject[] f) {
        return NumericObject.buildNUM(NUM_FUNC[2], f);
    }

    public static NumericObject divide(NumericObject numerator, NumericObject denominator) {
        return NumericObject.buildNUM(NUM_FUNC[3], (IObject)numerator, denominator);
    }

    public static NumericObject mod(NumericObject numerator, NumericObject denominator) {
        return NumericObject.buildNUM(NUM_FUNC[4], (IObject)numerator, denominator);
    }

    public static NumericObject IEEERemainder(NumericObject dividend, NumericObject divisor) {
        return NumericObject.buildNUM(NUM_FUNC[5], (IObject)dividend, divisor);
    }

    public static NumericObject acos(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[6], a);
    }

    public static NumericObject cos(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[7], a);
    }

    public static NumericObject asin(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[8], a);
    }

    public static NumericObject sin(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[9], a);
    }

    public static NumericObject atan(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[10], a);
    }

    public static NumericObject atan2(NumericObject a, NumericObject b) {
        return NumericObject.buildNUM(NUM_FUNC[11], (IObject)a, b);
    }

    public static NumericObject tan(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[12], a);
    }

    public static NumericObject ceil(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[13], a);
    }

    public static NumericObject exp(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[14], a);
    }

    public static NumericObject floor(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[15], a);
    }

    public static NumericObject log(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[16], a);
    }

    public static NumericObject toDegrees(NumericObject angrad) {
        return NumericObject.buildNUM(NUM_FUNC[17], angrad);
    }

    public static NumericObject toRadians(NumericObject angdeg) {
        return NumericObject.buildNUM(NUM_FUNC[18], angdeg);
    }

    public static NumericObject pow(NumericObject a, NumericObject b) {
        return NumericObject.buildNUM(NUM_FUNC[19], (IObject)a, b);
    }

    public static NumericObject random() {
        return NumericObject.buildNUM(NUM_FUNC[20]);
    }

    public static NumericObject rint(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[21], a);
    }

    public static NumericObject sqrt(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[22], a);
    }

    public static NumericObject abs(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[23], a);
    }

    public static NumericObject max(NumericObject a, NumericObject b) {
        return NumericObject.buildNUM(NUM_FUNC[24], (IObject)a, b);
    }

    public static NumericObject max(NumericObject[] f) {
        return NumericObject.buildNUM(NUM_FUNC[24], f);
    }

    public static NumericObject min(NumericObject a, NumericObject b) {
        return NumericObject.buildNUM(NUM_FUNC[25], (IObject)a, b);
    }

    public static NumericObject min(NumericObject[] f) {
        return NumericObject.buildNUM(NUM_FUNC[25], f);
    }

    public static NumericObject pi() {
        return NumericObject.buildNUM(NUM_FUNC[26]);
    }

    public static NumericObject e() {
        return NumericObject.buildNUM(NUM_FUNC[27]);
    }

    public static NumericObject count(NumericObject[] f) {
        return NumericObject.buildNUM(NUM_FUNC[28], f);
    }

    public static NumericObject sumSquare(NumericObject[] f) {
        return NumericObject.buildNUM(NUM_FUNC[29], f);
    }

    public static NumericObject average(NumericObject[] f) {
        return NumericObject.buildNUM(NUM_FUNC[30], f);
    }

    public static NumericObject variance(NumericObject[] f) {
        return NumericObject.buildNUM(NUM_FUNC[31], f);
    }

    public static NumericObject standardDeviation(NumericObject[] f) {
        return NumericObject.buildNUM(NUM_FUNC[32], f);
    }

    public static NumericObject factorial(NumericObject a) {
        return NumericObject.buildNUM(NUM_FUNC[33], a);
    }

    public static StringObject toString(NumericObject a) {
        return NumericObject.buildSTR(STR_FUNC[10], a);
    }

    public static StringObject toString(NumericObject a, NumericObject dp) {
        return NumericObject.buildSTR(STR_FUNC[10], (IObject)a, dp);
    }

    public static StringObject toString(NumericObject a, NumericObject dp, BooleanObject rup) {
        return NumericObject.buildSTR(STR_FUNC[10], a, dp, rup);
    }
}

