/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.lang;

import quadbase.reportdesigner.lang.BooleanObject;
import quadbase.reportdesigner.lang.DateTimeObject;
import quadbase.reportdesigner.lang.IObject;
import quadbase.reportdesigner.lang.NumericObject;
import quadbase.reportdesigner.lang.StringObject;
import quadbase.reportdesigner.util.IFormat;

class ObjectBasic {
    ObjectBasic() {
    }

    static NumericObject buildNUMCOL(String func, IObject argv, int sqlType) {
        return new NumericObject(func + "(" + argv.getFormula() + ")", sqlType);
    }

    static NumericObject buildNUMCOL(String func, IObject a, String agg, int sqlType) {
        return new NumericObject(func + "(" + a.getFormula() + ", " + agg + ")", sqlType);
    }

    static NumericObject buildNUM(String func) {
        return new NumericObject(func + "()", 8);
    }

    static NumericObject buildNUM(String func, IObject argv) {
        return new NumericObject(func + "(" + argv.getFormula() + ")", argv.getSQLType());
    }

    static NumericObject buildNUM(String func, IObject a, String calField) {
        return new NumericObject(func + "(" + a.getFormula() + ", " + calField + ")", 4);
    }

    static NumericObject buildNUM(String func, IObject a, IObject b) {
        return ObjectBasic.buildNUM(func, new IObject[]{a, b});
    }

    static NumericObject buildNUM(String func, IObject a, IObject b, IObject c) {
        return ObjectBasic.buildNUM(func, new IObject[]{a, b, c});
    }

    static NumericObject buildNUM(String func, IObject[] argv) {
        String tmp = func + "(";
        int type = -6;
        block7: for (int i = 0; i < argv.length; ++i) {
            tmp = i == 0 ? tmp + argv[i].getFormula() : tmp + ", " + argv[i].getFormula();
            switch (argv[i].getSQLType()) {
                case 8: {
                    type = 8;
                }
                case 7: {
                    if (type == -5) {
                        type = argv[i].getSQLType();
                    }
                }
                case -5: {
                    if (type == 4) {
                        type = argv[i].getSQLType();
                    }
                }
                case 4: {
                    if (type == 5) {
                        type = argv[i].getSQLType();
                    }
                }
                case 5: {
                    if (type != -6) continue block7;
                    type = argv[i].getSQLType();
                }
            }
        }
        return new NumericObject(tmp + ")", type);
    }

    static StringObject buildSTR(String func) {
        return new StringObject().setFormula(func + "()");
    }

    static StringObject buildSTR(String func, IObject argv) {
        return new StringObject().setFormula(func + "(" + argv.getFormula() + ")");
    }

    static StringObject buildSTR(String func, IObject argv, IFormat format) {
        return ObjectBasic.buildSTR(func, argv, format.getTextFormat());
    }

    static StringObject buildSTR(String func, IObject argv, String agg) {
        return new StringObject().setFormula(func + "(" + argv.getFormula() + ", " + agg + ")");
    }

    static StringObject buildSTR(String func, IObject a, IObject b) {
        return ObjectBasic.buildSTR(func, new IObject[]{a, b});
    }

    static StringObject buildSTR(String func, IObject a, IObject b, IObject c) {
        return ObjectBasic.buildSTR(func, new IObject[]{a, b, c});
    }

    static StringObject buildSTR(String func, IObject a, IObject b, IObject c, IObject d) {
        return ObjectBasic.buildSTR(func, new IObject[]{a, b, c, d});
    }

    static StringObject buildSTR(String func, IObject[] argv) {
        String tmp = func + "(" + argv[0].getFormula();
        for (int i = 1; i < argv.length; ++i) {
            tmp = tmp + ", " + argv[i].getFormula();
        }
        return new StringObject().setFormula(tmp + ")");
    }

    static DateTimeObject buildDATECOL(String func, IObject argv, int sqlType) {
        return new DateTimeObject(func + "(" + argv.getFormula() + ")", sqlType);
    }

    static DateTimeObject buildDATECOL(String func, IObject argv, String agg, int sqlType) {
        return new DateTimeObject(func + "(" + argv.getFormula() + ", " + agg + ")", sqlType);
    }

    static DateTimeObject buildDATE(String func, int sqlType) {
        return new DateTimeObject(func + "()", sqlType);
    }

    static DateTimeObject buildDATE(String func, IObject argv) {
        return new DateTimeObject(func + "(" + argv.getFormula() + ")", argv.getSQLType());
    }

    static DateTimeObject buildDATE(String func, IObject a, IObject b, IObject c) {
        return ObjectBasic.buildDATE(func, new IObject[]{a, b, c});
    }

    static DateTimeObject buildDATE(String func, IObject a, String calField, IObject c) {
        return new DateTimeObject(func + "(" + a.getFormula() + ", " + calField + ", " + c.getFormula() + ")", a.getSQLType());
    }

    static DateTimeObject buildDATE(String func, IObject[] argv) {
        String tmp = func + "(";
        int type = 0;
        block3: for (int i = 0; i < argv.length; ++i) {
            tmp = i == 0 ? tmp + argv[i].getFormula() : tmp + ", " + argv[i].getFormula();
            switch (argv[i].getSQLType()) {
                case 91: 
                case 92: 
                case 93: {
                    if (type == 0) {
                        argv[i].getSQLType();
                        continue block3;
                    }
                    if (type == argv[i].getSQLType()) continue block3;
                    type = 93;
                }
            }
        }
        return new DateTimeObject(tmp + ")", type);
    }

    static BooleanObject buildBOOL(String func, IObject argv) {
        return new BooleanObject(func + "(" + argv.getFormula() + ")");
    }

    static BooleanObject buildBOOL(String func, IObject argv, String agg) {
        return new BooleanObject(func + "(" + argv.getFormula() + ", " + agg + ")");
    }

    static BooleanObject buildBOOL(String func, IObject a, IObject b) {
        return ObjectBasic.buildBOOL(func, new IObject[]{a, b});
    }

    static BooleanObject buildBOOL(String func, IObject a, IObject b, IObject c) {
        return ObjectBasic.buildBOOL(func, new IObject[]{a, b, c});
    }

    static BooleanObject buildBOOL(String func, IObject[] argv) {
        String tmp = func + "(" + argv[0].getFormula();
        for (int i = 1; i < argv.length; ++i) {
            tmp = tmp + ", " + argv[i].getFormula();
        }
        return new BooleanObject(tmp + ")");
    }
}

