/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.lang;

import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.lang.IObject;
import quadbase.reportdesigner.lang.NumericObject;
import quadbase.reportdesigner.lang.ObjectBasic;
import quadbase.reportdesigner.util.IAggregateConstants;
import quadbase.util.IFunctionConstants;

public class StringObject
extends ObjectBasic
implements IObject,
IFunctionConstants {
    private String formula = null;

    public StringObject(String str) {
        str = QbUtil.replace(str, "\"", "\\\"");
        this.formula = DECL[5] + "(\"" + QbUtil.replace(str, "\n", "\\n") + "\")";
    }

    protected StringObject() {
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    protected StringObject setFormula(String formula) {
        this.formula = formula;
        return this;
    }

    @Override
    public int getSQLType() {
        return 12;
    }

    public static StringObject getColumnValue(int colInfoIndex) {
        return StringObject.getColumnValue(new NumericObject(colInfoIndex));
    }

    public static StringObject getColumnValue(NumericObject colInfoIndex) {
        return StringObject.buildSTR(DECL[1], colInfoIndex);
    }

    public static StringObject getColumnValue(int colInfoIndex, short aggregation) {
        return StringObject.getColumnValue(new NumericObject(colInfoIndex), aggregation);
    }

    public static StringObject getColumnValue(NumericObject colInfoIndex, short aggregation) {
        return StringObject.buildSTR(DECL[1], (IObject)colInfoIndex, IAggregateConstants.AGGR[aggregation]);
    }

    public static StringObject toUpperCase(StringObject a) {
        return StringObject.buildSTR(STR_FUNC[0], a);
    }

    public static StringObject toLowerCase(StringObject a) {
        return StringObject.buildSTR(STR_FUNC[1], a);
    }

    public static StringObject setMaxLength(StringObject str, NumericObject maxLen) {
        return StringObject.buildSTR(STR_FUNC[2], (IObject)str, maxLen);
    }

    public static StringObject substring(StringObject str, NumericObject beginIndex) {
        return StringObject.buildSTR(STR_FUNC[3], (IObject)str, beginIndex);
    }

    public static StringObject substring(StringObject str, NumericObject beginIndex, NumericObject endIndex) {
        return StringObject.buildSTR(STR_FUNC[3], str, beginIndex, endIndex);
    }

    public static StringObject strcat(StringObject a, StringObject b) {
        return StringObject.buildSTR(STR_FUNC[4], (IObject)a, b);
    }

    public static StringObject strcat(StringObject[] str) {
        return StringObject.buildSTR(STR_FUNC[4], str);
    }

    public static StringObject replace(StringObject str, StringObject oldChars, StringObject newChars) {
        return StringObject.buildSTR(STR_FUNC[5], str, oldChars, newChars);
    }

    public static StringObject replace(StringObject str, NumericObject start, NumericObject end, StringObject newChars) {
        return StringObject.buildSTR(STR_FUNC[5], str, start, end, newChars);
    }

    public static StringObject insert(StringObject str, NumericObject offset, StringObject newChars) {
        return StringObject.buildSTR(STR_FUNC[6], str, offset, newChars);
    }

    public static StringObject getPage() {
        return StringObject.buildSTR(STR_FUNC[7]);
    }

    public static StringObject getTotalPages() {
        return StringObject.buildSTR(STR_FUNC[8]);
    }

    public static StringObject getTotalSections() {
        return StringObject.buildSTR(STR_FUNC[9]);
    }

    public static NumericObject strlen(StringObject a) {
        return StringObject.buildNUM(NUM_FUNC[34], a);
    }

    public static NumericObject lastIndexOf(StringObject str, StringObject searchChars) {
        return StringObject.buildNUM(NUM_FUNC[35], (IObject)str, searchChars);
    }

    public static NumericObject lastIndexOf(StringObject str, StringObject searchChars, NumericObject fromIndex) {
        return StringObject.buildNUM(NUM_FUNC[35], str, searchChars, fromIndex);
    }

    public static NumericObject indexOf(StringObject str, StringObject searchChars) {
        return StringObject.buildNUM(NUM_FUNC[36], (IObject)str, searchChars);
    }

    public static NumericObject indexOf(StringObject str, StringObject searchChars, NumericObject fromIndex) {
        return StringObject.buildNUM(NUM_FUNC[36], str, searchChars, fromIndex);
    }

    public static NumericObject toNumeric(StringObject str) {
        return StringObject.buildNUM(NUM_FUNC[37], str);
    }
}

