/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.queryproc;

import quadbase.reportdesigner.queryproc.Aggregator;

class AggrMinMax
extends Aggregator {
    double d;
    int aggrType;
    boolean hasValues = false;

    public AggrMinMax(int sqlType, int minMaxType) {
        super(sqlType);
        if (minMaxType != 1 && minMaxType != 2) {
            throw new IllegalArgumentException("Invalid aggregate type :" + minMaxType);
        }
        this.aggrType = minMaxType;
        this.d = this.aggrType == 1 ? Double.MIN_VALUE : Double.MAX_VALUE;
    }

    @Override
    public void aggregate(Object p) {
        if (p == null) {
            return;
        }
        if (!(p instanceof Number)) {
            throw new IllegalArgumentException("Attempt to perform sum on non-numeric object: " + p);
        }
        this.hasValues = true;
        double x = ((Number)p).doubleValue();
        if (this.aggrType == 2 && x < this.d) {
            this.d = x;
        }
        if (this.aggrType == 1 && x > this.d) {
            this.d = x;
        }
    }

    @Override
    public Object getResult() {
        if (!this.hasValues) {
            return null;
        }
        return this.d;
    }
}

