/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.queryproc;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.reportdesigner.queryproc.ICollationKey;
import quadbase.reportdesigner.queryproc.ICollator;
import quadbase.reportdesigner.queryproc.IRECProvider;
import quadbase.reportdesigner.queryproc.IRoundingFunc;
import quadbase.reportdesigner.util.internal.DateTime;

class DateRECProvider
implements IRECProvider,
ICollator,
IRoundingFunc,
Enumeration {
    private static final Logger LOGGER = Logger.getLogger(DateRECProvider.class.getName());
    static final int MAX_ELEMENTS = 100;
    int sqlType;
    long ltVal = Long.MIN_VALUE;
    long utVal = Long.MAX_VALUE;
    long refVal = 0L;
    Date refTS;
    int timeUnit;
    int increment;
    boolean bRangeOnly;
    Date nextTS;
    long eutVal;
    boolean complete = false;
    long unitMS;
    int count = 0;

    public DateRECProvider(Date lBoundTS, Date uBoundTS, int timeUnit, int increment, int sqlType) {
        if (timeUnit < 0 || timeUnit >= 7) {
            throw new IllegalArgumentException("Invalid time units " + timeUnit);
        }
        if (increment <= 0) {
            increment = 1;
        }
        if (lBoundTS != null && uBoundTS != null && lBoundTS.after(uBoundTS)) {
            throw new IllegalArgumentException("Date/time interval is empty");
        }
        this.timeUnit = timeUnit;
        this.increment = increment;
        this.sqlType = sqlType;
        this.unitMS = DateTime.getMilliseconds(timeUnit);
        this.refVal = -1 * TimeZone.getDefault().getRawOffset();
        if (lBoundTS != null) {
            Date lt = DateTime.approxDate(lBoundTS, timeUnit);
            this.ltVal = lt.getTime();
            lt = this.getSQLDate(this.ltVal);
            this.refVal = this.ltVal = lt.getTime();
        }
        this.refTS = new Timestamp(this.refVal);
        if (uBoundTS != null) {
            Date ut = DateTime.approxDate(uBoundTS, timeUnit);
            this.utVal = DateTime.getDateVal(ut, timeUnit, (long)increment);
            ut = this.getSQLDate(this.utVal);
            this.utVal = ut.getTime();
            if (lBoundTS != null) {
                ++this.utVal;
                ut = (Date)this.roundOff(ut);
                this.utVal = ut.getTime();
            } else {
                this.refVal = this.utVal;
                this.refTS = new Timestamp(this.refVal);
            }
        }
    }

    protected long getTSValue(Object id) {
        if (id instanceof Timestamp) {
            Timestamp t = (Timestamp)id;
            return t.getTime() + (long)(t.getNanos() / 1000000);
        }
        try {
            return ((Date)id).getTime();
        }
        catch (ClassCastException e) {
            LOGGER.log(Level.FINEST, "Invalid date/time value", e);
            throw new IllegalArgumentException("Object " + id + " not an instance of date/time");
        }
    }

    @Override
    public boolean isRangeOnly() {
        return this.bRangeOnly;
    }

    @Override
    public void setRangeOnly(boolean b) {
        this.bRangeOnly = b;
    }

    @Override
    public Object roundOff(Object p0) {
        long l0 = this.getTSValue(p0);
        long dateVal = 0L;
        if (l0 < this.ltVal || l0 >= this.utVal) {
            return null;
        }
        if (this.timeUnit <= 4) {
            long diff = (long)Math.floor((float)(l0 - this.refVal) / (float)((long)this.increment * this.unitMS));
            dateVal = DateTime.getDateVal(this.refVal, this.timeUnit, (long)this.increment * diff);
        } else if (this.timeUnit == 5) {
            Timestamp t0 = new Timestamp(l0);
            long diff = (long)Math.floor((float)((t0.getYear() - this.refTS.getYear()) * 12 + t0.getMonth() - this.refTS.getMonth()) / (float)this.increment);
            dateVal = DateTime.getDateVal(this.refVal, this.timeUnit, (long)this.increment * diff);
        } else if (this.timeUnit == 6) {
            Timestamp t0 = new Timestamp(l0);
            long diff = (long)Math.floor((float)(t0.getYear() - this.refTS.getYear()) / (float)this.increment);
            dateVal = DateTime.getDateVal(this.refVal, this.timeUnit, (long)this.increment * diff);
        } else {
            return null;
        }
        return this.getSQLDate(dateVal);
    }

    Date getSQLDate(long dateVal) {
        switch (this.sqlType) {
            case 91: {
                return new java.sql.Date(dateVal);
            }
            case 92: {
                return new Time(dateVal);
            }
        }
        return new Timestamp(dateVal);
    }

    @Override
    public ICollationKey getCollationKey(Object x) {
        return new DateCollationKey(x);
    }

    @Override
    public ICollator getCollator() {
        return this;
    }

    @Override
    public IRoundingFunc getRoundingFunc() {
        return this;
    }

    @Override
    public Enumeration getEnumeration(Object l, Object u) {
        if (l == null || u == null) {
            throw new IllegalArgumentException("Bounds for enumeration may not be null!");
        }
        long eltVal = this.getTSValue(DateTime.approxDate((Date)l, this.timeUnit));
        this.eutVal = this.getTSValue(DateTime.approxDate((Date)u, this.timeUnit));
        this.nextTS = this.getSQLDate(eltVal);
        eltVal = this.getTSValue(this.nextTS);
        this.eutVal = this.getTSValue(this.getSQLDate(this.eutVal));
        if (eltVal >= this.eutVal) {
            this.complete = true;
        }
        return this;
    }

    @Override
    public boolean hasMoreElements() {
        return !this.complete;
    }

    public Object nextElement() {
        if (this.complete) {
            return null;
        }
        Date retObject = this.nextTS;
        long nextVal = DateTime.getDateVal(this.nextTS, this.timeUnit, (long)this.increment);
        this.nextTS = this.getSQLDate(nextVal);
        boolean bl = this.complete = nextVal >= this.eutVal;
        if (++this.count > 100) {
            this.complete = true;
        }
        return retObject;
    }

    public class DateCollationKey
    implements ICollationKey {
        Date source;
        long value;

        public DateCollationKey(Object d) {
            this.value = DateRECProvider.this.getTSValue(d);
            this.source = (Date)d;
        }

        @Override
        public int compareTo(ICollationKey key) {
            long val2 = ((DateCollationKey)key).value;
            return this.value > val2 ? 1 : (this.value == val2 ? 0 : -1);
        }

        @Override
        public boolean equals(Object key) {
            long val2 = ((DateCollationKey)key).value;
            return this.value == val2;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public Object getSourceObject() {
            return this.source;
        }
    }
}

