/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.queryproc;

import java.util.Enumeration;
import quadbase.reportdesigner.queryproc.ICollationKey;
import quadbase.reportdesigner.queryproc.ICollator;
import quadbase.reportdesigner.queryproc.IRECProvider;
import quadbase.reportdesigner.queryproc.IRoundingFunc;

class FloatRECProvider
implements IRECProvider,
ICollator,
IRoundingFunc,
Enumeration {
    int sqlType;
    double lbVal = Double.MIN_VALUE;
    double ubVal = Double.MAX_VALUE;
    double refVal;
    double increment;
    double nextVal;
    Number nextObj;
    double eubVal;
    boolean bRangeOnly;
    boolean complete = false;
    int count = 0;

    public FloatRECProvider(Number lBound, Number uBound, double incr, int type) {
        this.increment = incr > 0.0 ? incr : 0.0;
        this.sqlType = type;
        if (lBound != null) {
            this.refVal = this.lbVal = lBound.doubleValue();
        }
        if (uBound != null) {
            this.ubVal = uBound.doubleValue();
            if (lBound != null) {
                this.ubVal += 1.0;
                Number ut = (Number)this.roundOff(uBound);
                this.ubVal = ut.doubleValue();
                this.ubVal += this.increment;
            } else {
                this.refVal = this.ubVal;
            }
        }
    }

    @Override
    public boolean isRangeOnly() {
        return this.bRangeOnly;
    }

    @Override
    public void setRangeOnly(boolean b) {
        this.bRangeOnly = b;
    }

    @Override
    public Object roundOff(Object p0) {
        double l0 = ((Number)p0).doubleValue();
        if (l0 < this.lbVal || l0 >= this.ubVal) {
            return null;
        }
        if (this.bRangeOnly || this.increment == 0.0) {
            return p0;
        }
        long diff = (long)((l0 - this.refVal) / this.increment);
        double d = this.refVal + this.increment * (double)diff;
        return this.getNumericValue(d);
    }

    Number getNumericValue(double d) {
        switch (this.sqlType) {
            case 7: {
                return Float.valueOf((float)d);
            }
            case 6: 
            case 8: {
                return d;
            }
        }
        throw new IllegalArgumentException("Invalid SQL type: " + this.sqlType);
    }

    @Override
    public ICollator getCollator() {
        return this;
    }

    @Override
    public IRoundingFunc getRoundingFunc() {
        return this;
    }

    @Override
    public Enumeration getEnumeration(Object l, Object u) {
        if (l == null || u == null) {
            throw new IllegalArgumentException("Bounds for enumeration may not be null!");
        }
        if (!(l instanceof Number) || !(u instanceof Number)) {
            throw new IllegalArgumentException("Non-numeric bounds specified!");
        }
        Number elb = (Number)l;
        Number eub = (Number)u;
        this.nextObj = elb;
        this.nextVal = elb.doubleValue();
        this.eubVal = eub.doubleValue();
        return this;
    }

    @Override
    public boolean hasMoreElements() {
        return !this.complete;
    }

    public Object nextElement() {
        if (this.complete) {
            return null;
        }
        Number retObject = this.nextObj;
        this.nextVal += this.increment;
        this.nextObj = this.getNumericValue(this.nextVal);
        boolean bl = this.complete = this.nextVal >= this.eubVal;
        if (++this.count > 100) {
            this.complete = true;
        }
        return retObject;
    }

    @Override
    public ICollationKey getCollationKey(Object x) {
        return new FloatCollationKey(x);
    }

    public class FloatCollationKey
    implements ICollationKey {
        Number source;
        double value;

        public FloatCollationKey(Object d) {
            this.source = (Number)d;
            this.value = this.source.doubleValue();
        }

        @Override
        public int compareTo(ICollationKey key) {
            double delta = this.value - ((FloatCollationKey)key).value;
            return delta > 0.0 ? 1 : (delta == 0.0 ? 0 : -1);
        }

        @Override
        public boolean equals(Object key) {
            return ((FloatCollationKey)key).value == this.value;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public Object getSourceObject() {
            return this.source;
        }
    }
}

