/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.queryproc;

import java.util.Enumeration;
import quadbase.reportdesigner.queryproc.ICollationKey;
import quadbase.reportdesigner.queryproc.ICollator;
import quadbase.reportdesigner.queryproc.IRECProvider;
import quadbase.reportdesigner.queryproc.IRoundingFunc;

class IntRECProvider
implements IRECProvider,
ICollator,
IRoundingFunc,
Enumeration {
    int sqlType;
    long lbVal = Long.MIN_VALUE;
    long ubVal = Long.MAX_VALUE;
    long refVal;
    long increment;
    long nextVal;
    Number nextObj;
    long eubVal;
    boolean bRangeOnly;
    boolean complete = false;
    int count = 0;

    public IntRECProvider(Number lBound, Number uBound, long incr, int type) {
        this.increment = incr > 0L ? incr : 0L;
        this.sqlType = type;
        if (lBound != null) {
            this.refVal = this.lbVal = lBound.longValue();
        }
        if (uBound != null) {
            this.ubVal = uBound.longValue();
            if (lBound != null) {
                ++this.ubVal;
                Number ut = (Number)this.roundOff(uBound);
                this.ubVal = ut.longValue();
                this.ubVal += this.increment;
            } else {
                this.refVal = this.ubVal;
            }
        }
    }

    @Override
    public boolean isRangeOnly() {
        return this.bRangeOnly;
    }

    @Override
    public void setRangeOnly(boolean b) {
        this.bRangeOnly = b;
    }

    @Override
    public Object roundOff(Object p0) {
        long l0 = ((Number)p0).longValue();
        if (l0 < this.lbVal || l0 >= this.ubVal) {
            return null;
        }
        if (this.bRangeOnly || this.increment == 0L) {
            return p0;
        }
        long diff = (l0 - this.refVal) / this.increment;
        long d = this.refVal + this.increment * diff;
        return this.getNumericValue(d);
    }

    Number getNumericValue(long d) {
        switch (this.sqlType) {
            case 4: {
                return (int)d;
            }
            case 5: {
                return (short)d;
            }
            case -6: {
                return (byte)d;
            }
            case -5: {
                return d;
            }
        }
        throw new IllegalArgumentException("Invalid SQL type: " + this.sqlType);
    }

    @Override
    public ICollator getCollator() {
        return this;
    }

    @Override
    public IRoundingFunc getRoundingFunc() {
        return this;
    }

    @Override
    public Enumeration getEnumeration(Object l, Object u) {
        if (l == null || u == null) {
            throw new IllegalArgumentException("Bounds for enumeration may not be null!");
        }
        if (!(l instanceof Number) || !(u instanceof Number)) {
            throw new IllegalArgumentException("Non-numeric bounds specified!");
        }
        Number elb = (Number)l;
        Number eub = (Number)u;
        this.nextObj = elb;
        this.nextVal = elb.longValue();
        this.eubVal = eub.longValue();
        return this;
    }

    @Override
    public boolean hasMoreElements() {
        return !this.complete;
    }

    public Object nextElement() {
        if (this.complete) {
            return null;
        }
        Number retObject = this.nextObj;
        this.nextVal += this.increment;
        this.nextObj = this.getNumericValue(this.nextVal);
        boolean bl = this.complete = this.nextVal >= this.eubVal;
        if (++this.count > 100) {
            this.complete = true;
        }
        return retObject;
    }

    @Override
    public ICollationKey getCollationKey(Object x) {
        return new IntCollationKey(x);
    }

    public class IntCollationKey
    implements ICollationKey {
        Number source;
        long value;

        public IntCollationKey(Object d) {
            this.source = (Number)d;
            this.value = this.source.longValue();
        }

        @Override
        public int compareTo(ICollationKey key) {
            long y = ((IntCollationKey)key).value;
            return (int)(this.value - y);
        }

        @Override
        public boolean equals(Object key) {
            return ((IntCollationKey)key).value == this.value;
        }

        @Override
        public Object getSourceObject() {
            return this.source;
        }
    }
}

